/*****************************************************************************
**************************** BEING HEADER FILE *******************************
******************************************************************************
*                                                                            *
* Module full name:  Being Module
*                                                                            *
* Description:                                                               *
*    The Being class represents a field dwelling entity that can move.       *
*                                                                            *
* Classes list:                                                              *
*    - class Being
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, December 2004.                                   *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_BEING_H      // prevent header from
#define LAMP_BEING_H 1    // being included twice

/* Includes */
#include "thing.h"
#include "map.h"

#include "GFXSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/


/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;

 //---------------------------------------------------------------------------||
// BEGIN NAMESPACE BEING -----------------------------------------------------\/
namespace BEING {

// BEING FLAGS
const ULONG ANIMATING = 0x40;

// BEING STATE
const ULONG IDLE    = 0x0000;
const ULONG WALKING = 0x0100;

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

}// END OF BEING NAMESPACE ---------------------------------------------------/\
//----------------------------------------------------------------------------||

#define MAX_NAME_LENGHT 32

/*****************************************************************************
******************************************************************************
***                              Classes                                   ***
******************************************************************************
*****************************************************************************/


/***************************************************************
 * Class: Being                                                *
 *                                                             *
 * Description: Thing that can move in the field. Only one     *
 *   Being can be in a place at a time.                        *
 *                                                             *
 * Member data:                                                *
 *    -> pos      -- Inherited from Thing is the being's tile  *
 *                   location.                                 *
 *    -> facing   -- Tells the direction in which the being is *
 *                   facing. It uses the Direction enumeration.*
 *    -> movedir  -- Movement vector.                          *
 *    -> offset   -- Offset from tile location in pixels.      *
 *    -> gfx      -- Being's imagery index to graphics set.    *
 *    -> animstep -- Animation current state.                  *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class Being : public Thing {
public:
   Being();                                   // default constructor
   virtual ~Being();                          // destructor
   // Questions
   bool walkingQ();
   bool animatingQ();
   // Actions
   int face( Direction::Direction );
   int walk( Map*, Direction::Direction );
   // Graphics
   int draw( BITMAP *dest, GFXSet *set, int x, int y );
private:
   Being( const Being &rvalue );              // copy constructor
   Being& operator= ( const Being &rvalue );  // assignment operator
//   Being operator= ( const int &rvalue );
protected:
   void setWalkFlag();
   void clearWalkFlag();
   void setAnimating() {}
   void clearAnimating() {}
   int getWalkDirection() { return facing; }

   // DATA
   char name[MAX_NAME_LENGHT];
   
   UBYTE facing;
   intXY movedir;
   intXY offset;
   intXY gfx;
   int animstep; // animation step
   int tempo;
}; // END OF CLASS Being DECLARATION


/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/


#endif
/* end of the initial ifndef, don't write more code after this line.
   (unless you know exactly what you're doing by that.) */

/* FINAL IMPORTANT REMARKS:

   Still needs some work!  =)

   Miguel Jos
*/
