/*****************************************************************************
**************************** TILE ENGINE HEADER FILE *************************
******************************************************************************
*                                                                            *
* Module full name:  Tile Engine                                             *
*                                                                            *
* Purpose: Controls the display details of the map.                          *
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class TileEngine
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Module version: 0.01.000  ( development version 1 beta )                   *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Genesis / Miguel Jos, October 2004.                          *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_TILE_ENGINE_H      // prevent header from
#define LAMP_TILE_ENGINE_H 1    // being included twice

/* Includes */
#include "thing.h"
#include "map.h"
#include "tileset.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/


/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/

/***************************************************************
 * struct: ViewPort                                            *
 ***************************************************************/
struct ViewPort {
   int ax, ay; // anchor values
   int w, h;  // dimentions: width and height
   ViewPort(){}                                   // default constructor
   ViewPort( const int &anchor_x, const int &anchor_y,
             const int &width, const int &height )
   {
      ax = anchor_x;
      ay = anchor_y;
      w = width;
      h = height;
   }
   ~ViewPort(){}                          // destructor
}; // END OF STRUCT ViewPort

/***************************************************************
 * Class: TileEngine
 *                                                             *
 * Description: A template for a class, not a template class.
 *                                                             *
 * Member data:                                                *
 *    -> data.                                                 *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class TileEngine : public Map {
public:
   TileEngine( int =20, int =15);                  // default constructor
   virtual ~TileEngine();                          // destructor
   // Getz
   unsigned int getTimer();
   // Setz
   void resetTimer();
   // ViewPort routines
   int moveViewPort( intXY vect ); // vect is a displacement vector
   int moveViewPortLEFT();
   int moveViewPortRIGHT();
   int moveViewPortUP();
   int moveViewPortDOWN();
   // Object and Map routines
   // Being routines
   int loadBeing( Being* );
   // Drawing routines
   void clearBuffer();
   int drawMap( int x0=0, int y0=0 );
   int drawThings( int x0=0, int y0=0 );
   int showField();

private:
   TileEngine( const TileEngine &rvalue );              // copy constructor
   TileEngine& operator= ( const TileEngine &rvalue );  // assignment operator
//   TileEngine operator= ( const int &rvalue );

   int SetTimer();
   int RemoveTimer();
protected:
   ViewPort tvp; // tile viewport
   BITMAP *buffer;
   TileSet tileset;
   IGFXSet spriteset;

   int tilewidth, tileheight;
}; // END OF CLASS TileEngine DECLARATION



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif