/*****************************************************************************
************************** MESSAGE QUEUE HEADER FILE *************************
******************************************************************************
*                                                                            *
* Module full name:  Message Module
*                                                                            *
* Purpose:
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class MessageQueue
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, September 2004.                                  *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_MSGQ_H      // prevent header from
#define LAMP_MSGQ_H 1    // being included twice

/* Includes */
#include "message.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

 //---------------------------------------------------------------------------||
// BEGIN NAMESPACE MessageQueue --------------------------------------------\/
namespace MessageQueue {

const int MAX_MSGQUEUE_SIZE = 64;

/*****************************************************************************
******************************************************************************
***                              Classes                                   ***
******************************************************************************
*****************************************************************************/


/***************************************************************
 * Class: MessageQueue
 *                                                             *
 * Description: This class is the message queue.               *
 *              For now this queue is implemented using a      *
 *           staticly alocated array, when the queue is full   *
 *           any new messages enqueued are discarted.          *
 *                                                             *
 * Member data:                                                *
 *    -> data.                                                 *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class MessageQueue {
public:
   MessageQueue();                                   // default constructor
   virtual ~MessageQueue();                          // destructor
   // METHODS
   int enqueue( Message );
   Message dequeue( );
   int insertAtFront( Message );
   // getz
   int count() { return msgcount; }
   // questions
   bool queueEmptyQ() { return msgcount == 0; }
   bool emptyQ() { return msgcount == 0; }
   bool messagePendingQ() { return !queueEmptyQ(); }
private:
   MessageQueue( const MessageQueue &rvalue );              // copy constructor
   MessageQueue& operator= ( const MessageQueue &rvalue );  // assignment operator
//   MessageQueue operator= ( const int &rvalue );
protected:
   Message msgq[MAX_MSGQUEUE_SIZE]; // message queue
   int head, tail;
   int maxsize, msgcount;
   bool overflow;
}; // END OF CLASS MessageQueue DECLARATION

}// END OF MessageQueue NAMESPACE ------------------------------------------/\
//----------------------------------------------------------------------------||

/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/


// Usefull using declarations
// Turning this class visible for anyone that includes this file
using MessageQueue::MessageQueue;


#endif
