/*****************************************************************************
**************************** GRAPHSET HEADER FILE ****************************
******************************************************************************
*                                                                            *
* Module full name:  Graphics Set Module
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class GraphSet
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Genesis / Miguel Jos, September 2004.                        *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_GRAPHSET_H      // prevent header from
#define LAMP_GRAPHSET_H 1    // being included twice

/* Includes */
#include <allegro.h>

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

#define CELL_WIDTH  16
#define CELL_HEIGHT 16

/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/


/***************************************************************
 * Class: GraphSet                                             *
 *                                                             *
 * Description: Provides a way to draw indexed graphics from a *
 *    bitmap. An Image Set.                                    *
 *                                                             *
 * Member data:                                                *
 *   -> gw,gh  -- Width and height of the graphic cell         *
 *                contained in the Set;                        *
 *   -> w,h    -- Dimentions of the bmp in nr of graphics of   *
 *                the previous defined gw and gh;              *
 *   -> length -- Number of graphic cells in the bitmap;       *
 *   -> bmp    -- The bimmap containing the tiles.             *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class GraphSet {
public:
   GraphSet( int cellw = CELL_WIDTH, int cellh = CELL_HEIGHT );
   GraphSet( const char * filename,
             int cellw = CELL_WIDTH, int cellh = CELL_HEIGHT );
   virtual ~GraphSet();                          // destructor
   // Methods
   int load( const char * filename );
   // Getz
   int getTileWidth() { return w; }
   int getTileHeight() { return h; }
   // Questions
   bool emptyQ() { return (bmptr == NULL); }
   // Graphics
   int draw( BITMAP *destbmp, int index, int x, int y );
private:
   GraphSet( const GraphSet &rvalue );              // copy constructor
   GraphSet& operator= ( const GraphSet &rvalue );  // assignment operator
//   GraphSet operator= ( const int &rvalue );
protected:
   int cw,ch;  // Cell width and height in pixels
   int w,h,length; // Dimentions of the Set in cells
   BITMAP *bmptr;  // Bitmap that contains the imagery.
}; // END OF CLASS GraphSet DECLARATION



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif
