/*****************************************************************************
***************************** IGFXSET SUB-MODULE *****************************
* version 0.00.000 ***********************************************************
*********************************************************** November 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class IGFXSet                                                         *
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history:                                                          *
*   Last revision November 2004.                                             *
*                                                                            *
* Notes: NO ERROR HANDLING!                                                  *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos 2004.                                                *
*                                                                            *
*****************************************************************************/

#include "IGFXSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/




/* External variables */
extern PALETTE GraphicsColorPalette; // GFXSet color palette, mostly used as a dummy.
extern int DEBUG_TEXT_LINE;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;


/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class IGFXSet                                *
*****************************************************************************/

// Standard Constructor
IGFXSet::IGFXSet( int cell_w, int cell_h )
: GFXSet(IGFXSET_ID), cw(cell_w), ch(cell_h), sw(0), sh(0)
{}

// By file constructor
IGFXSet::IGFXSet( const char * filename, int cell_w, int cell_h )
: GFXSet(filename), cw(cell_w), ch(cell_h)
{
   idnr = IGFXSET_ID;
   sw = getWidth() / cw;
   sh = getHeight() / ch;
}

// By BITMAP constructor
IGFXSet::IGFXSet( BITMAP *bitmap, int cell_w, int cell_h )
: GFXSet(bitmap), cw(cell_w), ch(cell_h)
{
   idnr = IGFXSET_ID;
   sw = getWidth() / cw;
   sh = getHeight() / ch;
}

// Destructor
IGFXSet::~IGFXSet()
{}

// Copy constructor
/*
IGFXSet::IGFXSet( const IGFXSet &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
IGFXSet& IGFXSet::operator= ( const IGFXSet &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}
*/

//----------------|
// PUBLIC METHODS |
//----------------|

//--- Loading routines --->

// Loads a IGFXSet from a file (.bmp,.tga,.pcx)
// Returns 0 on success.
int IGFXSet::loadfile( const char * filename )
{
   if ( !EmptyQ() )
      destroy_bitmap( gfx );

   gfx = load_bitmap( filename, GraphicsColorPalette );
   
   if( gfx == NULL ) return -1; // We have a problem!
   
   return 0;
}

// Loads a IGFXSet from a BITMAP structure
// Returns 0 on success.
int IGFXSet::loadBITMAP( BITMAP *bitmap )
{
   if ( !EmptyQ() )
      destroy_bitmap( gfx );
      
   gfx = create_bitmap( bitmap->w, bitmap->h );

   if( gfx == NULL ) return -1; // We have a problem!
   
   clear_bitmap( gfx );
   
   blit( bitmap, gfx, 0,0, 0,0, gfx->w, gfx->h );

   return 0;
}

//--- Questions --->

bool IGFXSet::indexOutOfRangeQ( const int &indexX, const int &indexY ) const
{
   return ( ((indexX>=sw)||(indexY>=sh)) || ((indexX<0)||(indexY<0)) );
}
bool IGFXSet::indexOutOfRangeQ( const int &index ) const
{
   return ( (index >= sw*sh ) || (index<0) );
}

//--- Drawing routines --->

// Draws indexed cell in destbmp position (x,y)
// Returns -2 if coordinates are invalid
int IGFXSet::draw( BITMAP *destbmp, int indexX, int indexY, int x, int y ) const
{
   if( indexOutOfRangeQ(indexX,indexY) ) return -2;
   return GFXSet::draw( destbmp, indexX*cw, indexY*ch, x,y, cw,ch );
}

// Draws indexed cell in destbmp position (x,y)
// Returns -2 if coordinates are invalid
int IGFXSet::draw( BITMAP *destbmp, int index, int x, int y ) const
{
   if( indexOutOfRangeQ(index) ) return -2;
   int indexX = index % sw; // column
   int indexY = index / sw; // line
   return GFXSet::draw( destbmp, indexX*cw, indexY*ch, x,y, cw,ch );
}



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
