/*****************************************************************************
****************************** TILESET MODULE **********************************
* version 0.00.000 ***********************************************************
********************************************************** September 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class GraphSet
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: NO ERROR HANDLING!                                                  *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, September 2004.                                     *
*                                                                            *
*****************************************************************************/

#include "GraphSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

PALETTE GraphSetColor; // GraphSet color palette, mustly used as a dummy.


/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;


/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class GraphSet                                  *
*****************************************************************************/

// Standard constructor
GraphSet::GraphSet( int cellw, int cellh )
: cw(cellw), ch(cellh), w(0), h(0), length(w*h), bmptr( NULL )
{
}

// File load constructor
GraphSet::GraphSet( const char* filename, int cellw, int cellh )
: cw(cellw), ch(cellh), w(0), h(0), length(w*h), bmptr( NULL )
{
   if( load( filename ) != 0 ) {
      bmptr = NULL;
      length = w = h = 0;
   }
}

// Destructor
GraphSet::~GraphSet()
{
   if ( bmptr != NULL ) {
      destroy_bitmap( bmptr );
   }
   length = w = h = 0;
}

// Copy constructor
GraphSet::GraphSet( const GraphSet &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
GraphSet& GraphSet::operator= ( const GraphSet &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}


//----------------|
// PUBLIC METHODS |
//----------------|

// Loads a GraphSet from a file (.bmp,.tga,.pcx)
// Returns 0 on success.
int GraphSet::load( const char * filename )
{
   bmptr = load_bitmap( filename, GraphSetColor );
   
   if( bmptr == NULL ) {
      return -1; // we have a problem!
   }
   
   w = bmptr->w / cw;
   h = bmptr->h / ch;
   length = w * h;
   return 0;
}

// Draws tile indexed by index in the specified x,y location on the
// destination bitmap, dest.
// Return 0 on success.
int GraphSet::draw( BITMAP *destbmp, int index, int x, int y )
{
   if ( emptyQ() ) return -1;
   if ( destbmp == NULL ) return 0;
   int sx = (index % w)*cw;
   int sy = (index / w)*ch;
   blit( bmptr, destbmp, sx, sy, x, y, cw, ch );
   return 0;
}



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i konw!
// Miguel Jos 2nd August 2004.
