/*****************************************************************************
************************ GRAPHICS MODULE :: BASIC SETS************************
* version 0.00.000 ***********************************************************
*********************************************************** December 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class GFXSet
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be fine."      *
*                                                                            *
* Notes: NO ERROR HANDLING!                                                  *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include "GFXSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

PALETTE GraphicsColorPalette; // GFXSet color palette, mostly used as a dummy.

/* External variables */
extern int DEBUG_TEXT_LINE;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;


/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class GFXSet                                  *
*****************************************************************************/

// By file constructor
GFXSet::GFXSet( const char * filename )
: gfx(0),idnr(0) // Because i didn't clear this, i've passed 1hour tracing a bug, just to find that in the next function i was tring to destroy a non existing bitmap, thereby making a memory violation!
{
   loadfile( filename );
}

// By BITMAP constructor
GFXSet::GFXSet( BITMAP *bitmap )
: idnr(0)
{
   loadBITMAP( bitmap );
}

// Destructor
GFXSet::~GFXSet()
{
   if( !EmptyQ() )
      destroy_bitmap( gfx );
}

// Copy constructor
/*
GFXSet::GFXSet( const GFXSet &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
GFXSet& GFXSet::operator= ( const GFXSet &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}
*/


//----------------|
// PUBLIC METHODS |
//----------------|

// Loads a GFXSet from a file (.bmp,.tga,.pcx)
// Returns 0 on success.
int GFXSet::loadfile( const char * filename )
{
   if ( !EmptyQ() )
      destroy_bitmap( gfx );

   gfx = load_bitmap( filename, GraphicsColorPalette );
   
   if( gfx == NULL ) return -1; // We have a problem!
   
   char str[80];
   sprintf(str,"GFXSet::loadfile \"%s\" loaded",filename);
   textout(screen, font, str,0, DEBUG_TEXT_LINE*10, makecol(255,255,255));
   ++DEBUG_TEXT_LINE;

   return 0;
}

// Loads a GFXSet from a BITMAP structure
// If you pass a null pointer the previously set GFXSet will become empty,
// so be aware of this side efect when loading from unchecked BITMAP pointers.
// Returns 0 on success.
int GFXSet::loadBITMAP( BITMAP *bitmap )
{
   if ( !EmptyQ() )
      destroy_bitmap( gfx );

   if ( bitmap == NULL ) {
      gfx = NULL;
      return 0;
   }
      
   gfx = create_bitmap( bitmap->w, bitmap->h );

   if( gfx == NULL ) return -1; // We have a problem!
   
   clear_bitmap( gfx );
   
   masked_blit( bitmap, gfx, 0,0, 0,0, gfx->w, gfx->h );

   return 0;
}

// Draws rectangular section of width, w and height, h
// from (sx,sy) to destbmp (x,y) coordinates.
int GFXSet::draw( BITMAP *destbmp, int sx, int sy, int x, int y, int w, int h ) const
{
   if ( EmptyQ() ) return -1;
   if ( destbmp == NULL ) return 0;
   
   masked_blit( gfx, destbmp, sx, sy, x, y, w, h );
   return 0;
}

// Sets Color Palette
void GFXSet::setColorPalette()
{
   set_palette( GraphicsColorPalette );
}


/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}
