/*****************************************************************************
****************************** THING MODULE **********************************
* version 0.00.000 ***********************************************************
********************************************************** September 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class Thing
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, September 2004.                                     *
*                                                                            *
*****************************************************************************/

#include "thing.h"
#include <iostream>

using namespace THING;

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class Thing                                  *
*****************************************************************************/

// Default constructor
Thing::Thing()
{
   type = 0;
   fStatus = 0;
   pos.x = pos.y = -1;
}

Thing::Thing( ULONG IDnr, ULONG type_ )
: ID(IDnr), type(type_)
{
   fStatus = 0;
   pos.x = pos.y = -1;
}

// Destructor
Thing::~Thing()
{
   // Clean up after himself. Prevent memory leaks.
}

// Copy constructor
Thing::Thing( const Thing &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
Thing& Thing::operator= ( const Thing &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//----------------|
// PUBLIC METHODS |
//----------------|

//-- GETZ -->

//-- SETZ -->

void Thing::setPosition( intXY coord )
{  pos = coord; }

void Thing::setPosition( int x, int y )
{
   pos.x = x;
   pos.y = y;
}

//-- Questions -->

// Is the Thing in the limbo state (not on the map)?
bool Thing::limboQ() {
   return ( (fStatus & INMAP) == 0 );
}

bool Thing::inMapQ() {
   return ( (fStatus & INMAP) == INMAP );
}

bool Thing::solidQ()
{
   return ( (fStatus & SOLID) == SOLID );
}

//-- Others -->
void Thing::castUponMap( int x, int y )
{
   setPosition(x,y);
   setFlag(INMAP);
}

void Thing::takenFromMap()
{
   clearFlag(INMAP);
}

int Thing::draw( BITMAP *dest, int x, int y )
{
   circlefill( dest, x+8, y+8, 7, makecol(0,255,0) );
}

int Thing::draw( BITMAP *dest, GFXSet*, int x, int y )
{
   circlefill( dest, x+8, y+8, 7, makecol(0,255,0) );
}

/*****************************************************************************
******************************************************************************
****                 Module Public Functions Prototypes                   ****
******************************************************************************
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
