/*****************************************************************************
****************************** TILE ENGINE MODULE ****************************
* version 0.01.000 ***********************************************************
*********************************************************** November 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class TileEngine
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be fine."      *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include <fstream>
#include "TE.H"
#include "being.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/**** Uses ****/
using std::endl;
using std::fstream;
using std::ios;


/* External variables */
extern fstream errorlog;
extern int DEBUG_TEXT_LINE;

/* Local variables */
static unsigned int TileEngineTimer; // Counts miliseconds

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// TileEngine Timer
void TileEngine_timer_handler() {
   ++TileEngineTimer;
}
END_OF_FUNCTION(TileEngine_timer_handler)

// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class TileEngine                             *
*****************************************************************************/

// Default constructor
TileEngine::TileEngine( int width, int height )
: Map( width,height, grassTile ), tvp(0,0,20,14), tileset("tpal.pcx"), spriteset("npc.pcx",16,16)
{
   tilewidth = tileset.getTileWidth();
   tileheight = tileset.getTileHeight();
   tileset.setColorPalette();
   
   buffer = create_bitmap( tilewidth*tvp.w, tileheight*tvp.h );
   if ( buffer == NULL ) {
      fstream logfile( "log.txt", ios::out | ios::app );
      logfile << "TileEngine:: Could not allocate buffer bitmap." << endl;
      logfile.close();
   }
}

// Destructor
TileEngine::~TileEngine()
{
   // Clean up after himself. Prevent memory leaks.
}

// Copy constructor
TileEngine::TileEngine( const TileEngine &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
TileEngine& TileEngine::operator= ( const TileEngine &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//-----------------|
// PRIVATE METHODS |
//-----------------|

int TileEngine::SetTimer()
{
   TileEngineTimer = 0;
   if( 0 > install_int(TileEngine_timer_handler,1) ) {
      errorlog << "Could not install TileEngine timer." << endl;
      return -1;
   }
   LOCK_VARIABLE(TileEngineTimer);
   LOCK_FUNCTION(TileEngine_timer_handler);
}

int TileEngine::RemoveTimer()
{
   remove_int( TileEngine_timer_handler );
}

//----------------|
// PUBLIC METHODS |
//----------------|

// GETZ
unsigned int TileEngine::getTimer()
{
   return TileEngineTimer;
}

// SETZ
void TileEngine::resetTimer()
{
   TileEngineTimer = 0;
}

//------------------------->
// Move ViewPort routines  >
int TileEngine::moveViewPort( intXY vect ) {
   tvp.ax += vect.x;
   tvp.ay += vect.y;
}

int TileEngine::moveViewPortLEFT()
{ --tvp.ax; return 0; }
int TileEngine::moveViewPortRIGHT()
{ ++tvp.ax; return 0; }
int TileEngine::moveViewPortUP()
{ --tvp.ay; return 0; }
int TileEngine::moveViewPortDOWN()
{ ++tvp.ay; return 0; }
//                         >
//------------------------->

//-- Object routines -->
int TileEngine::loadBeing( Being* being )
{
   return Map::loadBeing( being, (being->getPosition()).x, (being->getPosition()).y );
}

//---------------------\
//-- Drawing routines -->
//---------------------/

void TileEngine::clearBuffer()
{ clear_bitmap(buffer); }

// Draws the map
int TileEngine::drawMap( int x0, int y0 )
{
   int x,y, tx, ty;
   int tx0(tvp.ax<0 ? 0 : tvp.ax);
   int ty0(tvp.ay<0 ? 0 : tvp.ay);
   int guardX = tvp.ax + tvp.w;
   int guardY = tvp.ay + tvp.h;

   if( tvp.ax < 0 ) {
      x0 -= ( tvp.ax * tileset.getTileHeight() );
      tx0 = 0;
   } else tx0 = tvp.ax;
   if( tvp.ay < 0 ) {
      y0 -= ( tvp.ay * tileset.getTileWidth() );
      ty0 = 0;
   } else ty0 = tvp.ay;

   acquire_bitmap( buffer );

   for (int ty=ty0, y=y0 ; ty < guardY && ty < getHeight() && y < (buffer->h); ++ty, y += tileset.getTileHeight() )
      for ( int tx = tx0, x=x0 ; tx < guardX && tx < getWidth() && x < (buffer->w); ++tx, x+=tileset.getTileWidth() ) {
         tileset.drawTile( buffer, getGround(tx,ty), x, y );
   }

   release_bitmap( buffer );
}

// Draws Things
int TileEngine::drawThings( int x0, int y0 )
{
   int x,y;
   Being *Bob = NULL;
   int tx = getWidth();
   int ty = getHeight();
   int tx0 = (tvp.ax>0 ? tvp.ax : 0 );
   int ty0 = (tvp.ay>0 ? tvp.ay : 0 );
   int guardX = tvp.ax + tvp.w;
   int guardY = tvp.ay + tvp.h;
   // setting a guard
   guardX = ( ( guardX < tx ) ? guardX : tx );
   guardY = ( ( guardY < ty ) ? guardY : ty );
   
   for( y=y0, ty = ty0; (ty < guardY) &&(y<(buffer->h)); ++ty, y += tileheight ) {
      for( x=x0, tx = tx0; (tx < guardX) &&(x<(buffer->w)); ++tx, x += tilewidth ) {
         if( occupiedQ(tx,ty) ) {
            Bob = getBeing(tx,ty);
            if( Bob != NULL ) {
               Bob->draw( buffer, spriteset, x,y );
            }
         }
      }
   }
   return 0;
}

// Blits map to screen
int TileEngine::showField()
{
   acquire_bitmap( screen );
//   clear_bitmap(screen);
//   blit( buffer, screen, 0,0, SCREEN_W/2,SCREEN_H/2, buffer->w, buffer->h );
   stretch_blit(buffer, screen, 0,0, buffer->w, buffer->h, SCREEN_W-2*(buffer->w),SCREEN_H-2*(buffer->h), 2*buffer->w,2*buffer->h);
   release_bitmap( screen );
}

/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
