/*****************************************************************************
******************************* DISE INTERNALS *******************************
* version 0.00.000 ***********************************************************
*********************************************************** February 2005 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - Diesel
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, February 2005.                                   *
*                                                                            *
*****************************************************************************/

#include "DISE.H"
#include <allegro.h>

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */

/* Local variables */
static PALETTE Diesel_color_palette;

/* Typedefs */
//typedef definition identifier;

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/



/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/

/*****************************************************************************
*                                Class Diesel                                *
*****************************************************************************/

// Default Constructor
Diesel::Diesel()
{
   initializeALL( GFX_AUTODETECT_WINDOWED, 640, 480, 8 );
}

// Constructor
Diesel::Diesel( int gfx_mode, int s_w, int s_h, int bpp )
{
   initializeALL( gfx_mode, s_w, s_h, bpp );
}

// Destructor
Diesel::~Diesel()
{
   // Clean up after himself. Prevent memory leaks.
   allegro_exit();
}



//-----------------|
// PRIVATE METHODS |
//-----------------|


/***************************************************************
 * Diesel::initialize                                          *
 *    Initializes stuff                                        *
 *     gfx_mode  : graphic mode                                *
 *     s_w & s_h : screen width and height                     *
 * Return: Returns 0 on success.                               *
 ***************************************************************/
int Diesel::initializeALL( int gfx_mode, int s_w, int s_h, int bpp )
{
   set_color_depth(bpp);
   install_allegro( SYSTEM_AUTODETECT, &errno, NULL );

   install_keyboard();

   // set a graphics mode
   if ( 0 != set_gfx_mode( gfx_mode, s_w, s_h, 0, 0) ) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
      allegro_exit();
      exit(1);
      return -1; // !?
   }

   BITMAP *dummy = load_bitmap("colorpal.pcx", Diesel_color_palette );
   destroy_bitmap(dummy);
   set_palette(Diesel_color_palette);

   return 0;
}


//----------------|
// PUBLIC METHODS |
//----------------|

int Diesel::logo()
{
   BITMAP *bmp;
   BITMAP *mot;
   PALETTE pal,wpal;
   for(int i=0; i<256; ++i) {
      wpal[i].r = wpal[i].g = wpal[i].b = 0xFF;
   }

   mot = load_bitmap("genesis.bmp",pal);
   if( mot == NULL ) return -1;
   bmp = load_bitmap("mlogo.bmp",pal);
   if( bmp == NULL ) {
      destroy_bitmap(mot);
      return -1;
   }
   draw_sprite( bmp, mot, (bmp->w/2) - (mot->w/2), 8 );
   
   clear_bitmap(screen);
   set_palette(black_palette);
   
   stretch_blit( bmp,screen,0,0, bmp->w,bmp->h, 0,0, SCREEN_W, SCREEN_H );
   fade_in_range( pal, 1,0,0x7F );
   fade_in_range( pal, 1, 0x80,0x8F );
   readkey();
   fade_in( wpal, 32 );
   set_palette(pal);
   fade_out(2);

   clear_bitmap(screen);
   set_palette(Diesel_color_palette);
   destroy_bitmap(bmp);
   destroy_bitmap(mot);
   return 0;
}


int Diesel::hello()
{
   textout_centre(screen, font, "Hello World!",
      SCREEN_W / 2, SCREEN_H / 2, makecol(255, 255, 255));

   readkey();

   return 0;
}
/*
int Deisel::getScreenWidth() {
   return SCREEN_W;
}

int Diesel::getScreenHeight() {
   return SCREEN_H;
}
*/

/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

