/*****************************************************************************
***************************** TILE HEADER FILE *******************************
******************************************************************************
*                                                                            *
* Module full name:  Tile Module
*                                                                            *
* Purpose:
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - struct basic_tile; (tepedefed to become just plain old Tile type)     *
*    - Tile;                                                                 *
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Genesis / Miguel Jos, August 2004.                           *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISE_TILE_H      // prevent header from
#define DISE_TILE_H 1    // being included twice

/* Includes */

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;


//*******************************//
//           STRUCTS             //
//*******************************//
struct basic_tile {
   unsigned char ground;     // nr of the ground image
   unsigned char midground; // nr of the midgrounf image, used to acomplish tile type transitions.
   unsigned char walk;     // walk-ability flags
   unsigned char pad;     // nr for the over layer image
};

/* Typedefs */
typedef basic_tile Tile;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

const int TILESIZE = 16;
const int TILEWIDTH = TILESIZE;
const int TILEHEIGHT = TILESIZE;

const Tile grassTile = {5,0,0,0};
const Tile Tile16 = {0x16,0,0,0};
const Tile dirtTile  = {3,0,0,0};

/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/


/***************************************************************
 * Class: XXXX2
 *                                                             *
 * Description: A template for a class, not a template class.
 *                                                             *
 * Member data:                                                *
 *    -> data.                                                 *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************
class XXXX2 {
public:
   XXXX2();                                   // default constructor
   virtual ~XXXX2();                          // destructor
private:
   XXXX2( const XXXX2 &rvalue );              // copy constructor
   XXXX2& operator= ( const XXXX2 &rvalue );  // assignment operator
//   XXXX2 operator= ( const int &rvalue );
protected:
   int data;
}; // END OF CLASS XXXX2 DECLARATION
*/


/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif
/* end of the initial ifndef, don't write more code after this line.
   (unless you know exactly what you're doing by that.) */

/* FINAL IMPORTANT REMARKS:

   Still needs some work!  =)

   Miguel Jos
*/
