/*****************************************************************************
**************************** PLAYER HEADER FILE ******************************
******************************************************************************
*                                                                            *
* Module full name:  Player Module
*                                                                            *
* Purpose:
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class Player
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.01.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, December 2004.                                   *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_PLAYER_H      // prevent header from
#define LAMP_PLAYER_H 1    // being included twice

/* Includes */
#include "being.h"
#include "message.h"
#include "GFXEng.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;

struct ControllerConfig {
   int up, down, left, right;
   int confirm, cancel;
   int start, select;
};

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

namespace BUTTON {
   const int UP      = Direction::NORTH;
   const int DOWN    = Direction::SOUTH;
   const int LEFT    = Direction::WEST;
   const int RIGHT   = Direction::EAST;
   const int CONFIRM = 0x100;
   const int CANCEL  = 0x200;
   const int START   = 0x300;
   const int SELECT  = 0x400;
}

 //---------------------------------------------------------------------------||
// BEGIN NAMESPACE PLAYER ----------------------------------------------------\/
namespace PLAYER {

enum PlayerMode {
   FIELD_MODE = 1,
   MENU_MODE  = 2
};

namespace Button {
   enum Button {
      UP      = Direction::NORTH,
      DOWN    = Direction::SOUTH,
      LEFT    = Direction::WEST,
      RIGHT   = Direction::EAST,
      CONFIRM = 0x100,
      CANCEL  = 0x200,
      START   = 0x300,
      SELECT  = 0x400
   };
}
}// END OF PLAYER NAMESPACE --------------------------------------------------/\
//----------------------------------------------------------------------------||

/*****************************************************************************
******************************************************************************
***                              Classes                                   ***
******************************************************************************
*****************************************************************************/


/***************************************************************
 * Class: Player
 *                                                             *
 * Description:
 *                                                             *
 * Member data:                                                *
 *    -> data.                                                 *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class Player {
public:
   Player();                                   // default constructor
   Player( Map*, GraphicEngine* );
   virtual ~Player();                          // destructor
   // GETZ
   Being *getPC() { return heroptr; }
   Being *getPlayerCharacter() { return heroptr; }
   int TranslateKey( int ); // returns 0 if key is not for this player
   Message UseButton();
private:
   Player( const Player &rvalue );              // copy constructor
   Player& operator= ( const Player &rvalue );  // assignment operator
//   Player operator= ( const int &rvalue );
protected:
   struct {
      PLAYER::PlayerMode mode;
   }                      flag;
   ControllerConfig       button;
   PLAYER::Button::Button lbp;  // last button this player pressed
   Message                message;

   Being         *heroptr; // Hungarian notation my ass!
   Map           *pMap;
   GraphicEngine *pGraphicEngine;
}; // END OF CLASS Player DECLARATION

/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/

#endif
