/*****************************************************************************
**************************** MESSAGE HEADER FILE *****************************
******************************************************************************
*                                                                            *
* Module full name:  Message Module                                          *
*                                                                            *
* Purpose:
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, September 2004.                                  *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef LAMP_MESSAGE_H      // prevent header from
#define LAMP_MESSAGE_H 1    // being included twice

/* Includes */
#include "DISEtype.h"
#include <iostream>

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

struct basic_message {
   ULONG   msg;
   XAPXIF4 param1;
   XAPXIF4 param2;
   void*   ptr1;
};

typedef basic_message Message;

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/
namespace GMSG { // game manager message space

// MESSAGES
const ULONG ZERO   = 0x00000000;
// Internal
const ULONG XCHAR  = 0x01000000;
// Being related
const ULONG MOVE   = 0x00010000;
const ULONG WALK   = 0x02010000;
const ULONG RUN    = 0x02020000;
//
const Message NULL_MESSAGE = {0,0,0,0};

}
/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/

std::ostream &operator<<( std::ostream &, const Message & );
std::istream &operator>>( std::istream &, Message & );

#endif
