/*****************************************************************************
***************************** MAP HEADER FILE ********************************
******************************************************************************
*                                                                            *
* Module full name:  Lamp Map Module
*                                                                            *
* Purpose:
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class Map;
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Module version: 0.02.000  ( development version 1 beta )                   *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Genesis / Miguel Jos, October 2004.                          *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISE_MAP_H      // prevent header from
#define DISE_MAP_H 1    // being included twice

/* Includes */
#include "DISEtype.h"
#include "tile.h"
#include "thing.h"
//#include "being.h"


// MACROS & DEFINITONS
#ifndef NULL
#define NULL 0
#endif
/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

// Forward declarations
class Being;

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;


 //---------------------------------------------------------------------------||
// BEGIN NAMESPACE Map -------------------------------------------------------\/
namespace Map {

struct sTileInfo {
   Tile  tile;
   Thing thing;
//   Being being;
};

typedef sTileInfo TileEx;

/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

const unsigned long MAP_EMPTY = 0x0000;

// ACTIONS RETURN VALUES
const int OK            = 0x0000;
const int OUTOFMAP      = 0x0002;

const int CELL_OK       = 0x0000;
const int CELL_OCCUPIED = 0x0001;
const int CELL_OUTOFMAP = 0x0002;
const int CANT_WALK     = 0x0003; // return value for walk and move methods

// Map flags
const ULONG ERROR_FLAG = 0x1000;  // An error occurred
const ULONG  FAIL_FLAG = 0x0100;  // Last operation failed

/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/


/***************************************************************
 * Class: Map
 *                                                             *
 * Description: This is a 2 dimentional map of tiles. It has 3 *
 *    layers, the ground (which is drawn 1st), the object or   *
 *    thing layer and the being layer.                         *
 *                                                             *
 * Member data:                                                *
 *    -> w,h                                                   *
 *    -> flags                                                 *
 *    -> tilemap                                               *
 *    -> objgrid  -- Grid of objects, its the same size as the *
 *                   tilemap.                                  *
 *                                                             *
 * Member Functions:                                           *
 *   getThing(x,y)  -- Returns a pointer to thing in tile (x,y)*
 *   getBeing(x,y)  -- Returns a pointer to being in tile (x,y)*
 *   getGround(x,y) -- Returns ground image index              *
 *   outofmapQ(x,y) -- Checks if (x,y) is an out of map tile,  *
 *                     i.e. does range cheking.                *
 *   occupiedQ(x,y) -- Checks if tile (x,y) is occupied        *
 *   walkQ          -- Checks if is possible to walk in speci- *
 *                     fied direction from tile's coords intXY.*
 *   movething  --  Moves a thing in the thingrid (layer) in   *
 *                  the direction specified.                   *
 *   movebeing  --  Same as movebeing, but it acts on the      *
 *                  being grid instead.                        *
 *                                                             *
 ***************************************************************/ 
class Map {
public:
   Map();                                   // default constructor
   Map( int width, int height );            // by size constructor, leaves the Tile array uninitialized
   Map( int width, int height, Tile t );    // Same as the above but but initializes the map with t for all tiles.
   virtual ~Map();                          // destructor
   
   // METHODS
   
   // getz
   int getWidth() { return w; }
   int getHeight() { return h; }
   UBYTE getGround( const int &x, const int &y );
   Thing* getThing( const int &x, const int &y );
   // Questions
   bool outOfMapQ( const int &x, const int &y ) const;
   bool occupiedQ( const int &x, const int &y ) const;
   bool walkableQ( intXY, Direction::Direction );

   // Actions
   Thing* removeThing( int x, int y );
   int insertThing( Thing*, int x, int y );

   int moveThing( Thing*, intXY vector );
   int moveThing( Thing*, Direction::Direction );

   // OPERATORS

private:
   Map( const Map &rvalue );              // copy constructor
   Map& operator= ( const Map &rvalue );  // assignment operator
//   Map operator= ( const int &rvalue );
   int create();
   int generate();
   
   // manipulating cell flags
   void setOccupied( const int &x, const int &y ) { tilemap[y*w+x].pad |= 0x01; }
   void clearOccupied( const int &x, const int &y ) { tilemap[y*w+x].pad &= ~(0x01); }

protected:
   int   ID;
   ULONG sflag;
   int   w,h;       // width and height
   Tile  *tilemap;  // map array
   Thing **thingrid; // thing grid
}; // END OF CLASS Map DECLARATION

}// END OF MAP NAMESPACE -----------------------------------------------------/\
//----------------------------------------------------------------------------||


/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

// Usefull using declarations
// Turning this class visible for anyone that includes this file
using Map::Map;

#endif
