/*****************************************************************************
**************************** SPRITESET HEADER FILE ***************************
******************************************************************************
*                                                                            *
* Module full name: Graphics Module :: Sprite Set Sub-Module                 *
*                                                                            *
* Description: Implements a lineary indexed graphic set for things.          *
*                                                                            *
* Classes list:                                                              *
*    - class SpriteSet;
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be fine."      *
*                                                                            *
* Notes:                                                                     *
*   All indexs start at zero, just like in C arrays.                         *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, December 2004.                                   *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISE_SPRITESET_H      // prevent header from
#define DISE_SPRITESET_H 1    // being included twice

/* Includes */
#include "IGFXSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/


/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/


/***************************************************************
 * Class: SpriteSet                                            *
 *                                                             *
 * Description: Keeps a bitmap with indexed game graphic cells.*
 *                                                             *
 * Member data:                                                *
 *   -> cw,ch  -- Cell width and height in pixes;              *
 *   -> sw,sh  -- Set width and height in cells.               *
 *                                                             *
 * Member Functions:                                           *
 *   draw      -- Draws the indexed sprite cell on destbmp's   *
 *                (x,y) coordinates (lower left corner).       *
 *                                                             *
 ***************************************************************/ 
class SpriteSet : public IGFXSet {
public:
   SpriteSet( int cell_w = CELL_WIDTH, int cell_h = CELL_HEIGHT);
   SpriteSet( const char * filename, int cell_w = CELL_WIDTH, int cell_h = CELL_HEIGHT ); // By file constructor
   SpriteSet( BITMAP *bitmap, int cell_w = CELL_WIDTH, int cell_h = CELL_HEIGHT );       // By BITMAP construtor
   virtual ~SpriteSet(); // Destructor
   // Methods
   // Getz
   // Questions
   // Graphics
//   virtual int draw( BITMAP *destbmp, int sx, int sy, int x, int y, int w, int h ) const ;
   virtual int draw( BITMAP *destbmp, int indexX, int indexY, int x, int y ) const ;
   virtual int draw( BITMAP *destbmp, int index, int x, int y ) const ;
   virtual int drawSprite( BITMAP *destbmp, int indexX, int indexY, int x, int y ) const ;
private:
   SpriteSet( const SpriteSet &rvalue );              // copy constructor
   SpriteSet& operator= ( const SpriteSet &rvalue );  // assignment operator
}; // END OF CLASS SpriteSet DECLARATION



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif
