/*****************************************************************************
**************************** MAPENT HEADER FILE ******************************
******************************************************************************
*                                                                            *
* Module full name: Map Ent
*                                                                            *
* Purpose: Template for header files.
*                                                                            *
* Description:                                                               *
*                                                                            *
* Classes list:                                                              *
*    - class MapEnt
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos, December 2004.                                   *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef MAPENT_H      // prevent header from
#define MAPENT_H 1    // being included twice

/* Includes */
#include "typedefs.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
******************************************************************************
***                              Classes                                   ***
******************************************************************************
*****************************************************************************/


/***************************************************************
 * Class: MapEnt                                               *
 *                                                             *
 * Description: Represents the most simple map entity.         *
 *                                                             *
 * Member data:                                                *
 *    -> pos     -- Position in the map.                       *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class MapEnt {
public:
   MapEnt() { pos.x = -1; pos.y = -1; }        // default constructor
   virtual ~MapEnt() {}                        // destructor
   // Getz
   intXY getPosition() const { return pos; }
   // Setz
   virtual void setPosition( intXY coord ) { pos = coord; }
   virtual void setPosition( int x, int y ) { pos.x = x; pos.y = y; }
private:
//   MapEnt( const MapEnt &rvalue );              // copy constructor
//   MapEnt& operator= ( const MapEnt &rvalue );  // assignment operator
//   MapEnt operator= ( const int &rvalue );
protected:
   intXY pos;
}; // END OF CLASS MapEnt DECLARATION


/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/


#endif
