/*****************************************************************************
**************************** IGFXSET HEADER FILE *****************************
******************************************************************************
*                                                                            *
* Module full name: Graphics Module :: Linear Indexed Graphic Set Sub-Module *
*                                                                            *
* Description: Implements a lineary indexed graphic set.                     *
*                                                                            *
* Classes list:                                                              *
*    - class IGFXSet;                                                        *
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.000                                     *
*                                                                            *
* Revision history:                                                          *
*   Revised Thursday, 24th February 2005.                                    *
*                                                                            *
* Notes:                                                                     *
*   All indexs start at zero, just like C arrays.                            *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos 2004.                                             *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISE_LIGFXSET_H      // prevent header from
#define DISE_LIGFXSET_H 1    // being included twice

/* Includes */
#include "GFXSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern int I_am_an_external_variable;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

#define IGFXSET_ID 0x00100000

const int CELL_WIDTH  = 16;
const int CELL_HEIGHT = 16;


/*****************************************************************************
*                                Classes                                     *
*****************************************************************************/


/***************************************************************
 * Class: IGFXSet (Indexed Graphics Set)                       *
 *                                                             *
 * Description: Keeps a bitmap with indexed game graphic cells.*
 *              Every cell is considered to have the same width*
 *              and height dimentions.                         *
 *                                                             *
 * Member data:                                                *
 *   -> cw,ch  -- Cell width and height in pixes;              *
 *   -> sw,sh  -- Set width and height in cells.               *
 *                                                             *
 * Member Functions:                                           *
 *   draw      -- Draws the indexed graphic cell on destbmp    *
 *                (x,y) coordinates.                           *
 *                                                             *
 ***************************************************************/ 
class IGFXSet : public GFXSet {
public:
   IGFXSet( int cell_w = CELL_WIDTH, int cell_h = CELL_HEIGHT);
   IGFXSet( const char * filename, int cell_w = CELL_WIDTH, int cell_h = CELL_HEIGHT ); // By file constructor
   IGFXSet( BITMAP *bitmap, int cell_w = CELL_WIDTH, int cell_h = CELL_HEIGHT );       // By BITMAP construtor
   virtual ~IGFXSet(); // Destructor
   // Methods
   virtual int loadfile( const char * filename );
   virtual int loadBITMAP( BITMAP *bitmap );
   // Getz
//   int getNrOfCells() const ;
   // Questions
   inline bool indexOutOfRangeQ( const int &indexX, const int &indexY ) const;
   inline bool indexOutOfRangeQ( const int &index ) const;
   // Graphics
//   virtual int draw( BITMAP *destbmp, int sx, int sy, int x, int y, int w, int h ) const ;
   virtual int draw( BITMAP *destbmp, int indexX, int indexY, int x, int y ) const ;
   virtual int draw( BITMAP *destbmp, int index, int x, int y ) const ;
private:
//   IGFXSet( const IGFXSet &rvalue );              // copy constructor
//   IGFXSet& operator= ( const IGFXSet &rvalue );  // assignment operator
//   IGFXSet operator= ( const int &rvalue );
protected:
   int cw, ch;
   int sw, sh;
}; // END OF CLASS IGFXSet DECLARATION



/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/


#endif
