/*****************************************************************************
*************************** GAME ENGINE HEADER FILE **************************
******************************************************************************
*                                                                            *
* Module full name:  Game Engine Module                                      *
*                                                                            *
* Description:                                                               *
*    This is Game it self. It contains a message handling system and all the *
*    important game data.                                                    *
*                                                                            *
* Classes list:                                                              *
*    - class GameEngine                                                      *
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Version: Developement version 0.00.001                                     *
*                                                                            *
* Revision history:                                                          *
*   Revised Thursday, 24th February 2005.                                    *
*                                                                            *
* Notes:                                                                     *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright by Miguel Jos 2005.                                             *
*                                                                            *
*****************************************************************************/
/* From here on starts the code of your header file */
#ifndef DISE_GAME_ENGINE_H      // prevent header from
#define DISE_GAME_ENGINE_H 1    // being included twice

/* Includes */
#include "message.h"
#include "MSGQ.h"
#include "Map.h"
#include "Player.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
//extern fstream logfile;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;



/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
******************************************************************************
***                              Classes                                   ***
******************************************************************************
*****************************************************************************/


/***************************************************************
 * Class: GameEngine                                           *
 *                                                             *
 * Description: This class encapsulates the game data and game *
 *    functions.
 *              For design reasons "there can be only one"     *
 *    instance of this class.                                  *
 *                                                             *
 * Member data:                                                *
 *    -> data.                                                 *
 *                                                             *
 * Member Functions:                                           *
 *                                                             *
 ***************************************************************/ 
class GameEngine {
   friend int IssueMessage( Message );
public:
   GameEngine();                                   // default constructor
   virtual ~GameEngine();                          // destructor
   // METHODS
   int LoadGame();
   int GameLoop();
   int GameLoopOld();

   int issueMessage( const Message &msg );

private:
   GameEngine( const GameEngine &rvalue );              // copy constructor
   GameEngine& operator= ( const GameEngine &rvalue );  // assignment operator
   // METHODS
   int retrieveInput();
   int processMessage();
   int execute();
   int renderFrame();

   int PseudoLoadGame();
   int FLoadGame();
   int DestroyArrays();

//==== DATA ====//
   struct {
      bool loop;
   } flag;
   
   MessageQueue messagequeue;
   Message message;
   
   int mapcount, playercount, gfxsetcount, gfxengcount;
   Map           **maparray;
   GFXSet        **gfxsetarray;
   GraphicEngine **gfxengarray;
   Player        **playerarray;
   
   static int GameEngineInstanceCount;
}; // END OF CLASS GameEngine DECLARATION


/*****************************************************************************
******************************************************************************
***                  Module Public Functions Prototypes                    ***
******************************************************************************
*****************************************************************************/

// Issues a message to the GameEngine to process
// Returns 0 on success
// Returns -1 if GameEngine doesn't exist
// Returns -2 if Q is full
int IssueMessage( Message );


#endif
