/*****************************************************************************
**************************** SPRITESET SUB-MODULE ****************************
* version 0.00.000 ***********************************************************
*********************************************************** December 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class SpriteSet
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be fine."      *
*                                                                            *
* Notes: NO ERROR HANDLING!                                                  *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include "SpritSet.h"

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/




/* External variables */
extern PALETTE GraphicsColorPalette; // GFXSet color palette, mostly used as a dummy.
extern int DEBUG_TEXT_LINE;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;


/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

// C++ const

// C #define

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class SpriteSet                                *
*****************************************************************************/

// Standard Constructor
SpriteSet::SpriteSet( int cell_w, int cell_h )
: IGFXSet(cell_w,cell_h)
{}

// By file constructor
SpriteSet::SpriteSet( const char * filename, int cell_w, int cell_h )
: IGFXSet(filename,cell_w,cell_h)
{}

// By BITMAP constructor
SpriteSet::SpriteSet( BITMAP *bitmap, int cell_w, int cell_h )
: IGFXSet(bitmap,cell_w,cell_h)
{}

// Destructor
SpriteSet::~SpriteSet()
{}

// Copy constructor

SpriteSet::SpriteSet( const SpriteSet &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
SpriteSet& SpriteSet::operator= ( const SpriteSet &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//----------------|
// PUBLIC METHODS |
//----------------|

//--- Loading routines --->


//--- Questions --->

//--- Drawing routines --->

// Draws indexed cell in destbmp position (x,y)
// Returns -2 if coordinates are invalid
int SpriteSet::draw( BITMAP *destbmp, int indexX, int indexY, int x, int y ) const
{
   return IGFXSet::draw( destbmp, indexX, indexY, x,y-8 );
}

// Draws indexed cell in destbmp position (x,y)
// Returns -2 if coordinates are invalid
int SpriteSet::draw( BITMAP *destbmp, int index, int x, int y ) const
{
   return IGFXSet::draw( destbmp, index, x,y );
}


int SpriteSet::drawSprite( BITMAP *destbmp, int indexX, int indexY, int x, int y ) const
{
   return IGFXSet::draw( destbmp, indexX, indexY, x,y-ch );
}


/*****************************************************************************
*                    Module Public Functions Prototypes                      *
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
