/*****************************************************************************
****************************** BEING MODULE **********************************
* version 0.00.000 ***********************************************************
*********************************************************** December 2004 ****
******************************************************************************
******************************************************************************
* Classes list:                                                              *
*    - class Being
*                                                                            *
* Functions list:                                                            *
*                                                                            *
* Revision history: "Mike revised the code in 1499 BC, should be OK."        *
*                                                                            *
* Notes: Three space identation.                                             *
*        Every class has four automaticly generated functions, but because   *
*        you never know exactly how the compiler generates them I always do  *
*        the copy constructor and assignment operator private to prevent     *
*        them from being called without my consent ( this may happens by pas-*
*        sing parameters to functions ). I also always declare the default   *
*        construtor and destructor so that i know exactly what they are      *
*        doing and how the class is initialized and destroyed.               *
*                                                                            *
* Author: Miguel Jos                                                        *
*                                                                            *
* Copyright Miguel Jos, December 2004.                                      *
*                                                                            *
*****************************************************************************/

#include "being.h"
#include <fstream>
#include "SpritSet.h"
#include "anim.h"

using std::endl;
using namespace BEING;

/*****************************************************************************
*                             GLOBAL STUFF !                                 *
*****************************************************************************/

/* External variables */
extern int debug_var;
extern bool debug_bool;
extern std::fstream logfile;

/* Local variables */
//static int I_am_a_local_variable;

/* Typedefs */
//typedef definition identifier;


/*****************************************************************************
*                                Constants                                   *
*****************************************************************************/

const ULONG WALKING_STATE = 0x0100;

static const int WALKFRAMES = 8;

/*****************************************************************************
*                   Private Module Functions Prototypes                      *
*****************************************************************************/
// helper functions
static int santas_little_helper( void );

/*****************************************************************************
*                               Class Being                                  *
*****************************************************************************/

// Default constructor
Being::Being() : Thing( ThingType::BEING, ThingType::BEING )
{
   name[0] = '\0';

   facing = 0;
   movedir.x = movedir.y = 0;
   offset = movedir;
   gfx.y = 0;       // avatar  (set line)
   gfx.x = 2*3 + 1; // picture (set column)
   animstep = 0;
   tempo = 0;
}

// Destructor
Being::~Being()
{
   // Clean up after himself. Prevent memory leaks.
}

// Copy constructor
Being::Being( const Being &rvalue )
{
   // data = rvalue.data;
}

// Assignment operator
Being& Being::operator= ( const Being &rvalue )
{
   // data = rvalue.data;
   // return (*this);
}

//-- FLAGS -->

// Sets the walking state
void Being::setWalkFlag()
{
   setFlag(WALKING);
}

// Clears the walking state
void Being::clearWalkFlag()
{
   clearFlag(WALKING);
}


//----------------|
// PUBLIC METHODS |
//----------------|

//-- Questions -->
bool Being::walkingQ()
{
   return ( (fStatus&WALKING) == WALKING );
}

bool Being::animatingQ()
{
   return ( (fStatus & ANIMATING) == ANIMATING );
}

//-- Actions -->

// WALK
int Being::walk( Map *map, Direction::Direction dir )
{
   if( walkingQ()&&animatingQ() ) return 1;
   intXY destpos = pos + dir2vec( dir );
   
   face(dir); // face direction

   if( !map->walkableQ(pos,dir) ) return -2;
   if( map->occupiedQ(destpos.x,destpos.y) ) return -2;

   {
      if( map->moveThing( this, dir ) != 0 ) return -1; // Couldn't walk in the specified direction!
      setWalkFlag();
      movedir = dir2vec( dir );
   }
   return 0;
}

// Makes the being face the direction, dir.
int Being::face( Direction::Direction dir )
{
   facing = dir;
   switch (dir)
   {
      case Direction::NORTH :
         gfx.x = 0*3 + 1; // character facing up
         break;
      case Direction::EAST :
         gfx.x = 1*3 + 1; // character facing right
         break;
      case Direction::SOUTH :
         gfx.x = 2*3 + 1; // character facing down
         break;
      case Direction::WEST :
         gfx.x = 3*3 + 1; // character facing left
         break;
      default:
         break;
   }
}

//-- Drawing routine -->
int Being::draw( BITMAP *dest, GFXSet *set, int x, int y )
{
   if( walkingQ() )
   {
      if( animatingQ() )
      {
         if( (getAnimTime()-tempo) > 125 )
         {
            tempo = getAnimTime();
            animstep++;
            switch (animstep)
            {
               case 1:
                  offset = -12 * movedir;
                  --gfx.x;
                  break;
               case 2:
                  offset = -8 * movedir;
                  ++gfx.x;
                  break;
               case 3:
                  offset = -4 * movedir;
                  ++gfx.x;
                  break;
               case 4:
               default:
                  offset = movedir = Direction::NULL_VEC;
                  --gfx.x;
                  clearWalkFlag();
                  clearFlag(ANIMATING);
                  animstep = 0;
                  break;
            }
         }
      }
      else {
         setFlag(ANIMATING);
         tempo = getAnimTime();
         offset = -16 * movedir;
         animstep = 0;
      }
      /*
      logfile << "AnimTime = " << getAnimTime()
              << "; animstep = " << animstep
              << "; gfx.x = " << gfx.x << endl;
      logfile << "tempo    = " << tempo << endl;
      */
   }
   return reinterpret_cast<SpriteSet*>(set)->drawSprite( dest, gfx.x, gfx.y, x+offset.x,y+16+offset.y );
}

/*****************************************************************************
******************************************************************************
****                 Module Public Functions Prototypes                   ****
******************************************************************************
*****************************************************************************/

int santas_little_helper( void ) {
   return 0x0;
}

// Final Remarks
// It is thought to write good code, so i try to use every good trick i know!
// Miguel Jos 2nd August 2004.
