/*********************************************************************
*                  Devas Image Sound Engine Project                  *
* Devas                                                              *
*                                                                    *
* Author: Miguel Jose ( DarkAvenger )                                *
*                                                                    *
* Description: Main project file.                                    *
*        Devas is a role playing computer game.                      *
*        It uses a 2D top-down view, where the graphics are tile in  *
*        four layers.                                                *
*                                                                    *
* Usage: Run the executable file.                                    *
*                                                                    *
* References: Creative copying is a legitimate form of programing.   *
*             Allegro documentation, Greg Taylor 1.2 Tile game FAQ,  *
*             C++ How To Program (from D&D), numerous Game-Dev       *
*             documents and the Final Fantasy game series.           *
*                                                                    *
* File formats: None                                                 *
*                                                                    *
* Restrictions: The program does not check for input errors.         *
*                                                                    *
* Version: 0.00.000                                                  *
*                                                                    *
* Revision history:                                                  *
*   The game is currently under a revision process. Up until now the *
*   name has been revised from LAMP to Devas. 20050222               *
*                                                                    *
* Error handling: None.                                              *
*                                                                    *
* Notes: Identation size 3 spaces.                                   *
*                                                                    *
* Copyright by Miguel Jose, February 2005                            *
*********************************************************************/

/**** Includes ****/
#include <iostream>
#include <fstream>
#include <allegro.h>
#include "DISE.H"
#include "DISEerr.h"
#include "DISElog.h"
#include "GameEng.h"

/**** Uses ****/
using std::cout;
using std::cin;
using std::endl;
using std::fstream;
using std::ifstream;
using std::ofstream;
using std::ios;

/**** #defines / #undef ****/

/**** typedef's ****/

/**** struct's ****/

/*******************
* Global constants *
*******************/

/*******************
* Global Variables *
*******************/
int debug_var = 0;
bool debug_bool = false;
int DEBUG_TEXT_LINE = 0;


/****************************************************************************/
/**                                                                        **/
/**                                Classes                                 **/
/**                                                                        **/
/****************************************************************************/



/****************************************************************************/
/**                              Classes end                               **/
/****************************************************************************/


/****************************************************************************/
/**                                                                        **/
/**                               Functions                                **/
/**                                                                        **/
/****************************************************************************/

/***************************************************************
 * initialize
 *    Initializes stuff, and does some error checking.         *
 *     gfx_mode  : graphic mode                                *
 *     s_w & s_h : screen width and height                     *
 *     bpp       : bits per pixel (color depth)                *
 ***************************************************************/
int initialize( int gfx_mode, int s_w, int s_h )
{
   install_allegro( SYSTEM_AUTODETECT, &errno, NULL );

   install_keyboard();

   // set a graphics mode
   if (set_gfx_mode( gfx_mode, s_w, s_h, 0, 0) != 0) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
      allegro_exit();
      exit(1);
      return -1; // !?
   }

   return 0;
}

              /*example1*/
/***************************************************************
 * Function: SquareRoot                                        *
 *                                                             *
 * Description: Calculate the square root of a number.         *
 * Parameters:  Number                                         *
 * Return: The result of course.                               *
 ***************************************************************/
float squareroot( float number )
{
   static int i;
   float b, a = 1.0;
   do {
      b = a;
      a = ( number / a + a ) / 2;
   } while ( a != b );
   return a;
}

// DUMMY FUNCTIONS
void Initialization() {
}
void RetrievePlayerInput() {}
void PerformGameLogic() {}

void RenderNextFrame() {}


void SynchronizeDisplay() {}
void Shutdown() {
}
// END OF DUMMY FUNCTIONS

/****************************************************************************/
/**                    End of functions declarations                       **/
/****************************************************************************/


/*********************************************
*                                            *
*      MM     MM    AA    III  NN     N      *
*      M M   M M   A  A    I   N N    N      *
*      M  M M  M  A    A   I   N  N   N      *
*      M   M   M  AAAAAA   I   N   N  N      *
*      M       M  A    A   I   N    N N      *
*      M       M  A    A  III  N     NN      *
*                                            *
*********************************************/

int main(int argc, char *argv[])               // You just have to have a main!!
{
   // Open logs
   opendiselog();
   opendiserrorlog();
   

   {
      // Initialize system
      Diesel ALLEGRO_SYSTEM(GFX_AUTODETECT_WINDOWED,640,480,8);
      textout(screen, font, "Allegro Initialized",0, DEBUG_TEXT_LINE*10, makecol(255,255,0));
      ++DEBUG_TEXT_LINE;
   
      // Initialize game
      GameEngine Rupert;
      DEBUG_TEXT_LINE = 0;
      textout(screen, font, "GameEngine Initialized",0, DEBUG_TEXT_LINE*10, makecol(255,255,0));
      ++DEBUG_TEXT_LINE;


      Rupert.GameLoop();


      textout(screen, font, "GameEngine Loop Ended",10, DEBUG_TEXT_LINE*10, makecol(255,255,0));
   }

   closediselog();
   closediserrorlog();
   
   return 0;
}
END_OF_MAIN()


/*****************************************************************************
ToDo list:

*****************************************************************************/
