// Screen (.c)

#include <allegro.h>
#include "darklight.h"
#include "screen.h"
#include "unit.h"

void draw_screen(void)
{
 // Stretch from small to large buffer.
 stretch_blit(small_buffer, large_buffer, 0, 0, small_buffer->w, small_buffer->h,
 0, 0, large_buffer->w, large_buffer->h);
 
 // Then blit large buffer to screen.
 blit(large_buffer, screen, 0, 0, 0, 0, large_buffer->w, large_buffer->h);    
}

void draw_tile(int x, int y, int tile)
{
 int tx, ty, tile_x, tile_y, c;
 
 tile_x = (tile / 4) * 16;
 tile_y = (tile % 4) * 16;
 
 for (ty = 0 ; ty < 16 ; ty++)
 {
  for (tx = 0 ; tx < 16 ; tx++)
  {
   c = getpixel(tiles, tx + tile_x, ty + tile_y);
  
   if (c == 4) continue; // Skip masked pixel colour.
   putpixel(small_buffer, x + tx, y + ty, c);
  }
 }    
}

void draw_map(void)
{
 int x, y, tile;
 
 for (y = 0 ; y < TILES_Y ; y++)
 {
  for (x = 0 ; x < TILES_X ; x++)
  {
   tile = getpixel(map, x, y);
   draw_tile(x * 16, y * 16, tile);

   if (unit_map[x][y].attack != 0) draw_tile(x * 16, y * 16, unit_map[x][y].gfx);   
  }
 }    
}

void create_map(void)
{
 int x, y, r, c;
 BITMAP *temp;
 
 clear_to_color(map, 8);    
 temp = create_bitmap(map->w, map->h);
 
 for (r = 0 ; r < 50 ; r++)
 {
  putpixel(map, rand() % TILES_X, rand() % TILES_Y, (rand() % 3) + 8);     
 }
 
 // Grow terrain..
 for (r = 0 ; r < 15 ; r++)
 {
  blit(map, temp, 0, 0, 0, 0, map->w, map->h);
  
  for (y = 0 ; y < TILES_Y ; y++)
  {
   for (x = 0 ; x < TILES_X ; x++)
   {
    c = getpixel(temp, x, y);    
    
    if (c == 8) continue;
    
    if (c == 9 || (c == 10 && rand() % 2 == 0))
    {
     if (rand() % 2 == 0)
     {
      putpixel(map, x + (rand() % 2) - 1, y, c);   
     }
     else
     {
      putpixel(map, x, y + (rand() % 2) - 1, c);          
     }
    }
   }    
  }
 }
 
 // Add rocks.
 for (r = 0 ; r < 8 ; r++)
 {
  putpixel(map, rand() % TILES_X, rand() % TILES_Y, 12);     
 }
 
 // Add free castles.
 for (r = 0 ; r < 8 ; r++)
 {
  x = rand() % (TILES_X - 9) + 4;
  y = rand() % TILES_Y;
  
  //rectfill(map, x - 1, y - 1, x + 1, y + 1, 8);
  putpixel(map, x, y, 13);     
 }
  
 destroy_bitmap(temp);

 // Add armies.
 add_armies();
}

void add_armies(void)
{
 int dy, ly, w;
 
 dy = rand() % (TILES_Y - 2) + 1;
 ly = rand() % (TILES_Y - 2) + 1;
 
 w = TILES_X - 2;
 
 // Dark Castle
 rectfill(map, 0, dy - 1, 2, dy + 1, 8);
 putpixel(map, 1, dy, 14);
 
 // Soldiers
 unit_map[2][dy - 1] = unit[SOLDIER];
 unit_map[2][dy] = unit[SOLDIER];
 unit_map[2][dy + 1] = unit[SOLDIER];
   
 // Knights
 unit_map[1][dy - 1] = unit[KNIGHT];    
 unit_map[1][dy + 1] = unit[KNIGHT];  

 // Archers
 unit_map[0][dy - 1] = unit[ARCHER];    
 unit_map[0][dy + 1] = unit[ARCHER]; 
 
 // Mage   
 unit_map[0][dy] = unit[MAGE];    


 // Light Castle
 rectfill(map, w - 1, ly - 1, w + 1, ly + 1, 8);
 putpixel(map, w, ly, 15);
 
  // Soldiers
 unit_map[w - 1][ly - 1] = unit[SOLDIER + 4];    
 unit_map[w - 1][ly] = unit[SOLDIER + 4];
 unit_map[w - 1][ly + 1] = unit[SOLDIER + 4];    

 
 // Knights
 unit_map[w][ly - 1] = unit[KNIGHT + 4];    
 unit_map[w][ly + 1] = unit[KNIGHT + 4]; 
 
 // Archers
 unit_map[w + 1][ly - 1] = unit[ARCHER + 4];    
 unit_map[w + 1][ly + 1] = unit[ARCHER + 4]; 
 
 // Mage
 unit_map[w + 1][ly] = unit[MAGE + 4];    
}

void draw_status_text(int x, int y)
{
 char txt[40];
 int t, u;
 
 if (y > 11)
 {
  sprintf(txt, "%d units left to move. Click to End Turn.", game.units_who_can_move);
  
  rectfill(small_buffer, 0, small_buffer->h - 8, small_buffer->w, small_buffer->h, 1);
  textout_ex(small_buffer, font, txt, 0, small_buffer->h - 8, 0, 1);
  return;   
 }
 
 if (selected.x != -1)
 {
  x = selected.x;
  y = selected.y;   
 }
 
 t = getpixel(map, x, y);
 
 if (t == 8) sprintf(txt, "Terrain: Plain");
 if (t == 9) sprintf(txt, "Terrain: Grasslands");
 if (t == 10) sprintf(txt, "Terrain: Forest");
 if (t == 11) sprintf(txt, "Terrain: Water");
 if (t == 12) sprintf(txt, "Terrain: Rock");
 if (t == 13) sprintf(txt, "Terrain: Neutral Castle");
 if (t == 14) sprintf(txt, "Terrain: Dark Castle");
 if (t == 15) sprintf(txt, "Terrain: Light Castle");

 u = unit_map[x][y].movement;
 if (u == -1) u = 0;
 
 if (unit_map[x][y].gfx == 0) sprintf(txt, "Dark Soldier.  Moves Left: %d  RMB: Stats",
 u);
 if (unit_map[x][y].gfx == 1) sprintf(txt, "Dark Knight.   Moves Left: %d  RMB: Stats",
 u);
 if (unit_map[x][y].gfx == 2) sprintf(txt, "Dark Archer.   Moves Left: %d  RMB: Stats",
 u);
 if (unit_map[x][y].gfx == 3) sprintf(txt, "Dark Mage.     Moves Left: %d  RMB: Stats",
 u);
 
 if (unit_map[x][y].gfx == 4) sprintf(txt, "Light Soldier. Moves Left: %d  RMB: Stats",
 u);
 if (unit_map[x][y].gfx == 5) sprintf(txt, "Light Knight.  Moves Left: %d  RMB: Stats",
 u);
 if (unit_map[x][y].gfx == 6) sprintf(txt, "Light Archer.  Moves Left: %d  RMB: Stats",
 u);
 if (unit_map[x][y].gfx == 7) sprintf(txt, "Light Mage.    Moves Left: %d  RMB: Stats",
 u); 
 
 if (selected.x == -1)
 {
  rectfill(small_buffer, 0, small_buffer->h - 8, small_buffer->w, small_buffer->h, 3);
  textout_ex(small_buffer, font, txt, 0, small_buffer->h - 8, 0, 3);
 }
 else
 {
  rectfill(small_buffer, 0, small_buffer->h - 8, small_buffer->w, small_buffer->h, 2);
  textout_ex(small_buffer, font, txt, 0, small_buffer->h - 8, 0, 2);     
 }
}

void draw_turn_text(void)
{
 int w, h;
 
 w = 80;
 h = 40;
 
 draw_screen();
 rest(150);
 
 rectfill(small_buffer, (small_buffer->w / 2) - w, (small_buffer->h / 2) - h,
 (small_buffer->w / 2) + w, (small_buffer->h / 2) + h, 3);
 
 rect(small_buffer, (small_buffer->w / 2) - w, (small_buffer->h / 2) - h,
 (small_buffer->w / 2) + w, (small_buffer->h / 2) + h, 0);

 if (game.side == 0)
 {
  textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.4, 0, 3,
  "** The Dark **");    
 }
 else
 { 
  textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.4, 0, 3,
  "-- The Light --");
 }
 
 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.5, 0, 3,
 "Turn: %d", game.turn);
 
 if (player[game.side].cpu == NO) textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.6, 0, 3,
 "Click Mouse Button");
  
 draw_screen();
 
 if (player[game.side].cpu == NO)
 {
  do
  { 
  } while (mouse_b != 0);
 
  do
  {  
  } while (mouse_b == 0);
 
  do
  {  
  } while (mouse_b != 0);
 }
 else
 {
  rest(750);    
 }
 
 draw_map();
 draw_screen();
}

void draw_winner_text(void)
{
 int w, h;
 
 w = 80;
 h = 40;
 
 draw_screen();
 rest(350);
 
 rectfill(small_buffer, (small_buffer->w / 2) - w, (small_buffer->h / 2) - h,
 (small_buffer->w / 2) + w, (small_buffer->h / 2) + h, 3);
 
 rect(small_buffer, (small_buffer->w / 2) - w, (small_buffer->h / 2) - h,
 (small_buffer->w / 2) + w, (small_buffer->h / 2) + h, 0);

 if (game.winning_side == 0)
 {
  textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.4, 0, 3,
  "** The Dark **");    
 }
 else
 { 
  textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.4, 0, 3,
  "-- The Light --");
 }
 
 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.5, 0, 3,
 "Are Victorious!");
  
 draw_screen();
 
 do
 { 
 } while (mouse_b != 0);
 
 do
 {  
 } while (mouse_b == 0);
 
 do
 {  
 } while (mouse_b != 0);  
}

void draw_title_text(void)
{
 int w, h, done;
 
 w = 80;
 h = 40;
 
 blit(tiles, small_buffer, 81, 0, 60, 20, 205, 64);
 
 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.5, 0, 3,
 "By Richard Phipps");

 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.65, 0, 3,
 "1. Player vs Player");
  textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.7, 0, 3,
 "2. Player vs Computer"); 
  textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.75, 0, 3,
 "3. Computer vs Player"); 
  textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.8, 0, 3,
 "4. Computer vs Computer"); 

 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.9, 0, 3,
 "Press 1-4 to Start or Escape to Exit."); 
 draw_screen();
 
 done = NO;
 
 do
 {
  if (key[KEY_ESC])
  {
   player[0].cpu = -1;  
   done = YES;
  }
  if (key[KEY_1])
  {
   player[0].cpu = NO;
   player[1].cpu = NO;
   done = YES;   
  }
  if (key[KEY_2])
  {
   player[0].cpu = NO;
   player[1].cpu = YES;
   done = YES;   
  }
  if (key[KEY_3])
  {
   player[0].cpu = YES;
   player[1].cpu = NO;
   done = YES;   
  }
  if (key[KEY_4])
  {
   player[0].cpu = YES;
   player[1].cpu = YES;
   done = YES;   
  }  
 } while (done == NO);  
}

void draw_unit_info(int x, int y)
{
 int w, h;
 char txt[40];
 
 w = 80;
 h = 40;
 
 draw_screen();
 rest(150);
 
 rectfill(small_buffer, (small_buffer->w / 2) - w, (small_buffer->h / 2) - h,
 (small_buffer->w / 2) + w, (small_buffer->h / 2) + h, 3);
 
 rect(small_buffer, (small_buffer->w / 2) - w, (small_buffer->h / 2) - h,
 (small_buffer->w / 2) + w, (small_buffer->h / 2) + h, 0);

 if (unit_map[x][y].gfx == 0) sprintf(txt, "Dark Soldier");
 if (unit_map[x][y].gfx == 1) sprintf(txt, "Dark Knight");
 if (unit_map[x][y].gfx == 2) sprintf(txt, "Dark Archer");
 if (unit_map[x][y].gfx == 3) sprintf(txt, "Dark Mage");
 
 if (unit_map[x][y].gfx == 4) sprintf(txt, "Light Soldier");
 if (unit_map[x][y].gfx == 5) sprintf(txt, "Light Knight");
 if (unit_map[x][y].gfx == 6) sprintf(txt, "Light Archer");
 if (unit_map[x][y].gfx == 7) sprintf(txt, "Light Mage");   
 
 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.35, 0, 3,
 txt);    

 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.45, 0, 3,
 "Attack: %d", unit_map[x][y].attack);
 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.5, 0, 3,
 "Defence: %d", unit_map[x][y].defence);
 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.55, 0, 3,
 "Movement: %d", unit_map[x][y].movement);
 textprintf_centre_ex(small_buffer, font, small_buffer->w / 2, small_buffer->h * 0.6, 0, 3,
 "Attack Range: %d", unit_map[x][y].attack_range);
  
 draw_screen();
 
 if (player[game.side].cpu == NO)
 {
  do
  { 
  } while (mouse_b != 0);
 
  do
  {  
  } while (mouse_b == 0);
 
  do
  {  
  } while (mouse_b != 0);
 }
 else
 {
  rest(750);    
 }
 
 draw_map();
 draw_screen();
}
