#include <allegro.h>
#include "DarkLight.h"
#include "rm.h"
#include "log.h"
#include "screen.h"
#include "unit.h"

int main(void)
{
 // Split into the three phases that every game uses:
 // -------------------------------------------------
 
 // Startup phase
 startup_game();
 
 // Main loop
 main_loop();
 
 // Shutdown phase
 shutdown_game();
}
END_OF_MAIN()

void startup_game(void)
{
 // First the default setup stuff common to all Allegro games:
 // ----------------------------------------------------------
 
 // Open a logfile first, so we can report any errors.
 open_log("logfile.txt");
 write_log_header();
 
 // Set up Allegro.
 allegro_init();
 write_to_log("Initializing the Allegro Library.");
 write_to_log("%s", allegro_id);

 // Setup Keyboard, Mouse and a high resolution timer.
 install_keyboard();
 install_mouse();
 
 srand(time(0));
 
 // Now we setup a screen mode.
 set_color_depth(8);
 write_to_log("Setting up a 640 x 400 x 8 bit graphics mode.");
 
 if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 400, 0, 0) != 0)
 {
  write_to_log("Unable to set a graphic mode\n%s\n", allegro_error);
  record_error("Can't open a screen!");
 }
 write_to_log("Graphics mode set..");
 
 small_buffer = create_bitmap(320, 200);
 large_buffer = create_bitmap(640, 400);
 clear_to_color(small_buffer, 3);
 
 map = create_bitmap(TILES_X, TILES_Y);
 army = create_bitmap(TILES_X, TILES_Y);
  
 // Now we have the Game Specific setup:
 // ------------------------------------
 
 // Load the gfx tiles to make up the levels, trapping any errors and exiting.
 tiles = load_bitmap("Gfx/Tiles.bmp", ingame_palette);
 
 if (!tiles)
 {
  record_error("Can't load Gfx Tiles!");   
 }
 
 // Also, use the ingame palette we loaded in with the tile gfx.
 set_palette(ingame_palette);
 
 setup_units();
 show_mouse(screen);
}

void main_loop(void)
{
 int done, x, y, turn_done;
 done = NO;
 selected.x = -1;
 game.turn = 1;
 game.winning_side = -1;
 
 setup_unit_map();
 create_map();
 
 draw_title_text();
 if (player[0].cpu == -1) return;
    
 draw_map();
 
 start:
 game.units_who_can_move = count_units_who_can_move();
 draw_turn_text();
 turn_done = NO;
 
 do
 {
  if (game.units_who_can_move < 1) turn_done = YES;
  if (game.winning_side != -1) done = YES;
  if (player[game.side].cpu == YES)
  {
   do_ai_unit_sweep();
   turn_done = YES;   
  }  
  
  x = mouse_x / 32;
  y = mouse_y / 32;
  draw_status_text(x, y);

  if (mouse_b == 1 && y < 12)
  {
   if (selected.x == -1)
   {
    select_unit(x, y);
   }
   else
   {
    try_to_move_unit(x, y);    
   }    
  }
  
  if (mouse_b == 2)
  {
   if (y < 12)
   {
    if (selected.x != -1)
    {
     unit_map[selected.x][selected.y].movement = -1;
     unselect_unit();
     game.units_who_can_move--;
    }
    else
    {
     if (unit_map[x][y].gfx != -1) draw_unit_info(x, y);    
    }
   }
  }
  
  if (y > 11 && mouse_b != 0)
  {
   if (selected.x == -1) turn_done = YES;    
  }

  draw_screen();
  if (key[KEY_ESC]) done = YES;
 }
 while (done == NO && turn_done == NO);
 
 if (done == NO)
 {
  // End of Turn..
  if (game.side == 0)
  {
   game.side = 1;
   goto start;   
  }
  else
  {
   game.side = 0;
   game.turn++;
   restore_all_units_movement();
   
   goto start;    
  }   
 }
 else
 {
  if (game.winning_side != -1) draw_winner_text();  
 }
}

void shutdown_game(void)
{
 // Shutdown code to exit the game cleanly:
 // ---------------------------------------
 
 write_to_log("");
 write_to_log("Starting Game Shutdown..");
 write_to_log("------------------------");
 
 rm_shutdown(); // Clear up all Bitmaps and Samples still in memory.
 
 write_to_log("Shutting down logfile and exiting game.");
 close_log();
}
