// Conway's game of life
// 
// Programmed by red_Marvin
//
// requires allegro to run
//
// see http://www.math.com/students/wonders/life/life.html for more
//
// info about Conway's game of life

#include "allegro.h"

void tick(void);           
void drawlifecolony(void); 
void usemypalette(void);
void drawgui(void);

BITMAP* dbuf;   //double buffer

class LIFE  //the population
    {
    public:
    int getpoint(int px, int py);                   
    void setpoint(int px, int py, int value);
    void settmppoint(int px, int py, int value);
    void updatelifematrix(void);
    void drawcolony(int sx, int sy);
    void clear(void);
    private:
    int lifematrix[50][50];         //the matrix holding the cell data 
    int tmplifematrix[50][50];      //matrix holding the new data during update
    };

int LIFE::getpoint(int px, int py)  //returns the state of a specific cell
    {                               //with boundary checking
    if(px<0)
        {px=49;}
    if(px>49)
        {px=0;}
    if(py<0)
        {py=49;}
    if(py>49)
        {py=0;}
    return lifematrix[px][py];
    }


void LIFE::setpoint(int px, int py, int value)  //sets a cell's state
    {                                           //with boundary checking
    if(px<0)
        {px=49;}
    if(px>49)
        {px=0;}
    if(py<0)
        {py=49;}
    if(py>49)
        {py=0;}
    lifematrix[px][py]=value;
    }

void LIFE::settmppoint(int px, int py, int value)   //sets a cell's state on the
    {                                               //update matrix
    if(px<0)                                        //with boundary checking
        {px=49;}
    if(px>49)
        {px=0;}
    if(py<0)
        {py=49;}
    if(py>49)
        {py=0;}
    tmplifematrix[px][py]=value;
    }

void LIFE::updatelifematrix(void)   //updates the cells' states
    {
    int sum;
    for (int y=0;y<50;y++)  //goes through every cell
        {
        for(int x=0;x<50;x++)
            {
            sum=0;  //calculates the sum of all cells' states around the cell
            sum=getpoint(x-1,y-1)+getpoint(x,y-1)+getpoint(x+1,y-1)+
                getpoint(x-1,y)  +                getpoint(x+1,y)  +
                getpoint(x-1,y+1)+getpoint(x,y+1)+getpoint(x+1,y+1);
            switch (sum)
                {
                case 3: //if sum==3 then the cell is alive
                    settmppoint(x,y,1);
                    break;                    
                case 2: //if sum==2 and the cell is alive, then it stays alive
                    if(getpoint(x,y)==1)    //else it dies
                        {settmppoint(x,y,1);}
                    else
                        {settmppoint(x,y,0);}
                    break;
                default:    //if the cell is lonely or the area is overpopulated
                    settmppoint(x,y,0); //it dies
                }
            }
        }
    for (int y=0;y<50;y++)      //copies the new data to the "real" matrix
        {
        for(int x=0;x<50;x++)
            {
            lifematrix[x][y]=tmplifematrix[x][y];
            }
        }
    }
                                              
void LIFE::drawcolony(int sx, int sy)   //not much to say, converts the cells'
    {                                   //states into nice small black and grey
    for (int y=0;y<50;y++)              //squares
        {
        for(int x=0;x<50;x++)
            {
            if(getpoint(x,y)==1)
                {
                rectfill(dbuf,x*8+sx,y*8+sy,x*8+6+sx,y*8+6+sy,3);
                }
            else
                {
                rectfill(dbuf,x*8+sx,y*8+sy,x*8+6+sx,y*8+6+sy,2);
                }
            }
        }
    }

void LIFE::clear(void)  //kills the whole colony
    {                                         
    for (int y=0;y<50;y++)
        {
        for(int x=0;x<50;x++)
            {
            setpoint(x,y,0);
            }
        }
    }
                                              
LIFE life;  //global declaration of the colony (I'm not really into pointers
            //and references yet...

void tick(void) //the function updating the matrix and drawing it evvery tick
    {
    life.updatelifematrix();
    drawlifecolony();
    }
END_OF_FUNCTION(tick);

void drawlifecolony(void)   //drawing the graphical stuff
    {
    life.drawcolony(220,40);
    scare_mouse();
    blit(dbuf,screen,220,40,220,40,400,400);
    unscare_mouse();
    }

void usemypalette(void) //sets the palette
    {
    PALETTE pal;
    pal[0].r=0;     //background
    pal[0].g=0;
    pal[0].b=0;

    pal[1].r=47;    //gui
    pal[1].g=47;
    pal[1].b=47;

    pal[2].r=15;    //dead cell color
    pal[2].g=15;
    pal[2].b=15;

    pal[3].r=63;    //alive cell color
    pal[3].g=63;
    pal[3].b=63;

    pal[15].r=63;   //mouse outline color
    pal[15].g=63;
    pal[15].b=63;

    pal[16].r=0;    //mouse fill color
    pal[16].g=0;
    pal[16].b=0;

    set_palette(pal);
    }

void drawgui(void)  //function that draws the gui
    {
    rect(dbuf,10,30,210,50,1);  //drawing the buttons' outlines
    rect(dbuf,10,50,210,70,1);
    rect(dbuf,10,70,210,90,1);
    rect(dbuf,10,90,210,110,1);
    rect(dbuf,10,110,210,130,1);
    textout(dbuf,font,"Start/Stop",20,36,1);    //printing the buttons' captions
    textout(dbuf,font,"Faster",20,56,1);
    textout(dbuf,font,"Slower",20,76,1);
    textout(dbuf,font,"Clear",20,96,1);
    textout(dbuf,font,"Exit",20,116,1);
    rect(dbuf,210,30,630,450,1);    //drawing the colony-space's outline
    }

int main()
    {
    allegro_init();     //startup allegro
    dbuf=create_bitmap(640,480);    //inits the double buffer
    set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);  //inits the graphical mode
    set_window_close_button(0); //disables the close button
    install_timer();    // | Installs and inits a lot of things
    install_keyboard(); // V 
    install_mouse();    
    usemypalette();     
    life.clear();       
    clear(dbuf);
    drawgui();
    vsync();
    blit(dbuf,screen,0,0,0,0,640,480);
    drawlifecolony();
    show_mouse(screen); //-----            
    bool running=false; //flag showing if the "animation" is on
    int speed=250;      //the speed variable
    LOCK_FUNCTION(tick); //allegro help told me to do this
    LOCK_VARIABLE(life);
    LOCK_VARIABLE(dbuf);
    while(true)     //endless loop
        {
        if(mouse_b!=0)  //ooh! I did hear a mouse click!
            {
            if(mouse_x>=10 && mouse_x<210)  //perhaps clicking on a button?
                {
                if(mouse_y>=30 && mouse_y<50) //toggles animation
                    {
                    if(running==false)
                        {
                        running=true;            //starts animation if stopped
                        install_int(tick,speed); //sets allegro to run the function
                        }                        //"tick" every speed milliseconds
                    else
                        {
                        running=false;          //stops animation if started
                        remove_int(tick);       //opposite of install_int(...)
                        }
                    while(mouse_b!=0)           //no press-and-hold mishappenings
                        {}
                    }
                if(mouse_y>=50 && mouse_y<70 && speed>50) //if speed is not fast enough
                    {                                     //put pedal to the metal
                    speed-=50;
                    if(running==true)              //changing the rate of update
                        {install_int(tick,speed);} //(if running)
                    while(mouse_b!=0)              //no press-and-hold mishappenings 
                        {}
                    }

                if(mouse_y>=70 && mouse_y<90 && speed<2000) //slowing down the
                    {                                       //update rate
                    speed+=50;
                    if(running==true)
                        {install_int(tick,speed);}
                    while(mouse_b!=0)
                        {}
                    }
                    
                if(mouse_y>=90 && mouse_y<110)      //clears the colony and stops
                    {                               //animation (if running)
                    if(running==true)
                        {
                        remove_int(tick);
                        running=false;
                        }
                    life.clear();
                    drawlifecolony();
                    while(mouse_b!=0)
                        {}
                    }
                if(mouse_y>=110 && mouse_y<130) //ends the program
                    {
                    destroy_bitmap(dbuf);
                    return 0;
                    }
                }
            else
                {   //perhaps clicking on the colony?
                if(mouse_x>=220 && mouse_x<620 && mouse_y>=40 && mouse_y<440)
                    {
                    int x=(int)((mouse_x-220)/8); //position of the clicked
                    int y=(int)((mouse_y-40)/8);  //cell
                    int b=mouse_b;
                    if(b&1) //if right buton is pressed it lives
                        {
                        life.setpoint(x,y,1);
                        }
                    else //elsewise it dies
                        {
                        life.setpoint(x,y,0);
                        }
                    drawlifecolony(); //redraws the colony
                    while((int)((mouse_x-220)/8)==x && (int)((mouse_y-40)/8)==y && mouse_b==b)
                        {} //no press-and-hold mishappenings, but you can drag
                           //the mouse to get a line
                    }      
                }
            }
        }
    }
END_OF_MAIN() //finito
