
#include <allegro.h>

#include "timer.h"

namespace timer
{

volatile int timecounter = 0;
volatile int profilecounter[32];
volatile int *currentprofilecounter;
bool timerenable = false;
bool profileenable = false;
number profile[32];
number profilesum[4];

void timer()
{
   ++timecounter;
   if( profileenable ) ++(*currentprofilecounter);
};
END_OF_FUNCTION( timer );

void init()
{
   install_timer();
   LOCK_VARIABLE( timecounter );
   LOCK_VARIABLE( profilecounter );
   LOCK_VARIABLE( currentprofilecounter );
   LOCK_FUNCTION( timer );
   for( int i = 0; i < 32; ++i )
   { profilecounter[i] = 0; profile[i] = 0; }
   currentprofilecounter = profilecounter;
}

bool settimerenable( const bool falsetrue )
{
   switch( falsetrue )
   {
      case false:
      remove_int( timer );
      return timerenable = false;

      default:
      return timerenable =
      install_int_ex( timer, BPS_TO_TIMER( 200 ) ) == 0;
   }
}

number pace()
{
   if( timerenable )
   remove_int( timer );

   if( profileenable )
   {
      profilesum[0] = 0;
      for( int i = 0; i < 8; ++i )
      { profilesum[0] += profile[i] += number( profilecounter[i] ) -
      profile[i] * 0.05; profilecounter[i] = 0; }
   
      profilesum[1] = 0;
      for( int i = 8; i < 16; ++i )
      { profilesum[1] += profile[i] += number( profilecounter[i] ) -
      profile[i] * 0.05; profilecounter[i] = 0; }
   
      profilesum[2] = 0;
      for( int i = 16; i < 24; ++i )
      { profilesum[2] += profile[i] += number( profilecounter[i] ) -
      profile[i] * 0.05; profilecounter[i] = 0; }
   
      profilesum[3] = 0;
      for( int i = 24; i < 32; ++i )
      { profilesum[3] += profile[i] += number( profilecounter[i] ) -
      profile[i] * 0.05; profilecounter[i] = 0; }
   }

   number dt = number( timecounter ) / 200;
   timecounter = 0;

   if( timerenable )
   install_int_ex( timer, BPS_TO_TIMER( 200 ) );
   return dt;
}

}
