
#ifndef SPECIAL_H
#define SPECIAL_H

#include "engine.h"

// ----------------------------------------------------------------------------
// CHECKERED GROUND OBJ
// ----------------------------------------------------------------------------

struct checked_ground : DP
{
   number checksize;
   int checkcount;
   int color[8];
   number radius;

   checked_ground() {};
   checked_ground( const number cs, const int cc ) : checksize( cs ), checkcount( cc ) {}

   void draw( cview &, const space &, const volume & );
};

// ----------------------------------------------------------------------------
// STARFIELD
// ----------------------------------------------------------------------------

struct starfield : DP
{
   int n;
   int color;
   vector *stars;
   space spcsave;
   bool lines;
   enum { POINTS, LINES, LINEINIT } mode;

   starfield( const int n = 500 );
   void draw( cview &, const space &, const volume & );
   void state_switch( const int );
};

// ----------------------------------------------------------------------------
// SOLID SPHERE
// ----------------------------------------------------------------------------

struct solid_sphere : DP, space, cmesh
{
   int color;
   number radius;
   number tesseld;
   vector v;
   int counter;
   int nr;

   solid_sphere();
   void draw( cview &, const space &, const volume & );
   void tesselation( const number );

   void precalc( const space & );
};

// ----------------------------------------------------------------------------
// RING
// ----------------------------------------------------------------------------

struct cring : DP, space, cmesh
{
   int color;
   number radius;

   cring( const number, const number );
   void draw( cview &, const space &, const volume & );
};

#endif
