
#include "game.h"

#include "inputs.h"
#include "global.h"
#include "synth.h"

#include <math.h>


namespace game
{

vector inputturn;
vector inputmove;

int command;

// ----------------------------------------------------------------------------
// PACE
// ----------------------------------------------------------------------------

bool inter_state_switch( const bool s )
{
   if( state.interdrive == s ) return false;

   switch( s )
   {
      case false:
      state.interdrive = false;
      break;

      case true:
      if( thrusters == 1 )
      {
         state.interdrive = true;
         interblinker.t = 0;
      }

      else return false;
      break;
   }

   return true;
}

void inter_pace( const number dt )
{
   switch( state.interdrive )
   {
      case false:
      state.interthrust -= dt * 2 * state.interthrust;
      break;

      case true:
      interblinker.pace( dt );
      state.interthrust += dt * 0.2;
      if( thrusters < 1 ) inter_state_switch( false );
   }
}

static const char *sig_menu_enter =
   "f150000/d300/p400";
static const char *sig_menu_exit =
   "f265000/p300/d-400/p300/d400/p150/d-400/p150";
static const char *sig_beep =
   "f900000/p100";


void pace_inputs( const number dt )
{
   inputturn = inputs::turn;
   inputmove = zerovector;

   switch( command )
   {
      case 0:
      if( key[ KEY_A ] ) thrusters += 0.5 * dt;
      if( key[ KEY_Z ] ) thrusters -= 0.5 * dt;
      switch( inputs::keypress )
      {
         case 'd':
         if( inter_state_switch( state.interdrive ^ true ) )
         msg( state.interdrive ? "INTERDRIVE ENGAGED" : "INTERDRIVE DISENGAGED" );
         break;
   
         case 'h':
         acthudcolor = nexthudcolor[ acthudcolor ];
         break;
   
         case 'i':
         synth::signal( sig_beep );
         switch( IRenable )
         {
            case false:
            if( IRwarmup <= 0 )
            { IRwarmup = 0.3; clear( view->framebuffer ); }
            break;
   
            case true:
            IRenable = false;
            break;
         }
         break;

         case 'o':
         engine::outline_polygons ^= true;
         break;

         case '\t':
         synth::signal( sig_menu_enter );
         command = 1;
         break;
      }
      break;

      case 1:
      switch( inputs::keypress )
      {
         case '1':
         synth::signal( sig_menu_enter );
         if( altitude / actplanet_data->radius < 0.5 ) command = 2;
         else command = 3;
         destenable = true;
         break;

         case '2':
         synth::signal( sig_menu_enter );
         command = 4;
         break;

         case '\t':
         synth::signal( sig_menu_exit );
         command = 0;
         break;
      }
      break;

      case 2:
      if( key[ KEY_1 ] ) {
         dest_loc_lat -= 100 * inputs::turn.x;
         if( dest_loc_lat > 90 ) dest_loc_lat -= 180;
         if( dest_loc_lat < -90 ) dest_loc_lat += 180;
         inputturn = zerovector; }
      if( key[ KEY_2 ] ) {
         dest_loc_long -= 100 * inputs::turn.x;
         if( dest_loc_long > 180 ) dest_loc_long -= 360;
         if( dest_loc_long < -180 ) dest_loc_long += 360;
         inputturn = zerovector; }
      switch( inputs::keypress )
      {
         case 'c':
         destenable = false;
         dest_loc_lat = 0;
         dest_loc_long = 0;
         case '\t':
         synth::signal( sig_menu_exit );
         command = 0;
         break;
      }
      break;

      case 4:
      if( key[ KEY_1 ] ) {
         if( mouse_b & 2 )
            map_zoom *= exp( 3 * inputturn.x );
         else
            map_rotate.spin(
               ( inputturn.x > 0 ? 5 : -5 ) * inputturn.x * inputturn.x / dt * map_rotate.i +
               ( inputturn.y > 0 ? 5 : -5 ) * inputturn.y * inputturn.y / dt * map_rotate.j +
               ( inputturn.z > 0 ? 5 : -5 ) * inputturn.z * inputturn.z / dt * map_rotate.k );
         inputturn = zerovector;
      }
      switch( inputs::keypress )
      {
         case 'c':
         synth::signal( sig_beep );
         map_center ^= true;
         break;

         case '\t':
         synth::signal( sig_menu_exit );
         command = 0;
      }
      break;

      default:
      if( inputs::keypress == '\t' )
      {
         synth::signal( sig_menu_exit );
         command = 0;
      }
   }

   if( key[ KEY_LCONTROL ] )
   {
      inputmove = vector( 0, inputturn.x, 0 );
      inputturn = zerovector;
   }

   else if( mouse_b & 2 )
   {
      thrusters -= 3 * inputturn.x;
      inputturn = zerovector;
   }

   if( thrusters > 1 ) thrusters = 1;
   if( thrusters < 1 ) state.interdrive = false;
   if( thrusters < 0 ) thrusters = 0;


   if( altitude / actplanet_data->radius > 0.5 )
   {
      destenable = false;
      dest_loc_lat = 0;
      dest_loc_long = 0;
   }
}

number check_dim( const vector x )
{
   number x2 = x.quadrat();
   number dim = 1;

   for( int i = 1; i < NPLANETS; ++i )
   {
      if( i != state.planetnumber )
      if( x2 > state.planets[i].s.quadrat() * 1.001 )
      {
         vector d = state.planets[i].s - x;
         vector v = zerovector - x;
         vector a = ( ( d * v ) / v.quadrat() ) * v;
         vector b = d - a;
         number z = sqrt( a.quadrat() );
         number y = sqrt( b.quadrat() ) / z;
         number ri = state.planets[i].radius / z;
         number r0 = state.planets[0].radius / sqrt( v.quadrat() );

         if( ri < r0 )
         {
            if( ( y + ri ) < r0 ) dim *= 1 - ri * ri / r0 / r0;
            else if( ( y - ri ) > r0 ) continue;
            else dim *= 1 - ( ( r0 + ri ) - y ) / 2 * ri / r0 / r0;
         }

         else
         {
            if( ( y + r0 ) < ri ) return 0;
            else if( ( y - r0 ) > ri ) continue;
            else dim *= 1 - ( ( r0 + ri ) - y ) / 2 / r0;
         }
      }
   }

   return dim;
};

void pace_space( const number dt )
{
   number rel_dens = exp( - altitude );
   number atm_dens = rel_dens * sqrt( actplanet_data->mag );
   atm_dens = atm_dens / ( 1 + atm_dens );

   number aa = altitude / actplanet_data->radius;
   aa = aa * aa / ( 5 + aa * aa );

   number v_damp = 0.3 + atm_dens * 0.7;
   number v_damp_lateral = atm_dens * 3;

   number abc = atm_dens * 5 * state.playerlocalB.k * state.playerlocalv;
   abc = 10 * abc / ( 10 + abc );
   number L_damp = 0.3 + atm_dens * 0.7;
   number L_damp_lateral = atm_dens * abc * 3;

   if( aa > 0.95 )
   {
      state.player.v -= dt * v_damp * state.player.v;
      state.player.v += dt * ( power / ( 1 + 30 * rel_dens ) * thrusters * thrusters +
         50 * state.interthrust ) * state.player.B.k;
      state.player.L -= dt * 0.6 * state.player.L;
      state.player.L += 5 * inputturn * state.player.B;

      state.player.s += dt * state.player.v;
      state.player.B.spin( dt * state.player.L );

      state.playerlocals = ( state.player.s - actplanet->s ) % actplanet->rotation_B;
      state.playerlocalv = ( state.player.v - actplanet->v ) % actplanet->rotation_B - state.playerlocals % actplanet->rotation_L;
      state.playerlocalB = state.player.B % actplanet->rotation_B;
      state.playerlocalL = ( state.player.L - actplanet->rotation_L ) % actplanet->rotation_B;
   }

   else
   {
      vector compensation_v = aa * ( state.playerlocals % actplanet->rotation_L +
         ( actplanet->v + 10 * actplanet->dv ) % actplanet->rotation_B );
      vector compensation_L = aa * ( actplanet->rotation_L % actplanet->rotation_B );

      state.playerlocalv += compensation_v;
      state.playerlocalL += compensation_L;

      state.playerlocalv -= dt * v_damp * state.playerlocalv;
      state.playerlocalv -= dt * v_damp_lateral * ( ( state.playerlocalv * state.playerlocalB.i ) * state.playerlocalB.i
         + ( state.playerlocalv * state.playerlocalB.j ) * state.playerlocalB.j );
      state.playerlocalv += dt * ( power / ( 1 + 30 * rel_dens ) * thrusters * thrusters +
         50 * state.interthrust ) * state.playerlocalB.k;
      state.playerlocalv -= 0.05 * actplanet_data->radius * rel_dens *
                               inputmove.y * dsn;

      state.playerlocalL -= dt * L_damp * state.playerlocalL;
      state.playerlocalL -= dt * L_damp_lateral * ( ( state.playerlocalL * state.playerlocalB.i ) * state.playerlocalB.i
          + ( state.playerlocalL * state.playerlocalB.j ) * state.playerlocalB.j );

      state.playerlocalL += 5 * inputturn * state.playerlocalB;
      state.playerlocalL += dt * atm_dens * 10 * state.playerlocalv * state.playerlocalB.k * dsn * state.playerlocalB.i * dsn;

      state.playerlocalv -= compensation_v;
      state.playerlocalL -= compensation_L;

      state.playerlocals += dt * state.playerlocalv;
      state.playerlocalB.spin( dt * state.playerlocalL );

      ds = dsn = state.playerlocals;
      dsn.normalize();
      altitude = sqrt( state.playerlocals.quadrat() ) - actplanet_data->radius;

      if( altitude < 0.002 )
      {
          state.playerlocals = ( 0.002 + actplanet_data->radius ) * dsn;
          state.playerlocalv -= dt * 2 * state.playerlocalv;
          altitude = 0.002;
      }

      state.player.s = state.playerlocals * actplanet->rotation_B + actplanet->s;
      state.player.v = ( state.playerlocalv + state.playerlocals % actplanet->rotation_L ) * actplanet->rotation_B + actplanet->v;
      state.player.B = state.playerlocalB * actplanet->rotation_B;
      state.player.L = state.playerlocalL * actplanet->rotation_B + actplanet->rotation_L;
   }

   // propagate sound
   // ---------------

   synth::enginesound = int( 400 * thrusters / ( 1 + 30 * rel_dens ) + 7000 * state.interthrust );
   synth::intersound = state.interdrive ? 150000 : 0;
   synth::windsoundf = int( state.playerlocalv.quadrat() /
      ( 0.2 + atm_dens ) * 3000 + 10 );
   synth::windsoundv = int( 50000 * atm_dens );
   synth::rainsound = actplanet_data->flags & RAIN ?
      int( actplanet_data->rain_height * actplanet_data->rain_height /
      ( 1 + 10 * altitude * altitude ) * actplanet_data->rain_speed * 100000 ) : 0;

   // checked ground co-motion
   // ------------------------

   ds = dsn = state.playerlocals;
   dsn.normalize();
   groundnormalbase.spin( dt / ( state.playerlocals * dsn )
      * ( state.playerlocalv % dsn ) );

   dsx = groundnormalbase.j % dsn;
   dsx.normalize();
   dsz = dsx % dsn;

   groundspace.s.x += dt * actplanet_data->radius /
      ( actplanet_data->radius + altitude ) * state.playerlocalv * dsx;
   groundspace.s.y = altitude;
   groundspace.s.z += dt * actplanet_data->radius /
      ( actplanet_data->radius + altitude ) * state.playerlocalv * dsz;

   playergroundv = actplanet->radius / ( actplanet->radius + altitude ) *
      ( state.playerlocalv - state.playerlocalv * dsn * dsn );

   groundspace.B.i = dsx;
   groundspace.B.j = dsn;
   groundspace.B.k = dsz;


   // RED color
   // ---------

   RGB redcolor = { 63, 0, 0 };
   number redmix = state.playerlocalv.quadrat() * atm_dens /
      ( 100 + state.playerlocalv.quadrat() * atm_dens  );


   // color adaptation
   // ----------------

   RGB col, col1, col2, col3, coldest, coltmp;

   number magIR = IRenable ? 0.1 : 1;
   number mag = 8 / ( 8 + magIR * actplanet_data->mag * rel_dens );
   number magsun = 8 / ( 8 + 0.1 * magIR * actplanet_data->mag * rel_dens );
   number magsky = 1 - 8 / ( 8 + 10 * magIR * actplanet_data->mag * rel_dens );
   number maginv = 8 / ( 8 + magIR * 0.1 * actplanet_data->mag * ( 1 - rel_dens ) * ( 1 - rel_dens ) );

   vector sonn = actplanet->s % actplanet->rotation_B;
   sonn.normalize();
   number dim = dsn * sonn;
   dim = dim > - 0.25 ? 0.5 : sqrt( - dim );
   dim = sqrt( mag ) + ( 1 - sqrt( mag ) ) * dim;
   number CD = check_dim( state.player.s );
   dim = 0.5 + ( dim - 0.5 ) * CD;
   dim = 0.5 + ( dim - 0.5 ) * sqrt( sqrt( mag ) );

   vector a = actplanet->s;
   vector b = a - state.player.s;
   a.normalize();
   b.normalize();
   number daylight = sqrt( sqrt( sqrt( mag ) ) ) * CD * ( 0.8 * ( a * b ) + 0.2 );
   number twilight = - 2.5 * ( a * b ) + 0.5;
   daylight = daylight < 0 ? 0 : daylight;
   twilight = twilight > 1 ? 2 - twilight : twilight;
   twilight = twilight < 0 ? 0 : twilight;
   number day2 = 0.25 * ( 1 - sqrt( sqrt( sqrt( mag ) ) ) );
   daylight = daylight < day2 ? day2 : daylight;

   // skycolor
   if( IRenable ) col.r = col.g = col.b = actplanet_data->sky_IR;
   else col = global::palette[ actplanet_data->skycolor ];
   col2.r = int( min( 63.0, magsky * sqrt( daylight * ( ( 1 - twilight ) * col.r * col.r + twilight * col.b * col.b ) ) ) );
   col2.g = int( min( 63.0, magsky * sqrt( daylight * col.g * col.g ) ) );
   col2.b = int( min( 63.0, magsky * sqrt( daylight * ( ( 1 - twilight ) * col.b * col.b + twilight * col.r * col.r ) ) ) );
   col = col2;
   BLENDCOLOR( coltmp, col, redcolor, redmix );
   set_color( backgroundcolor, &coltmp );
 
   // suncolor
   if( IRenable ) col2.r = col2.g = col2.b = 63;
   else col2 = global::palette[ planet_data[0].skycolor ];
   ADDCOLOR( col2, col, magsun )
   BLENDCOLOR( coltmp, col2, redcolor, redmix );
   set_color( state.planets[0].color, &coltmp );

   // starcolor
   if( IRenable ) col2.r = col2.g = col2.b = global::IR_palette[2] / 2;
   else col2 = global::palette[2];
   ADDCOLOR( col2, col, mag )
   BLENDCOLOR( coltmp, col2, redcolor, redmix );
   set_color( stars.color, &coltmp );

   // planet colors
   for( int i = 1; i < NPLANETS; ++i )
   {
      if( planet_data[i].flags & RING )
      {
         if( IRenable ) col2.r = col2.g = col2.b = 2 * global::IR_palette[ planet_data[i].ringcolor ] / 3;
         else col2 = global::palette[ planet_data[i].ringcolor ];
         ADDCOLOR( col2, col, mag )
         BLENDCOLOR( coltmp, col2, redcolor, redmix );
         set_color( state.planets[i].ring->color & 255, &coltmp );
      }

      if( i == nearplanet )
      {
         RGB col;
         if( IRenable )
         {
            col.r = col.g = col.b = planet_data[i].ground_IR;
            col2.r = col2.g = col2.b = planet_data[i].sky_IR;
         }

         else
         {
            col = global::palette[ planet_data[i].groundcolor1 ];
            col2 = global::palette[ planet_data[i].skycolor ];
         }

         BLENDCOLOR( col3, col2, col, maginv );
         SCALECOLOR( col2, col3, dim );
         BLENDCOLOR( coltmp, col2, redcolor, redmix );
         set_color( state.planets[i].color, &coltmp );
         SCALECOLOR( col2, col3, 0.5 );
         BLENDCOLOR( coltmp, col2, redcolor, redmix );
         set_color( state.planets[i].color + 128, &coltmp );
      }
    
      else
      {
         if( IRenable ) col2.r = col2.g = col2.b = planet_data[i].spacecol_IR;
         else col2 = planet_data[i].spacecol;
         SCALECOLOR( coldest, col2, 0.5 * check_dim( state.planets[i].s ) + 0.5 );
         ADDCOLOR( coldest, col, mag )
         BLENDCOLOR( coltmp, coldest, redcolor, redmix );
         set_color( state.planets[i].color, &coltmp );
         SCALECOLOR( coldest, col2, 0.5 );
         ADDCOLOR( coldest, col, mag );
         BLENDCOLOR( coltmp, coldest, redcolor, redmix );
         set_color( state.planets[i].color + 128, &coltmp );
      }
   }
 
   // checked ground color ramp
   if( IRenable )
   {
      col.r = col.g = col.b = actplanet_data->sky_IR;
      col1.r = col1.g = col1.b = actplanet_data->check_IR;
   }

   else
   {
      col = global::palette[ planet_data[ nearplanet ].skycolor ];
      col1 = global::palette[ planet_data[ nearplanet ].groundcolor2 ];
   }
   BLENDCOLOR( coldest, col, col1, maginv );

   for( int i = 0; i < 8; ++i )
   {
      BLENDCOLOR( col2, coldest, col3, ( 8.0 - i ) / 8 );
      SCALECOLOR( col, col2, dim );
      BLENDCOLOR( coltmp, col, redcolor, redmix );
      set_color( checked.color[i], &coltmp );
      SCALECOLOR( col, col2, 0.5 );
      BLENDCOLOR( coltmp, col, redcolor, redmix );
      set_color( checked.color[i] + 128, &coltmp );
   }

   // object colors
   number hot_factor = IRenable ? sqrt( 9000 / sqrt( actplanet->s.quadrat() ) ) : 1;
   set_color( 0, &global::palette[0] );
   set_color( 128, &global::palette[0] );
   for( int i = 1; i < 32; ++i )
   {
      if( IRenable ) col.r = col.g = col.b = (int) min( 63.0f, hot_factor * global::IR_palette[i] );
      else col = global::palette[i];
      SCALECOLOR( col2, col, dim );
      BLENDCOLOR( coltmp, col2, redcolor, redmix );
      set_color( i, &coltmp );
      SCALECOLOR( col2, col, 0.5 );
      BLENDCOLOR( coltmp, col2, redcolor, redmix );
      set_color( i + 128, &coltmp );
   }

   // the last one
   get_color( backgroundcolor, &col );
   set_color( backgroundcolor + 128, &col );

   rain_shift -= dt * actplanet_data->rain_speed * dsn;
   if( rain_shift.quadrat() > 10000 ) rain_shift = zerovector;
}

static bool first = true;

void pace( const number dt )
{
   if( first ) { first = false; goto planetsel; }

   pace_inputs( dt );
   msg_pace( dt );
   inter_pace( dt );
   // OL_pace( dt );
   IR_pace( dt );

   // planetenbewegung
   for( int i = 1; i < NPLANETS; ++i )
   {
      state.planets[i].rotation_B.spin( dt * state.planets[i].rotation_L );
      vector save = state.planets[i].s;
      vector ds = save - state.planets[ planet_data[i].parent ].s;
      state.planets[i].v = 1000 / planet_data[i].distance / planet_data[i].distance * vector( ds.z, 0, -ds.x );
      ds += dt * state.planets[i].v;
      ds = planet_data[i].distance / sqrt( ds.quadrat() ) * ds;
      state.planets[i].s = state.planets[ planet_data[i].parent ].s + ds;
      state.planets[i].v = state.planets[ planet_data[i].parent ].v + state.planets[i].v;
      state.planets[i].dv = ( - 1000000 / planet_data[i].distance / planet_data[i].distance /
         planet_data[i].distance / planet_data[i].distance ) * ds;
   }

   // feststellen, welcher himmelskrper
   // dem spieler am nchsten ist
planetsel:
   int oldnear = nearplanet;
   nearplanet = 0;
   number near = 1e10;
   for( int i = 1; i < NPLANETS; ++i )
   {
      number r = ( state.planets[i].s - state.player.s ).quadrat();
      if( r < near )
      {
         near = r;
         nearplanet = i;
      }
   }
   actplanet = &state.planets[ nearplanet ];
   actplanet_data = &planet_data[ nearplanet ];

   // hat sich der nearplanet gendert?
   if( oldnear != nearplanet )
   {
      state.planetnumber = nearplanet;
      // neue lokale koordinaten
      state.playerlocals = ( state.player.s - actplanet->s ) % actplanet->rotation_B;
      state.playerlocalv = ( state.player.v - actplanet->v ) % actplanet->rotation_B - state.playerlocals % actplanet->rotation_L;
      state.playerlocalB = state.player.B % actplanet->rotation_B;
      state.playerlocalL = ( state.player.L - actplanet->rotation_L ) % actplanet->rotation_B;
      // checked und groundspace anpassen
      checked.checksize = 0.08;
      checked.checkcount = 14;
      checked.radius = actplanet_data->radius;
      groundspace = worldspace;
      groundspace.s.y = distance( state.player.s, actplanet->s ) - actplanet_data->radius;
      groundnormalbase = identitybase;
      ds = dsn = state.playerlocals;
      dsn.normalize();
      dsx = ( groundnormalbase.j % dsn ).normalize();
      dsz = dsx % dsn;
      playergroundv = actplanet->radius / ( groundspace.s.y + actplanet->radius ) *
         ( state.playerlocalv - state.playerlocalv * dsn * dsn );
      // alte mobs raus
      if( oldnear )
      {
         planet_data[ oldnear ].MOB_fixed->pop();
         for( int i = 0; i < NCLOUDS; ++i )
            planet_data[ oldnear ].MOB_cloud[i]->pop();
      }
      // neue mobs rein
      MOBS.push( actplanet_data->MOB_fixed );
      for( int i = 0; i < NCLOUDS; ++i )
      {
         actplanet_data->MOB_cloud[i]->zzap();
         actplanet_data->MOB_cloud[i]->init();
         MOBS.push( actplanet_data->MOB_cloud[i] );
      }
   }

   //einige precalculations
   {
      altitude = sqrt( state.playerlocals.quadrat() ) - actplanet_data->radius;
      altitude2 = altitude * altitude;

      number r, h, r2, x, y;
      nearplanetdx = zerovector - state.playerlocals;
      nearplanetdx2 = nearplanetdx * nearplanetdx;
      r = planet_data[ nearplanet ].radius;
      h = nearplanetdx2s = sqrt( nearplanetdx2 );
      r2 = r * r;
      x = h - r2 / h;
      nearplanetx = x;
      nearplanetx2 = x * x;
      y = sqrt( r2 - r2 * r2 / h / h );
      nearplanetc = y / x;
      nearplanetc2 = nearplanetc * nearplanetc;
   }

   // je nach spieler-standort unterprogramme ausfhren
   // im weltraum den nchstgelegenen himmelskrper ermitteln, ggf landung einleiten
   pace_space( dt );

   /*
   //asteroid_density
   {
      vector dx = state.player.s + state.player.v;
      dx = dx - state.planets[6].s;
      number axial = sqrt( dx.x * dx.x + dx.z * dx.z ) - 220 * DF;
      number elevation = sqrt( dx.y * dx.y );
      axial *= axial;
      elevation *= elevation;
      asteroid_density = 10 * 216000 / ( 216000 + axial * axial ) * 27000 / ( 27000 + elevation * elevation );
   }

   switch( asteroid_field )
   {
      case false:
      if( asteroid_density > high_asteroid_wd )
      {
         msg( "WARNING - ASTEROIDS" ); asteroid_field = true;
         thrusters = 0;
      }
      break;

      case true:
      if( asteroid_density < low_asteroid_wd ) asteroid_field = false;
   }
   */

   if( inputs::scancode == KEY_F12 )
   {
      PALETTE pal;
      get_palette( pal );
      save_bitmap( "screenshot.bmp", view->framebuffer, pal );
   }

   if( titletime > 0 ) titletime -= dt;
   MOBS_pace( dt );
   set_color( hudcolor, global::palette + acthudcolor );

}

}
