
#include "game.h"

#include "global.h"
#include <fstream.h>
#include <string.h>
#include <math.h>

const float M_PI = 3.14159265;

namespace game
{

// ----------------------------------------------------------------------------
// INIT
// ----------------------------------------------------------------------------

bool cstate::init()
{
   fstream file( "game.txt", ios::in );

   if( seekline( file, "system_data" ) )
   {
      file >> NPLANETS >> STARTNUMBER;
      planet_data = new cplanet_data[ NPLANETS ];
      children = new list< planetindex >[ NPLANETS ];
      for( int i = 0; i < NPLANETS; ++i )
      {
         planet_data[i].MOB_fixed = new cMOBlist;

         for( int j = 0; j < NCLOUDS; ++j )
            planet_data[i].MOB_cloud[j] = new cMOBlist_cloud;

         file.width(20);

         file >> planet_data[i].name
              >> planet_data[i].parent
              >> planet_data[i].distance;

         char c;
         file >> c;
         if( c == 'o' ) file >> planet_data[i].opp;
         else { file.putback( c ); planet_data[i].opp = 0; }

         file >> planet_data[i].radius
              >> planet_data[i].groundcolor1
              >> planet_data[i].groundcolor2
              >> planet_data[i].skycolor
              >> planet_data[i].mag;

         if( !planet_data[i].parent ) { major_bodies.push( new planetindex( i ) ); NMAJORBODIES++; }
         else children[ planet_data[i].parent ].push( new planetindex( i ) );

         planet_data[i].flags = 0;

         // workaround a compiler bug in gcc 2.9.52
         // possibly only relevant for -march=k6
         int j = i;

         file >> c;
         if( c == '-' )
         while( !file.eof() )
         {
            file >> c;
            switch( c )
            {
               case 'R':
               planet_data[j].flags |= RING;
               file >> planet_data[j].ringradius
                    >> planet_data[j].ringdiameter
                    >> planet_data[j].ringcolor;
               break;

               case 'G':
               planet_data[j].flags |= GIANT;
               break;

               case 'A':
               planet_data[j].flags |= RAIN;
               file >> planet_data[j].rain_length
                    >> planet_data[j].rain_speed
                    >> planet_data[j].rain_height
                    >> planet_data[j].rain_color;
               break;

               default:
               goto next;
            }
         }
         else file.putback( c );
         next: continue;
      }
   }

   else
   { cerr << "Could not load system data.\n"; return false; }

   for( int i = 0; i < NPLANETS; ++i )
   {
      char buf[40];
      strcpy( buf, "planet_data " );
      strcat( buf, planet_data[i].name );
      file.close();
      file.open( "game.txt", ios::in );
      if( seekline( file, buf ) )
      while( !file.eof() )
      {
         file >> *buf;
         switch( *buf )
         {
            case 'f':
            {
               char buf[20];
               file.width(20);
               number loc_long, loc_lat, head, h;
               file >> loc_lat >> loc_long >> head >> h >> buf;
   
               cMOB *TMP = give_prototype( buf );
               if( TMP ) TMP = TMP->copy();
               else goto done;

               TMP->B.j = TMP->s =
                  vector(
                     cos( loc_lat / 180 * M_PI ) * sin( loc_long / 180 * M_PI ),
                     sin( loc_lat / 180 * M_PI ),
                     cos( loc_lat / 180 * M_PI ) * cos( loc_long / 180 * M_PI )
                        );

               TMP->s *= ( planet_data[i].radius + h );

               vector a = ( vector( 0, 1, 0 ) % TMP->B.j ).normalize();
               vector c = TMP->B.j % a;

               TMP->B.k = - sin( head / 180 * M_PI ) * a + cos( head / 180 * M_PI ) * c;
               TMP->B.i = cos( head / 180 * M_PI ) * a + sin( head / 180 * M_PI ) * c;
   
               planet_data[i].MOB_fixed->push( TMP );
            }
            break;

            case 'c':
            {
               int j;
               file >> j;
               file >> planet_data[i].MOB_cloud[j]->d
                    >> planet_data[i].MOB_cloud[j]->h;
               file >> buf;
               planet_data[i].MOB_cloud[j]->prototype = give_prototype( buf );
            }
            break;
   
            case '#':
            goto done;
         }
      }

      else
      {
      #ifdef PEDANTIC
      cerr << "No data found for planet " << planet_data[i].name << ".\n";
      #endif
      }

      done: ;
   }

   srand( 42 );
   for( int i = 0; i < NPLANETS; ++i )
   {
      if( planet_data[i].opp )
      {
         planets[i].s =
            planet_data[i].distance * ( planets[ planet_data[ planet_data[i].opp ].parent ].s -
            planets[ planet_data[i].opp ].s ).normalize();
      }

      else
      {
         number angle = float( rand() ) / float( RAND_MAX ) * 2 * M_PI;
         planets[i].s = vector( planet_data[i].distance * sin( angle ), 0, planet_data[i].distance * cos( angle ) );
      }

      planets[i].B = identitybase;
      planets[i].color = planet_data[i].groundcolor1;
      planets[i].radius = planet_data[i].radius;

      if( planet_data[i].parent )
         planets[i].s += planets[ planet_data[i].parent ].s;

      planets[i].rotation_L = vector( 0, 15 / planet_data[i].distance, 0 );
      planets[i].rotation_B = identitybase;

      number mag = ( 8 / ( 8 + 0.1 * planet_data[i].mag ) );
      BLENDCOLOR(
         planet_data[i].spacecol,
         global::palette[ planet_data[i].groundcolor1 ],
         global::palette[ planet_data[i].skycolor ],
         1 - mag
         );

      planet_data[i].ground_IR = int( sqrt(
         global::IR_palette[ planet_data[i].groundcolor1 ] *
         global::IR_palette[ planet_data[i].groundcolor1 ]
         / sqrt( state.planets[i].s.quadrat() ) * 3000 ) + 0.5 );

      planet_data[i].check_IR = int( sqrt(
         global::IR_palette[ planet_data[i].groundcolor2 ] *
         global::IR_palette[ planet_data[i].groundcolor2 ]
         / sqrt( state.planets[i].s.quadrat() ) * 3000 ) + 0.5 );

      mag = 8 / ( 8 + 0.1 * planet_data[i].mag );
      planet_data[i].sky_IR = int( sqrt(
         global::IR_palette[ planet_data[i].skycolor ] *
         global::IR_palette[ planet_data[i].skycolor ]
         / state.planets[i].s.quadrat() * 3000 * 3000 ) + 0.5 );

      planet_data[i].spacecol_IR = int( sqrt(
         planet_data[i].ground_IR *
         planet_data[i].ground_IR * mag +
         planet_data[i].sky_IR *
         planet_data[i].sky_IR * ( 1 - mag ) ) + 0.5 );


      planets[i].color = palalloc();

      if( planet_data[i].flags & RING )
      {
         planets[i].ring =
            new cring( planet_data[i].ringradius, planet_data[i].ringdiameter );
         planets[i].ring->s = planets[i].s;
         planets[i].ring->color = palalloc() | 256;
      }

      else
      planets[i].ring = 0;

      planets[i].num = i;
   }

   player.B = identitybase;
   interdrive = false;
   interthrust = 0;
   interdefect = false;
   intercrash = 0;
   playerlocals = zerovector;

   for( int i = 0; i < 20; ++i ) flags[i] = 0;
   return true;
}

bool init()
{
   view = new cview( 10000, 10000, 10000 );
   cout << "i0" << endl;

   view->set_viewport(
      0, 5 * global::screenh / 100,
      global::screenw, 9 * global::screenh / 10,
      - number( global::screenh ) / global::screenw / 0.75 );

   view->set_focus( 1 );

   IRcanvas = create_bitmap( view->w + 2, view->h + 2 );
   cout << "i1" << endl;

   palinit();
   for( int i = 0; i < 32; ++i ) palused[i] = true;

   backgroundcolor = palalloc();
   checked = checked_ground( 0, 0 );
   for( int i = 0; i < 8; ++i ) checked.color[i] = palalloc();
   stars.color = palalloc();

   cout << "i2" << endl;

   hudcolor = palalloc();
   ifstream file( "game.txt" );
   if( seekline( file, "next_hud_color" ) )
   while( !file.eof() )
   {
      int i;
      file >> i;
      if( i < 0 ) { file >> acthudcolor; break; }
      if( i > 31 ) continue;
      file >> nexthudcolor[i];
   }

   else
   { cerr << "Could not load data for next_hud_color.\n"; }

   cout << "i3" << endl;
   MOBS_init();

   if( !load_prototypes() ) return false;
   cout << "i4" << endl;
   if( !state.init() ) return false;
   cout << "i5" << endl;

   state.planetnumber = 0;
   state.player.s = state.planets[ STARTNUMBER ].s + vector( 1, 1, - 2 * planet_data[ STARTNUMBER ].radius );

   IR_init();

   nearplanet = 0;
   nearplanetdx = zerovector;
   nearplanetc = 0;

   titletime = 2;
   titlex = ( view->w - global::TITLE->w ) / 2;
   titley = ( view->h - global::TITLE->h ) / 2;
   if( titlex < 0 || titley < 0 ) titletime = -1;

   if( !welcomemsg )
   { cerr << "Coudn't load welcome message.\n"; }

   cout << "i4" << endl;
   msg_init();
   if( welcomemsg ) msg( welcomemsg );

   // MOBLIST_bullets = new cMOBlist;
   // MOBS.push( MOBLIST_bullets );

   for( int i = 0; i < NRAIN; ++i ) rain_vertex[i] = vector::random() + vector( 100, 100, 100 );

   destenable = false;
   dest_loc_lat = 0;
   dest_loc_long = 0;

   pace( 0.001 );
   return true;
}

}
