
#ifndef DIFF_H
#define DIFF_H

#include "vector.h"

// ----------------------------------------------------------------------------
// FIRST ORDER DIFFERENTIAL
// ----------------------------------------------------------------------------

template < typename X >
struct diff1
{
   X out, in;
   number f;

   diff1( const number f = 0 ) : f( f )
   { out -= out; in -= in; }

   void pace( const number dt )
   { out += dt * f * ( in - out ); }

   X &operator =( const X &in ) { this->in = in; return out; }
   operator X() const { return out; }
};

// ----------------------------------------------------------------------------
// FIRST ORDER DIFFERENTIAL WITH DUAL COEFF
// ----------------------------------------------------------------------------

template < typename X >
struct diff1dual 
{
   X out, in;
   number f1, f2;

   diff1dual( const number f1, const number f2 ) : f1( f1 ), f2( f2 )
   { out -= out; in -= in; }

   void pace( const number dt )
   { X tmp = in - out; out += tmp < 0 ? dt * f1 * tmp : dt * f2 * tmp; }

   X &operator =( const X &in ) { this->in = in; return out; }
   operator X() const { return out; }
};

// ----------------------------------------------------------------------------
// SECOND ORDER DIFFERENTIAL
// ----------------------------------------------------------------------------

template < typename X >
struct diff2 
{
   X out, between, in;
   number f, d;

   diff2( const number f = 0, const number d = 0 ) : f( f ), d( d )
   { out -= out; between -= between; in -= in; }

   void pace( const number dt )
   { out += dt * ( between += dt * ( f * ( in - out ) - d * between ) ); }

   X &operator =( const X &in ) { this->in = in; return out; }
   operator X() const { return out; }
};

#endif
