
#ifndef NODE_H
#define NODE_H

// ------------------------------------------------------------------
// NODE & LIST
// ------------------------------------------------------------------

struct node
{
   node *succ;
   node *pred;

   node *pop()
   {
      ( succ->pred = pred )->succ = succ;
      return this;
   }

   void insertbefore( node *N )
   {
      ( pred = N->pred )->succ = this;
      ( succ = N )->pred = this;
   }

   static void swap( node *A, node *B )
   {
      ( A->pred->succ = B )->pred = A->pred;
      ( B->succ->pred = A )->succ = B->succ;
      A->pred = B;
      B->succ = A;
   }
};

template< typename X >
struct list;

template< typename X >
struct pointer
{
   int i;
   node *n;
   node *next;
   list<X> *L;
   pointer<X> &operator ++() { ++i; n = next; next = n->succ; return *this; }
   bool finish() const { return n == L; }
   X &operator *() const { return (X &) *n; }
   X *pop() { n->pop(); return (X *) n; }
};

template< typename X >
struct list : node
{
   int count;

   list() { pred = succ = this; count = 0; }
   list( const list< X > &other ) { succ = pred = this; copy( &other ); }
   list &operator =( const list< X > &other ) { copy( &other ); return *this; }
   ~list() { zzap(); }

   void push( X *element ) { count++; element->insertbefore( this ); }
   X *pop() { count--; return (X *) pred.pop(); }
   X *pop( node *N ) { count--; return (X *) N.pop(); }
   bool isempty() const { return succ == (node *) this; }

   pointer<X> begin() const { pointer<X> TMP; TMP.L = (list<X> *) this;
      TMP.i = 0; TMP.n = succ; TMP.next = succ->succ; return TMP; }

   void copy( const list<X> *other );
   void zzap();
};

template< typename X >
void list<X>::copy( const list<X> *other )
{
   node *p = other->succ;
   while( p != (node *) other )
   {
      X *E = new X( *(X *) p );
      push( E );
      p = p->succ;
   }
   this->count = other->count;
}

template< typename X >
void list<X>::zzap()
{ 
   node *p = succ; 
   while( p != this ) 
   { 
      X *q = (X *) p;
      p = p->succ; 
      delete q; 
   } 
   count = 0; 
   succ = this; pred = this; 
}

#endif
