
#include <allegro.h>
#include <fstream.h>

#include "game.h"
#include "inputs.h"
#include "global.h"
#include "timer.h"
#include "synth.h"

BEGIN_COLOR_DEPTH_LIST
   COLOR_DEPTH_8
END_COLOR_DEPTH_LIST

BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST

typedef void *HINSTANCE;

// ------------------------------------------------------------------
// MAIN
// ------------------------------------------------------------------

int main( int, char *[] )
{

   set_uformat( U_ASCII );

   allegro_init();
   inputs::init();
   inputs::joyavailable = false;
   if( !global::init() ) return 0;
cout << "1" << endl;
   engine::init();
cout << "2" << endl;
   if( !game::init() ) return 0;
cout << "3" << endl;
   
   synth::init();
cout << "4" << endl;

   number dt = 0.02;
   global::FPS = 50;

   timer::settimerenable( true );
   if( timer::timerenable )
   do
   {
      inputs::done();
      game::draw();

      dt += 0.8 * ( timer::pace() - dt );
      global::FPS += 0.2 * ( 1 / dt - global::FPS );

      if( !inputs::async ) inputs::pace( dt );

      if( key[ KEY_F1 ] ) game::pace( 10 * dt );
      else                game::pace( dt );

      synth::pace_out_of_timer();
   }
   while( ( inputs::keypress & 255 ) != 27 );

   return 0;
}

END_OF_MAIN()



