
#include "game.h"

#include "global.h"
#include <math.h>

const float M_PI = 3.14159265;

namespace game
{

static space camera_for_fucking_sort_function;

int sortfunc( const void *s1, const void *s2 )
{
   if( ( (*(cplanet**)s1)->s - camera_for_fucking_sort_function.s ).quadrat() <
   ( (*(cplanet**)s2)->s - camera_for_fucking_sort_function.s ).quadrat() ) return 1;
   else return -1;
}

// ----------------------------------------------------------------------------
// drawing procedures
// ----------------------------------------------------------------------------

void draw_skydome(
   cview *view,
   const space &camera,
   const volume &vol )
{
   actplanet->precalc( camera );
   int ln = actplanet->nr - 1;
   int np = 6 + 6 * ln;
   int iv = 1 + 3 * ( ln + ln * ln );
   cview::chandle handle = view->get_handle();
   for( int i = 0; i < np; ++i )
      view->push_polygon( 0, np, i, ( i + 1 ) % np );
   for( int i = 0; i < np; ++i )
      view->push_vertex( actplanet->vertices[ iv + i ] %
         ( camera % *actplanet ) );
   view->push_vertex( ( 1.01 * ( camera.s - actplanet->s ) ) % camera.B );
   view->push_normal( backgroundcolor );
   view->clip_volume( handle, vol );
}

void draw_act_planet(
   cview *view,
   const space &camera,
   const space *localcamera,
   const volume &vol )
{
   if( localcamera )
   {
      MOBS_extract();
      MOBS_draw_far( *view, *localcamera, vol );

      actplanet->draw( *view, camera, vol );

      cview::chandle handle = view->get_handle();
   
      checked.draw(
         *view,
         space( groundspace.s,
                localcamera->B % groundspace.B ),
         vol );
   
      number q = sqrt( actplanet->s.quadrat() );
      vector sn = ( - 1 / q ) * actplanet->s;
      view->clip_halfspace(
         handle,
         halfspace( sn * ( actplanet->s - camera.s ),
         sn % camera.B ),
         CLIP_KEEP + 1 );
   
      MOBS_draw_shadow( *view, *localcamera, vol );
      MOBS_draw_near( *view, *localcamera, vol );
   }

   else
      actplanet->draw( *view, camera, vol );
}

void draw_planets(
   cview *view,
   const space &camera,
   const space *localcamera,
   const volume &vol )
{
   camera_for_fucking_sort_function = camera;

   // planeten sortieren
   cplanet *sp[NPLANETS];
   for( pointer< planetindex > p = major_bodies.begin(); !p.finish(); ++p )
   { sp[p.i] = state.planets + (*p).i; }
   qsort( sp, major_bodies.count, sizeof( cplanet * ), sortfunc );

   for( int i = 0; i < major_bodies.count; ++i )
   {
      if( planet_data[ sp[i]->num ].flags & RING )
      {
         vector ds = camera.s - state.planets[ sp[i]->num ].s;
         number r = sqrt( ds * ds );

         cplanet *inner[NPLANETS]; int numinner = 0;
         cplanet *outer[NPLANETS]; int numouter = 0;

         for( pointer< planetindex > p = children[ sp[i]->num ].begin(); !p.finish(); ++p )
         {
            if( planet_data[ (*p).i ].distance < planet_data[ sp[i]->num ].ringradius )
               { inner[ numinner ] = state.planets + (*p).i; ++numinner; }
            else
               { outer[ numouter ] = state.planets + (*p).i; ++numouter; }
         }

         inner[ numinner ] = state.planets + sp[i]->num;
         qsort( inner, numinner + 1, sizeof( void * ), sortfunc );
         outer[ numouter ] = state.planets + sp[i]->num;
         qsort( outer, numouter + 1, sizeof( void * ), sortfunc );

         if( r > planet_data[ sp[i]->num ].ringradius )
         for( int j = 0; j < numouter + 1; ++j )
         {
            if( outer[j] == sp[i] )
            {
               sp[i]->draw_ringdist( *view, camera, vol );
               for( int k = 0; k < numinner + 1; ++k )
                  inner[k]->draw( *view, camera, vol );
               sp[i]->draw_ringnear( *view, camera, vol );
            }

            else
               if( outer[j]->num != state.planetnumber ) outer[j]->draw( *view, camera, vol );
               else draw_act_planet( view, camera, localcamera, vol );
         }

         else
         {
            for( int j = 0; j < numouter + 1; ++j )
            if( outer[j] != sp[i] )
               if( outer[j]->num != state.planetnumber ) outer[j]->draw( *view, camera, vol );
               else draw_act_planet( view, camera, localcamera, vol );

            sp[i]->draw_ringdist( *view, camera, vol );
            sp[i]->draw_ringnear( *view, camera, vol );
            for( int j = 0; j < numinner + 1; ++j )
               if( inner[j]->num != state.planetnumber ) inner[j]->draw( *view, camera, vol );
               else draw_act_planet( view, camera, localcamera, vol );
         }
      }

      else
      {
         cplanet *cp[NPLANETS];
         cp[ children[ sp[i]->num ].count ] = state.planets + sp[i]->num;
         for( pointer< planetindex > p = children[ sp[i]->num ].begin(); !p.finish(); ++p )
            { cp[p.i] = state.planets + (*p).i; }
         qsort( cp, children[ sp[i]->num ].count + 1, sizeof( cplanet * ), sortfunc );
         for( int j = 0; j < children[ sp[i]->num ].count + 1; ++j )
            if( cp[j]->num != state.planetnumber ) cp[j]->draw( *view, camera, vol );
            else draw_act_planet( view, camera, localcamera, vol );
      }
   }
}

void draw_rain(
   cview *view,
   const space &localcamera,
   const volume &vol )
{
   // regen-effect
   if( actplanet_data->flags & RAIN )
   {
       vector b = state.playerlocals;
       b.normalize();
       b = ( - actplanet_data->rain_length * ( b + 1 / actplanet_data->rain_speed * state.playerlocalv ) ) % localcamera.B;
       number test = actplanet_data->radius + 0.2;
       test = test * test;
       vector esc = 0.4 * dsn;
       cview::chandle handle = view->get_handle();
 
       int n = int( NRAIN * ( actplanet_data->radius + actplanet_data->rain_height - state.playerlocals * dsn ) );
 
       if( state.playerlocals.quadrat() > test )
       for( int i = 0; i < n; ++i )
       {
          view->push_polygon( 0, 0, 1 );
          vector a = vector(
             fmod( rain_shift.x + rain_vertex[i].x - localcamera.s.x, 0.4 ) - 0.2,
             fmod( rain_shift.y + rain_vertex[i].y - localcamera.s.y, 0.4 ) - 0.2,
             fmod( rain_shift.z + rain_vertex[i].z - localcamera.s.z, 0.4 ) - 0.2 ) % localcamera.B;
          view->push_vertex( a );
          view->push_vertex( a + b );
          view->push_normal( actplanet_data->rain_color );
       }
 
       else
       for( int i = 0; i < n; ++i )
       {
          view->push_polygon( 0, 0, 1 );
          vector a = vector(
             fmod( rain_shift.x + rain_vertex[i].x - localcamera.s.x, 0.4 ) - 0.2,
             fmod( rain_shift.y + rain_vertex[i].y - localcamera.s.y, 0.4 ) - 0.2,
             fmod( rain_shift.z + rain_vertex[i].z - localcamera.s.z, 0.4 ) - 0.2 );
          if( ( a * dsn ) < ( actplanet_data->radius * dsn - state.playerlocals ) * dsn ) a += esc;
          a = a % localcamera.B;
          view->push_vertex( a );
          view->push_vertex( a + b );
          view->push_normal( actplanet_data->rain_color );
       }
 
       view->clip_volume( handle, vol );
   }
}
 
struct
{
   char *title;
   char *items[9];
}

menu[] =
{
   { "", { "" } },

   { "Command", { "1: Navigation Computer",
                  "2: System Map",
                  "" } },

   { "Navigation Computer", { "1: set latitude",
                              "2: set longitude",
                              "C: clear",
                              "TAB: hide",
                              "" } },

   { "Navigation Computer", { "only available on planets", "" } },

   { "System Map", { "1: turn/zoom",
                     "C: center",
                     "TAB: quit",
                     "" } }
};

void draw_menu( cview *view, int command )
{
   int fh = text_height( global::BACKSLANT );
   int x = view->w / 32;
   int y = 15 * view->h / 16 - 12 * fh;

   drawing_mode( DRAW_MODE_SOLID, 0, 0, 0 );

   textout(
      view->framebuffer,
      global::BACKSLANT,
      menu[command].title,
      x,
      y,
      hudcolor );

   hline(
      view->framebuffer,
      x,
      y + fh,
      x + text_length( global::BACKSLANT, menu[command].title ),
      hudcolor );

   for( int i = 0; *menu[command].items[i]; ++i )
      textout(
         view->framebuffer,
         global::BACKSLANT,
         menu[command].items[i],
         x,
         y + 5 + fh * (i+1),
         hudcolor );
}


void draw_artificial_horizon(
   cview *view,
   const space &localcamera )
{
   // artificial horizon
   if( state.planetnumber )
   if( altitude / actplanet_data->radius < 0.5 )
   if( state.playerlocalB.k * dsn < 0.95 )
   if( state.playerlocalB.k * dsn > -0.95 )
   {
      view->reset();

      volume vol = view->get_view_volume(
         5 * view->w / 32,
         5 * view->h / 24 );

      cview::chandle handle = view->get_handle();

      vector dsz = ( state.playerlocalB.k - state.playerlocalB.k * dsn * dsn ).normalize();
      vector dsx = ( dsn % state.playerlocalB.k ).normalize();
      vector dsy = state.playerlocalB.k % dsx;

      vector cx = vector( 1, 0, 0 );
      vector cz = vector( 0, - state.playerlocalB.k * dsn, state.playerlocalB.k * dsz );
      vector cy = cz % cx;

      base B = base(
         vector( state.playerlocalB.i * dsx, state.playerlocalB.i * dsy, 0 ),
         vector( state.playerlocalB.j * dsx, state.playerlocalB.j * dsy, 0 ),
         vector( 0, 0, 1 ) );

      for( int i = 0; i < 36; ++i )
      {
         view->push_polygon( i/19, 0, 1 );

         view->push_vertex( (
            ( i % 9 ? 0.05 : 0.15 ) * cx +
            sin( i * 10.0 / 180 * M_PI ) * cy +
            cos( i * 10.0 / 180 * M_PI ) * cz ) % B );
         view->push_vertex( (
            - ( i % 9 ? 0.05 : 0.15 ) * cx +
            sin( i * 10.0 / 180 * M_PI ) * cy +
            cos( i * 10.0 / 180 * M_PI ) * cz ) % B );

      }

      view->push_normal( hudcolor );
      view->push_normal( hudcolor + 256 );
      view->clip_volume( handle, vol );

      view->draw();
   }
}


void draw_cockpit(
   cview *view,
   const space &localcamera )
{
   int y1 = 5 * view->h / 6;
   int y2 = 15 * view->h / 16;
   int dy = y2 - y1;
   int dx = view->w / 64;

   drawing_mode( DRAW_MODE_SOLID, 0, 0, 0 );

   // thrusters
   if( state.interdrive && interblinker.out ) rectfill( view->framebuffer, 2 * dx, int( y2 - dy * thrusters ), int( 3*dx ), (int) y2, hudcolor );
   else rect( view->framebuffer, 2 * dx, int( y2 - dy * thrusters ), 3 * dx, y2, hudcolor );


   if( altitude / actplanet_data->radius < 0.5 )
   if( state.planetnumber )
   {
      // planet name
      text_mode( -1 );
      textprintf( view->framebuffer, global::BACKSLANT, 8*dx, y2-3*17, hudcolor,
         "%s", planet_data[ state.planetnumber ].name );

      // location
      vector dsn = state.playerlocals;
      dsn.normalize();
      number latitude = asin( dsn.y ) / M_PI * 180 + .5;
      number longitude = atan2( dsn.x, dsn.z ) / M_PI * 180 + .5;
      textprintf( view->framebuffer, global::BACKSLANT, 8*dx, y2-2*17, hudcolor,
         "%+.2d %+.3d", (int) latitude, (int) longitude );

      // compass
      number heading = -1;
      if( dsn.y * dsn.y < .999 )
      if( state.playerlocalB.k * dsn < 0.95 )
      if( state.playerlocalB.k * dsn > -0.95 )
      {
         vector dsx = vector( 0, 1, 0 ) % dsn;
         dsx.normalize();
         vector dsy = dsn % dsx;

         heading =
            atan2( dsx * state.playerlocalB.k,
                   - dsy * state.playerlocalB.k ) / M_PI * 180 + 180.5;
         textprintf( view->framebuffer, global::BACKSLANT,
            8*dx, y2-17, hudcolor, "%.3d", (int) heading );
      }

      // heightbar
      number y = y1 + dy * ( 1 - 2.333 * ( sqrt( state.playerlocals.quadrat() ) / planet_data[ state.planetnumber ].radius - 1 ) );
      if( y < y1 ) y = y1;
      if( y > y2 ) y = y2;
      if( state.planetnumber == 6 ) y = 0.3 * y + 0.7 * y1;
      hline( view->framebuffer, 5*dx, int( y ), 6*dx, hudcolor );
      vline( view->framebuffer, 5*dx, y1, y2, hudcolor );


      // destination
      number destheading = -1;
      if( destenable )
      {
         textout( view->framebuffer, global::BACKSLANT, "Dest:",
                  18*dx, y2-3*17, hudcolor );
         textprintf( view->framebuffer, global::BACKSLANT,
                  18*dx, y2-2*17, hudcolor,
         "%+.2d %+.3d", (int) dest_loc_lat, (int) dest_loc_long );

         vector destdsn = vector(
            cos( dest_loc_lat / 180 * M_PI ) * sin( dest_loc_long / 180 * M_PI ),
            sin( dest_loc_lat / 180 * M_PI ),
            cos( dest_loc_lat / 180 * M_PI ) * cos( dest_loc_long / 180 * M_PI ) );

         vector diffdsn = actplanet_data->radius * destdsn -
            state.playerlocals;

         vector dsx = vector( 0, 1, 0 ) % dsn;
         dsx.normalize();
         vector dsy = dsn % dsx;

         destheading =
            atan2( dsx * diffdsn, - dsy * diffdsn ) / M_PI * 180 + 180.5;

         textprintf( view->framebuffer, global::BACKSLANT,
            18*dx, y2-17, hudcolor, "%.3d", (int) destheading );
      }

      // compass bar
      #define TICK 5
      #define TACK 10
      #define TOCK 30

      BITMAP *hudbitmap = create_sub_bitmap(
         view->framebuffer,
         int( 0.2 * view->w ),
         int( 0.2 * view->h ),
         int( 0.6 * view->w ),
         int( 0.6 * view->h ) );

      if( heading >= 0 )
      {
         int m = TICK * view->w / 160;
         int a = view->w / 20;
         int b = a + view->w / 2;
         int c = TICK * view->w / 4;

         int head = int( m * ( 360 - heading ) + c );

         int snap1 = head % ( TICK * m ) / TICK;
         int snap2 = head % ( TACK * m ) / TICK;
         int snap3 = head % ( TOCK * m ) / TICK;

         int numstart = int( 720 + (TOCK-1) - head / m ) / TOCK * TOCK;

         for( int x = a + snap1; x < b; x += m )
            vline( hudbitmap, x, 2, 6, hudcolor );

         for( int x = a + snap2; x < b; x += m * ( TACK / TICK ) )
            vline( hudbitmap, x, 2, 10, hudcolor );

         for( int x = a + snap3; x < b; x += m * ( TOCK / TICK ) )
            textprintf_centre(
              hudbitmap,
              global::NUMBERS,
              x,
              16,
              hudcolor,
              "%.3d",
              (numstart+((x-a)*TICK/m/TOCK)*TOCK)%360);

         vline( hudbitmap, hudbitmap->w / 2 - 1, 0, 12, hudcolor );

         if( destenable )
         {
            int desthead = int( m * destheading ) / TICK + head / TICK;
            desthead = desthead % ( 360 * m / TICK );
   
            if( desthead > 0 && desthead < view->w / 2 )
               circle( hudbitmap, a + desthead, 6, 2, hudcolor );
         }
      }

      #undef TICK
      #undef TACK
      destroy_bitmap( hudbitmap );
      draw_artificial_horizon( view, localcamera );
   }

   msg_draw( *view );

   if( IRenable )
      textout( view->framebuffer, global::BACKSLANT, "infrared", view->w - 2*dx -
               text_length( global::BACKSLANT, "infrared" ), y2-17, hudcolor );

   if( titletime > 0 )
      blit( global::TITLE, view->framebuffer, 0, 0, titlex, titley,
      global::TITLE->w, global::TITLE->h );
}

void draw_scenery(
   cview *view,
   const space &camera,
   const space &localcamera,
   const volume &vol )
{
   view->reset();

   draw_skydome( view, camera, vol );
   stars.draw( *view, camera, vol );
   draw_planets( view, camera, &localcamera, vol );
   draw_rain( view, localcamera, vol );

   if( IRwarmup <= 0 )
   {
      if( IRenable )
      {
          BITMAP *original = view->framebuffer;
          clear( IRcanvas );
          engine::mask_enable = true;
          engine::mask_xanchor = IRxanchor[ IRcycle ];
          engine::mask_yanchor = IRyanchor[ IRcycle ];
          engine::mask_bitmap = IRbitmap;
          engine::halftone_enable = !(IRcycle & 1);
          view->framebuffer = IRcanvas;
          view->draw();
          view->framebuffer = original;
          engine::mask_enable = false;
          engine::halftone_enable = true;
          masked_blit( IRcanvas, view->framebuffer, 1, 1,
             1, 1, view->w, view->h );
      }

      else view->draw();
   }
}

number map_zoom = 20000;

base map_rotate = base(
   vector( 1, 0, 0 ),
   vector( 0, 0, 1 ),
   vector( 0, -1, 0 ) );

bool map_center = false;

void draw_system_map(
   cview *view,
   const volume &vol )
{
   view->reset();
   clear( view->framebuffer );

   space camera = map_center ?
         space( vector( - map_zoom * map_rotate.k ), map_rotate ) %
         space( vector( 0, -10, 0 ) - state.player.s, identitybase )
      :
         space( vector( - map_zoom * map_rotate.k ), map_rotate ) %
         space( vector( 0, -1000, 0 ), identitybase );

   // umlaufbahnen zeichnen
   cview::chandle handle = view->get_handle();
   for( int i = 0; i < NPLANETS; ++i )
   {
      for( int j = 0; j < 29; ++j )
         view->push_polygon( 0, j, j+1 );

      engine::makecircle(
         view->vertices + view->nvertices,
         30,
         ( state.planets[i].s - state.planets[ planet_data[i].parent ].s ) % camera.B,
         ( state.planets[i].s - state.planets[ planet_data[i].parent ].s ) % vector( 0, 1, 0 ) % camera.B,
         state.planets[ planet_data[i].parent ].s % camera, 0.5 );

      view->nvertices += 30;
   }
   view->push_normal( 6 );
   view->clip_volume( handle, vol );

   // planeten zeichnen
   draw_planets( view, camera, 0, vol );

   // eigenen standpunkt zeichnen
   vector tmp = state.player.s % camera;
   handle = view->get_handle();
   view->push_polygon( 0, 0, 2 );
   view->push_polygon( 0, 1, 3 );
   view->push_vertex( vector( tmp.x + 0.01 * tmp.z, tmp.y + 0.01 * tmp.z, tmp.z ) );
   view->push_vertex( vector( tmp.x - 0.01 * tmp.z, tmp.y + 0.01 * tmp.z, tmp.z ) );
   view->push_vertex( vector( tmp.x - 0.01 * tmp.z, tmp.y - 0.01 * tmp.z, tmp.z ) );
   view->push_vertex( vector( tmp.x + 0.01 * tmp.z, tmp.y - 0.01 * tmp.z, tmp.z ) );
   view->push_normal( hudcolor );
   view->clip_volume( handle, vol );

   // ... und auf den screen
   view->draw();
}

int polygons1;
int polygons2;

void draw()
{
   polygons1 = 0;
   polygons2 = 0;

   volume vol = view->get_view_volume();

   bool rear = false;
   space camera = state.player;
   space localcamera = space( state.playerlocals, state.playerlocalB );

   if( key[ KEY_R ] )
   {
      rear = true;
      camera.B.i.turn();
      camera.B.k.turn();
      localcamera.B.i.turn();
      localcamera.B.k.turn();
   }

   if( command == 4 )
   {
      draw_system_map( view, vol );
      polygons1 += view->npolygons;
      polygons2 += view->polygoncount;

      draw_menu( view, command );
      msg_draw( *view );

      view->set_sub_viewport(
         view->w / 32,
         view->h / 24,
         view->w / 4,
         view->h / 4 );
      view->set_focus( 1 );
      stars.n /= 4;

      draw_scenery( view, camera, localcamera, vol );
      polygons1 += view->npolygons;
      polygons2 += view->polygoncount;

      view->restore_viewport();
      stars.n *= 4;
   }

   else
   {
      draw_scenery( view, camera, localcamera, vol );
      polygons1 += view->npolygons;
      polygons2 += view->polygoncount;

      if( rear ) {
         drawing_mode( DRAW_MODE_SOLID, 0, 0, 0 );
         textout( view->framebuffer, global::BACKSLANT,
            "REAR", view->w / 32, view->h / 32, hudcolor );
      }
      else {
         draw_cockpit( view, localcamera );
         polygons1 += view->npolygons;
         polygons2 += view->polygoncount;
    
         if( command ) draw_menu( view, command );
      }
   }

   if( key[ KEY_TILDE ] )
   {
      drawing_mode( DRAW_MODE_SOLID, 0, 0, 0 );
      rectfill( view->framebuffer, 0, 0, view->w, 34, 0 );
      textprintf( view->framebuffer, global::BACKSLANT,
         5, 0, 4, "FPS: %3.2f", global::FPS );
      textprintf( view->framebuffer, global::BACKSLANT,
         5, 17, 4, "GFX Driver: %s", gfx_driver->name );
      textprintf( view->framebuffer, global::BACKSLANT,
         view->w / 3, 0, 4, "Polygon-o-meter: %d, %d",
         polygons1, game::polygons2 );
   }

   view->blast_onto( screen );
}

}
