
#include <allegro.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <stdio.h>

#include "game.h"

#include "global.h"
#include "inputs.h"
#include "special.h"
#include "synth.h"

void game::cplanet::draw( cview &v, const space &spc, const volume &vol )
{
   if( ( s - spc.s ) * spc.B.k < - radius ) return;
   solid_sphere::draw( v, spc, vol );
}

void game::cplanet::draw_local( cview &v, const space &spc, const volume &vol )
{ solid_sphere::draw( v, spc, vol ); }

void game::cplanet::draw_ringdist( cview &v, const space &spc, const volume &vol )
{
   if( ring )
   if( ( s - spc.s ) * spc.B.k > - ring->radius )
   {
      ring->s = s;
      ring->B.i = ring->B.j % ( s - spc.s );
      ring->B.i.normalize();
      ring->B.k = ring->B.i % ring->B.j;
      ring->draw( v, spc, vol );
   }
}

void game::cplanet::draw_ringnear( cview &v, const space &spc, const volume &vol )
{
   if( ring )
   if( ( s - spc.s ) * spc.B.k > - ring->radius )
   {
      ring->s = s;
      ring->B.i = ( s - spc.s ) % ring->B.j;
      ring->B.i.normalize();
      ring->B.k = ring->B.i % ring->B.j;
      ring->draw( v, spc, vol );
   }
}

// ----------------------------------------------------------------------------
// DATA STUFF
// ----------------------------------------------------------------------------

namespace game
{

int STARTNUMBER = 0;
int NPLANETS = 0;
int NMAJORBODIES = 0;

static const char *welcomemsg = load_text( "welcome_msg" );

cplanet_data *planet_data;

list< planetindex > major_bodies;
list< planetindex > *children;


static int nexthudcolor[32] =
{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

static const number power = 7;

// ----------------------------------------------------------------------------
// VARIABLES
// ----------------------------------------------------------------------------

cview *view;
cstate state;
cworld *world;

static base groundnormalbase;

static int backgroundcolor;
static starfield stars;
static checked_ground checked;
static space groundspace;

static int hudcolor, acthudcolor;
static blinker interblinker;

static number altitude;
static number altitude2;

static vector ds, dsn, dsx, dsz;
static vector playergroundv;
static number thrusters = 0;

static const char *msgtext;
static char msgline[ MSG_NUMBUFFER ][ 80 ];
static BITMAP *msgbitmap;
static number msgscroll[ MSG_NUMBUFFER ];
static number msglen[ MSG_NUMBUFFER ];
static number msgtime[ MSG_NUMBUFFER ];
static int msgphase[ MSG_NUMBUFFER ];
static int msgi;
static int msgcenterx;
static int msgputx;
static int msgputy;

static int nearplanet;
static vector nearplanetdx;
static number nearplanetdx2;
static number nearplanetdx2s;
static number nearplanetx;
static number nearplanetx2;
static number nearplanetc;
static number nearplanetc2;

static BITMAP *IRbitmap;
static int IRcycle = 0;
static int IRnumcycles = 4;
static int IRxanchor[] = { 0, 1, 1, 0 };
static int IRyanchor[] = { 0, 0, 1, 1 };
static BITMAP *IRcanvas;
static bool IRenable = false;
static number IRwarmup = 0;
static number IRstep = 0;

static number titletime = 2;
static int titlex;
static int titley;

static cplanet *actplanet;
static cplanet_data *actplanet_data;

cmesh *meshes;

// cMOBlist *MOBLIST_bullets;

vector rain_vertex[ NRAIN ];
vector rain_shift;


bool destenable;
number dest_loc_lat;
number dest_loc_long;


// ----------------------------------------------------------------------------
// PALETTE
// ----------------------------------------------------------------------------

bool palused[128];

void palinit()
{ for( int i = 0; i < 128; ++i ) palused[i] = false; }

int palalloc()
{
   for( int i = 0; i < 128; ++i )
   if( !palused[i] ) { palused[i]= true; return i; }
   return -1;
}

void palfree( const int p )
{ palused[p] = false; }

void palset( const int p, RGB &col )
{
   RGB color = col;
   set_color( p, &col );
   color.r >>= 1; color.g >>= 1; color.b >>= 1;
   set_color( p + 128, &color );
}

// ----------------------------------------------------------------------------
// IR
// ----------------------------------------------------------------------------

void IR_init()
{
   IRbitmap = create_bitmap( 32, 32 );
   clear( IRbitmap );
   for( int y = 0; y < 32; y += 2 )
      for( int x = 0; x < 32; x += 2 )
         putpixel( IRbitmap, x, y, 1 );
   IRcycle = 0;
   IRnumcycles = 4;
}

void IR_pace( const number dt )
{
   if( IRwarmup > 0 ) { IRwarmup -= dt; if( IRwarmup <= 0 ) IRenable = true; }
   else
   {
      IRstep -= dt;
      if( IRstep < 0 )
      {
         IRstep += 0.05;
         if( IRstep < 0 ) IRstep = 0.05;
         IRcycle = ( IRcycle + 1 ) % IRnumcycles;
      }
   }
}

// ----------------------------------------------------------------------------
// MSG
// ----------------------------------------------------------------------------

void msg_init()
{
   msgtext = 0;
   msgi = 0;
   memset( msgphase, 0, sizeof( msgphase ) );

   int w = int( 0.7 * view->w );
   int h = text_height( global::BACKSLANT );

   msgcenterx = w / 2;
   msgputx = ( view->w - w ) / 2;
   msgputy = int( 0.9375 * view->h - 5.5 * text_height( global::BACKSLANT ) );

   msgbitmap = create_sub_bitmap( view->framebuffer, msgputx, msgputy, w, h );
}

void msg_draw( cview &v )
{
   text_mode( -1 );
   for( int i = 0; i < MSG_NUMBUFFER; ++i )
   if( msgphase[i] )
      textout( msgbitmap, global::BACKSLANT, msgline[i],
      int( msgcenterx - msglen[i] / 2 + msgscroll[i] ), 0, hudcolor );
}

static void msgnextline()
{
   if( msgtext )
   {
      msgphase[ msgi ] = 3;
      msgi = ( msgi + 1 ) % MSG_NUMBUFFER;
      const char *s = strpbrk( msgtext, "|\n" );
      if( !s ) s = msgtext + strlen( msgtext );

      if( *s == '|' ) { msgtime[ msgi ] = 6 + 0.04 * ( s - msgtext ); s++; }
      else msgtime[ msgi ] = 3 + 0.02 * ( s - msgtext );

      if( *s ) { strncpy( msgline[ msgi ], msgtext, s - msgtext );
         msgline[ msgi ][ s - msgtext ] = 0; msgtext = s + 1; }
      else { strcpy( msgline[ msgi ], msgtext ); msgtext = 0; }

      msglen[ msgi ] = text_length( global::BACKSLANT, msgline[ msgi ] );
      msgscroll[ msgi ] = msgbitmap->w;
      msgphase[ msgi ] = 1;
      synth::brabble( msgline[ msgi ] );
   }
}

void msg_pace( const number dt )
{
   for( int i = 0; i < MSG_NUMBUFFER; ++i )
   switch( msgphase[i] )
   {
      case 1:
      msgscroll[i] -= 700 * dt;
      if( msgscroll[i] < 0 ) { msgscroll[i] = 0; msgphase[i] = 2; }
      break;

      case 2:
      msgtime[i] -= dt;
      if( msgtime[i] < 0 ) { msgphase[i] = 3; msgnextline(); }
      break;

      case 3:
      msgscroll[i] -= 700 * dt;
      if( msgscroll[i] < ( - msgbitmap->w ) ) msgphase[i] = 0;
      break;
   }
}

void msg( const char *text )
{
   msgtext = text;
   msgnextline();
}


};

