
#ifndef TIMER_H
#define TIMER_H

#include "vector.h"

namespace timer
{

extern volatile int timecounter;
extern volatile int profilecounter[32];
extern volatile int *currentprofilecounter;
extern bool timerenable;
extern bool profileenable;
extern number profile[32];
extern number profilesum[4];

void init();
bool settimerenable( const bool );
inline bool setprofileenable( const bool falsetrue )
{ return profileenable = falsetrue; }
inline void setprofilesection( int i )
{ currentprofilecounter = profilecounter + i; };
number pace();

}

#endif

