
#include <math.h>
#include <stdlib.h>

#include "special.h"

const float M_PI = 3.14159265;

// ----------------------------------------------------------------------------
// CHECKERED GROUND
// ----------------------------------------------------------------------------

template< typename X >
inline X max( X a, X b ) { return a > b ? a : b; }

template< typename X >
inline X min( X a, X b ) { return a < b ? a : b; }

void checked_ground::draw( cview &v, const space &spc, const volume &vol )
{
   if( spc.s.y < 0 ) return;

   cview::chandle handle = v.get_handle();

   space tmpspc;
   tmpspc.s.x = fmod( spc.s.x, checksize );
   tmpspc.s.y = spc.s.y;
   tmpspc.s.z = fmod( spc.s.z, checksize );
   tmpspc.B = spc.B;

   bool phase = ( int( spc.s.x / checksize ) + int( spc.s.z / checksize ) ) & 1;

   number R = tmpspc.s.y + radius;
   R = radius / checksize * sqrt( 1 - radius * radius / R / R ) + 0.5;
   R = checkcount < R ? checkcount : R;

   for( int i = 0; i < checkcount * 2; ++i )
   {
      int delta = i - checkcount;
      delta = int( R * R - delta * delta );
      if( delta )
      {
         delta = int( sqrt( delta ) );
         int jstart = checkcount - delta;
         int jend = checkcount + delta;
         number C = ( checkcount - 2 );
         C = C * C;
         number D = 0.5 * tmpspc.s.y * tmpspc.s.y;
         D = 7.9 / ( 1 + D * D * D * D * D * D * D * D );
         for( int j = jstart ; j < jend ; ++j )
         if( ( i + j & 1 ) ^ phase )
         {
            int c = 2 * int( D * max( 0.0, min( 1.0, checkcount - 2 - sqrt( ( i - tmpspc.s.x / checksize - checkcount ) * ( i - tmpspc.s.x / checksize - checkcount ) + ( j - tmpspc.s.z /checksize - checkcount ) * ( j - tmpspc.s.z / checksize - checkcount ) ) ) ) );
            if( c ) v.push_polygon ( c ,
               i + j * ( 2 * checkcount + 1 ),
               i + ( j + 1 ) * ( 2 * checkcount + 1 ),
               i + 1 + ( j + 1 ) * ( 2 * checkcount + 1 ),
               i + 1 + j * ( 2 * checkcount + 1 ) );
         }
      }
   }

   for( int i = 0; i < 8; ++i )
   { v.push_normal( color[i] ); v.push_normal( color[i] + 128 ); }

   number z = - checkcount * checksize - tmpspc.s.z;
   number zend = z + checkcount * checksize * 2.00001;
   while( z < zend )
   {
      number x = - checkcount * checksize - tmpspc.s.x;
      number xend = x + checkcount * checksize * 2.00001;
      while( x < xend )
      {
         v.push_vertex( vector( x, sqrt( radius * radius - ( x * x + z * z ) )
            - radius - tmpspc.s.y, z ) % tmpspc.B );
         x += checksize;
      }
      z += checksize;
   }

   v.clip_volume( handle, vol );
}

// ----------------------------------------------------------------------------
// STARFIELD
// ----------------------------------------------------------------------------

#define NSTARS 500
#define VOLUME 100
#define VOLUMEH 50

starfield::starfield( const int n ) : n( n )
{
   stars = new vector[ n ];
   for( int i = 0; i < n; ++i )
      stars[i] = vector( rand() & 65535, rand() & 65535, rand() & 65535 );
   state_switch( LINES );
}

void starfield::state_switch( const int mode )
{
   switch( mode )
   {
      case POINTS:
      this->mode = POINTS;
      break;

      case LINES:
      this->mode = LINEINIT;
      break;
   }
}

void starfield::draw( cview &v, const space &spc, const volume &vol )
{
   cview::chandle handle = v.get_handle();
   switch( mode )
   {
      case POINTS:
      for( int i = 0; i < n; ++i ) v.push_polygon( 0, i );
      for( int i = 0; i < n; ++i ) v.push_vertex( vector(
         fmod( stars[i].x - VOLUMEH * ( spc.B.k.x - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.x - 1 ),
         fmod( stars[i].y - VOLUMEH * ( spc.B.k.y - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.y - 1 ),
         fmod( stars[i].z - VOLUMEH * ( spc.B.k.z - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.z - 1 ) ) % spc.B );
      v.push_normal( color );
      v.clip_volume( handle, vol );
      break;

      case LINEINIT:
      for( int i = 0; i < n; ++i ) v.push_polygon( 0, i );
      for( int i = 0; i < n; ++i )
      {
         v.push_vertex( vector(
            fmod( stars[i].x - spc.s.x - VOLUMEH * ( spc.B.k.x - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.x - 1 ),
            fmod( stars[i].y - spc.s.y - VOLUMEH * ( spc.B.k.y - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.y - 1 ),
            fmod( stars[i].z - spc.s.z - VOLUMEH * ( spc.B.k.z - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.z - 1 ) ) % spc.B );
         spcsave = spc;
      }
      v.push_normal( color );
      v.clip_volume( handle, vol );
      mode = LINES;
      break;

      case LINES:
      {
         vector d = ( spc.s - spcsave.s ) % spc.B;
         spcsave = spc;
         for( int i = 0; i < n; ++i ) v.push_polygon( 0, 2 * i, 2 * i + 1 );
         for( int i = 0; i < n; ++i )
         {
            vector x = vector(
               fmod( stars[i].x - spc.s.x - VOLUMEH * ( spc.B.k.x - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.x - 1 ),
               fmod( stars[i].y - spc.s.y - VOLUMEH * ( spc.B.k.y - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.y - 1 ),
               fmod( stars[i].z - spc.s.z - VOLUMEH * ( spc.B.k.z - 1 ), VOLUME ) + VOLUMEH * ( spc.B.k.z - 1 ) ) % spc.B;
            v.push_vertex( x );
            v.push_vertex( x + d );
         }
         v.push_normal( color );
         v.clip_volume( handle, vol );
      }
      break;
   }
}

// ----------------------------------------------------------------------------
// SOLID SPHERE
// ----------------------------------------------------------------------------

static struct connect_t { int a; int b; int c; }
pconnect[150];

static void connectline( connect_t *p, const int n, int a, int b,
int c, const int m1, const int m2, const bool sense )
{
   int m = 0;
   connect_t *pend = p + n;
   if( sense )
   {
      while( p < pend )
      {
         p->a = a++;
         p->b = b++;
         m += m1; if( m >= m2 ) { m -= m2; ++c; }
         p->c = c;
         ++p;
      }
      p[-1].b -= m2;
      p[-1].c -= m1;
   }

   else
   {
      while( p < pend )
      {
         p->a = a++;
         p->b = b++;
         m += m1; if( m >= m2 ) m -= m2; else ++c;
         p->c = c++;
         ++p;
      }
      p[-1].a -= m2;
   }
}

static void makeconnect()
{
   connectline( pconnect, 6, 1, 2, 0, 0, 6, true );
   connectline( pconnect + 6, 6, 2, 1, 7, 0, 6, false );
   connectline( pconnect + 12, 12, 7, 8, 1, 6, 12, true );
   connectline( pconnect + 24, 12, 8, 7, 19, 6, 12, false );
   connectline( pconnect + 36, 18, 19, 20, 7, 12, 18, true );
   connectline( pconnect + 54, 18, 20, 19, 37, 12, 18, false );
   connectline( pconnect + 72, 24, 37, 38, 19, 18, 24, true );
   connectline( pconnect + 96, 24, 38, 37, 61, 18, 24, false );
   connectline( pconnect + 120, 30, 61, 62, 37, 24, 30, true );
}

solid_sphere::solid_sphere()
{
   flags = NORMALS;
   vertices = new vector[91];
   nvertices = 91;
   normals = new vector[150];
   colors = new unsigned[150];
   nnormals = 150;
   polygons = new polygon3d[150];
   npolygons = 150;
   tesseld = 0;
   makeconnect();
   counter = 10;
}

void solid_sphere::precalc( const space &spc )
{
   vector ds = spc.s - s;
   number d = sqrt( ds * ds );
   if( d <= radius ) return;

   number test = tesseld / ( d - radius ) - 1;
   if( test * test > 0.005 )
   {
      this_is_dirty:
      counter = 21;
      tesseld = d - radius;
      tesselation( d );
   }

   else
   {
      counter--;
      if( counter < 0 ) goto this_is_dirty;
   }

   B.k = ( spc.s - s ).normalize();
   B.j = ( spc.B.j % B.k ).normalize();
   B.i = B.j % B.k;
}

void solid_sphere::draw( cview &v, const space &spc, const volume &vol )
{
   vector ds = spc.s - s;
   number d = sqrt( ds * ds );
   if( d <= radius ) return;

   number test = tesseld / ( d - radius ) - 1;
   if( test * test > 0.005 )
   {
      this_is_dirty:
      counter = 21;
      tesseld = d - radius;
      tesselation( d );
   }

   else
   {
      counter--;
      if( counter < 0 ) goto this_is_dirty;
   }

   colors[0] = color;
   colors[1] = color + 128;

   cview::chandle handle = v.get_handle();

   if( !npolygons )
   {
      v.push_polygon( 0, 0, 0 );
      v.push_normal( ( s * ( s - spc.s ) > 0 ) ? color : color + 128 );
      v.push_vertex( vertices[0] % ( spc % *this ) );
   }

   else
   {
      B.k = ( spc.s - s ).normalize();
      B.j = ( spc.B.j % B.k ).normalize();
      B.i = B.j % B.k;
      v.transform( *this, spc % *this );
      v.cull_backfaces( handle );
      number q = sqrt( s.quadrat() );
      if( q )
      {
         vector sn = ( 1 / q ) * s;
         v.clip_halfspace( handle, halfspace( ( sn % spc.B ).turn() * ( s % spc ),
           ( sn % spc.B ).turn() ), CLIP_KEEP + 1 );
      }
   }

   v.clip_volume( handle, vol );
}

void solid_sphere::tesselation( const number d )
{
   number h[5], p[5];
   h[0] = radius / d;
   p[0] = sqrt( 1 - h[0] * h[0] );

   nr = int( 0.5 + 200 * h[0] / ( 1 + 40 * h[0] ) );
   if( nr < 1 ) nr = 1;
   for( int i = 1; i < nr; ++i )
   {
      number x = sin( M_PI * 0.5 * i / nr );
      h[i] = x + ( 1 - x ) * h[0];
      p[i] = sqrt( 1 - h[i] * h[i] );
   }

   nvertices = 1 + 3 * ( nr + nr * nr );
   vertices[0] = vector( 0, 0, radius );

   for( int i = 0; i < nr; ++i )
   engine::makecircle(
      vertices + 1 + 3 * ( i + i * i ),
      6 + 6 * i,
      vector( radius * p[ nr - i - 1 ], 0, 0 ),
      vector( 0, - radius * p[ nr - i - 1 ], 0 ),
      vector( 0, 0, radius * h [ nr - i - 1 ] ) );

   nr = int( 0.5 + 200 * h[0] / ( 1 + 40 * h[0] ) );
   npolygons = 6 * nr * nr;
   for( unsigned i = 0; i < npolygons; ++i )
   {
      polygons[i].nvertices = 3;
      polygons[i].polygonnormal_i = 0;
      polygons[i].vertices_i[0] = pconnect[i].a;
      polygons[i].vertices_i[1] = pconnect[i].b;
      polygons[i].vertices_i[2] = pconnect[i].c;
   }

   nnormals = 2;
   make_normals();
   if( nr < 1 ) nr = 1;
}

// ----------------------------------------------------------------------------
//  RING
// ----------------------------------------------------------------------------

cring::cring( const number radius, const number diameter )
{
   int nsegments = 50;
   this->radius = radius + diameter;

   vertices = new vector[ 2 * nsegments ];
   polygons = new polygon3d[ 2 * nsegments ];
   normals = new vector[ 2 ];
   colors = new unsigned[ 2 ];

   int nh = nsegments/2+1;

   for( int i = 0; i < nsegments/2; ++i )
   push_polygon( 0, i, (i+1) % nh, nh + ((i+1) % nh), nh+i );

   engine::makecircle( vertices, nsegments, radius * vector( 1, 0, 0 ), radius * vector( 0, 0, 1 ), zerovector );
   engine::makecircle( vertices + nh, nsegments, ( radius + diameter ) * vector( 1, 0, 0 ), ( radius + diameter ) * vector( 0, 0, 1 ), zerovector );
   nvertices = 2 * nh;

   B = identitybase;

   nnormals = 2;
}

void cring::draw( cview &v, const space &spc, const volume &vol )
{
   colors[0] = color;
   cview::chandle handle = v.transform( *this, spc % *this );
   v.clip_volume( handle, vol );
}


