
#ifndef INPUTS_H
#define INPUTS_H

#include <string.h>

#include "diff.h"
#include "vector.h"

namespace inputs
{

extern bool async;

// joystick
extern bool joyavailable;

// mouse
extern bool mouseavailable;
extern int mousenumbuttons;
extern bool mousecursor;

// keyboard
extern bool keyavailable;
extern int keypress;
extern int scancode;

// resulting movement and turning vector
// collected from all input devices
extern vector move;
extern vector turn;

// resulting functional button state
// collected from all input devices
extern struct buttons_t
{
   bool halt;
   bool strafe;

   struct
   {
      bool up;
      bool down;
      bool left;
      bool right;
   }
   hat;
}
buttons;

void init();
void pace( const number );

inline void done()
{
   bool x = async;
   if( x ) { async = false; }
   memset( &buttons, 0, sizeof( buttons ) );
   move = zerovector;
   turn = zerovector;
   async = x;
   keypress = 0;
   scancode = 0;
}

}

#endif


