
#include <allegro.h>
#include <iostream.h>
#include <string.h>

#include "inputs.h"

namespace inputs
{

bool async;

// joystick
bool joyavailable = false;
diff2< vector > filterjoy( 100, 15 );
diff2< number > filterthrust( 100, 15 );

// mouse
bool mouseavailable = false;
int mousenumbuttons;
int last_mouse_x = 0;
int last_mouse_y = 0;
int last_mouse_b = 0;
diff2< vector > filtermouse( 100, 15 );
bool mousecursor = false;

// keyboard
bool keyavailable = false;
diff2< number > turnfilter( 100, 15 );
int keypress = 0;
int scancode = 0;

// resulting movement and turning vector
// collected from all input devices
vector move = zerovector;
vector turn = zerovector;

// resulting functional button state
// collected from all input devices
buttons_t buttons;

void pace( const number dt_given )
{
   number dt = dt_given > 0.09 ? 0.09 : dt_given;

   if( joyavailable )
   {
      poll_joystick();
      filterjoy.in.x = number( joy[0].stick[0].axis[0].pos ) / 128;
      filterjoy.in.y = number( joy[0].stick[0].axis[1].pos ) / 128;
      filterjoy.in.z = 0;
      filterthrust.in = number( (signed)( joy[0].stick[2].axis[0].pos ) - 128 ) / 128;
      filterjoy.pace( dt );
      filterthrust.pace( dt );
      buttons.halt = joy[0].button[0].b;
      buttons.strafe = joy[0].button[2].b;
      buttons.hat.left |= joy[0].stick[1].axis[0].d1;
      buttons.hat.right |= joy[0].stick[1].axis[0].d2;
      buttons.hat.up |= joy[0].stick[1].axis[1].d1;
      buttons.hat.down |= joy[0].stick[1].axis[1].d2;
   }

   if( keyavailable )
   {
      if( keypressed() )
      { keypress = readkey(); scancode = keypress >> 8;
      keypress = keypress & 0xff; }

      buttons.halt |= key[ KEY_SPACE ];
      buttons.strafe |= key[ KEY_LCONTROL ];
      buttons.hat.left |= key[ KEY_LEFT ];
      buttons.hat.right |= key[ KEY_RIGHT ];
      buttons.hat.up |= key[ KEY_UP ];
      buttons.hat.down |= key[ KEY_DOWN ];

      if( key[ KEY_COMMA ] ) turnfilter.in = 1;
      else if( key[ KEY_STOP ] ) turnfilter.in = -1;
      else turnfilter.in = 0;
      turnfilter.pace( dt );
      turn.y += dt * turnfilter.out;

      if( key[ KEY_A ] ) move.z += dt;
      if( key[ KEY_Z ] ) move.z -= dt;
   }

   if( joyavailable )
   {
      if( buttons.strafe )
      { move.x += dt * filterjoy.out.x;
      move.y -= dt * filterjoy.out.y; }

      else
      { turn.z += dt * filterjoy.out.x;
      turn.x += dt * filterjoy.out.y; }

      if( filterthrust.out > 0.1 || filterthrust.out < -0.1 )
      move.z += dt * filterthrust.out;
   }

   if( mouseavailable )
   {
      /*
      int mouse_b_now = mouse_b;
      if( ( mouse_b_now & (~last_mouse_b) ) & 2 )
      switch( mousecursor )
      {
         case false:
         position_mouse( last_mouse_x, last_mouse_y );
         mousecursor = true;
         break;

         case true:
         last_mouse_x = mouse_x;
         last_mouse_y = mouse_y;
         get_mouse_mickeys( 0, 0 );
         show_mouse( 0 );
         mousecursor = false;
         break;
      }
      last_mouse_b = mouse_b_now;
      */

      if( !mousecursor )
      {
         int mickx, micky;
         get_mouse_mickeys( &mickx, &micky );

         filtermouse.in.x = 0.0001 * mickx / dt;
         filtermouse.in.y = 0.0001 * micky / dt;

         if( filtermouse.in.x > dt ) filtermouse.in.x = dt;
         if( filtermouse.in.y > dt ) filtermouse.in.y = dt;
         if( filtermouse.in.x < -dt ) filtermouse.in.x = -dt;
         if( filtermouse.in.y < -dt ) filtermouse.in.y = -dt;

         filtermouse.pace( dt );
        /*
         if( buttons.strafe )
         { move.x += filtermouse.out.x;
         move.y -= filtermouse.out.y; }
   
         else
         */
         { turn.z += filtermouse.out.x;
         turn.x += filtermouse.out.y; }
      }
   }
}

END_OF_FUNCTION( dummy );

void init()
{
   async = false;

   filterjoy.out = filterjoy.between = filterjoy.in = zerovector;
   filterthrust.out = filterthrust.between = filterthrust.in = 0;

   // keyboard
   install_keyboard();
   keyavailable = true;
   cout << "keyboard ok" << endl;

   // mouse
   install_timer();
   cout << "mouse ";
   switch( mousenumbuttons = install_mouse() )
   {
      case -1:
      mouseavailable = false;
      cout << "failed" << endl;
      break;

      default:
      mouseavailable = true;
      cout << "ok, " << mousenumbuttons << " buttons" << endl;
      { int dumx, dumy; get_mouse_mickeys( &dumx, &dumy ); }
   }

   // joystick
   /*
   switch( load_joystick_data( 0 ) )
   {
      case 0:
      joyavailable = true;
      cout << "joystick ok" << endl;
      break;

      default:
      switch( install_joystick( JOY_TYPE_FSPRO ) )
      {
         case 0:
         cout << "joystick calibration" << endl;
         while( joy[0].flags & JOYFLAG_CALIBRATE )
         {
            cout << calibrate_joystick_name( 0 )
            << ", and press a key" << endl;
            readkey();
            if( calibrate_joystick( 0 ) != 0 )
            {
               joyavailable = false;
               cout << "joystick failed" << endl;
               break;
            }
         }
         save_joystick_data( 0 );
         break;

         default:
         joyavailable = false;
         cout << "joystick failed" << endl;
      }
   }

   if( joyavailable )
   {
      cout << joy[0].num_sticks << " sticks" << endl;
      cout << joy[0].num_buttons << " buttons" << endl;
      for( int i = 0; i < joy[0].num_sticks; ++i )
      cout << "stick " << i << ": "
      << joy[0].stick[i].num_axis << " axes" << endl;
   }

   LOCK_FUNCTION( dummy );
   install_int_ex( input_caller, MSEC_TO_TIMER( int( 1000 * input_dt ) ) );
   */
};

}

