
#include <fstream.h>

#include "global.h"

bool seekline( istream &is, const char *line )
{
   is.clear();
   is.seekg( 0 );
   char buf[80];
   while( !is.eof() )
   {
      is.getline( buf, 80 );
      if( !strcmp( buf, line ) ) return true;
   }
   return false;
}

const char *load_text( const char *ID )
{
   fstream file( "game.txt", ios::in );
   if( !seekline( file, ID ) ) return 0;

   long pos = file.tellg();

   while( !file.eof() )
   { char c; file >> c; if( c == '#' ) break; }

   long pos2 = file.tellg();
   if( pos2 == pos ) return 0;

   char *buf = new char[ pos2 - pos + 1 ];

   seekline( file, ID );
   file.get( buf, pos2 - pos, '#' );
   buf[ pos2 - pos ] = 0;
   return (const char *) buf;
}

namespace global
{

float FPS;

int colordepth;
int screenw, screenh;

cdata< FONT > BACKSLANT;
cdata< FONT > NUMBERS;
cdata< BITMAP > TITLE;

PALETTE palette;
int IR_palette[32];

template< typename X >
inline X max( X a, X b ) { return a > b ? a : b; }

bool init()
{
   fstream is( "init.txt", ios::in );
   if( !is ) { cerr << "Could not open init.txt"; return 0; }

   int gfx_card = GFX_AUTODETECT;

   while( !is.eof() )
   {
		char line[80];
   	is.getline( line, 80 );

      /*
      if( !strcmp( line, "set_color_depth" ) )
      {
         is >> colordepth;
         set_color_depth( colordepth );
      }
      */

      if( !strcmp( line, "set_gfx_card" ) )
      {
         is.getline( line, 80 );
         if( !strcmp( line, "autodetect" ) ) gfx_card = GFX_AUTODETECT;

         #ifdef GFX_SAFE
         if( !strcmp( line, "safe" ) ) gfx_card = GFX_SAFE;
         #endif

         #ifdef GFX_VESA1
         if( !strcmp( line, "vesa1" ) ) gfx_card = GFX_VESA1;
         #endif

         #ifdef GFX_VESA2B
         if( !strcmp( line, "vesa2B" ) ) gfx_card = GFX_VESA2B;
         #endif

         #ifdef GFX_VESA2L
         if( !strcmp( line, "vesa2L" ) ) gfx_card = GFX_VESA2L;
         #endif

         #ifdef GFX_VESA3
         if( !strcmp( line, "vesa3" ) ) gfx_card = GFX_VESA3;
         #endif

         #ifdef GFX_VBEAF
         if( !strcmp( line, "vbeaf" ) ) gfx_card = GFX_VBEAF;
         #endif

         #ifdef GFX_VGA
         if( !strcmp( line, "vga" ) ) gfx_card = GFX_VGA;
         #endif

         #ifdef GFX_MODEX
         if( !strcmp( line, "modex" ) ) gfx_card = GFX_MODEX;
         #endif

         #ifdef GFX_SVGALIB
         if( !strcmp( line, "svgalib" ) ) gfx_card = GFX_SVGALIB;
         #endif

         #ifdef GFX_FBCON
         if( !strcmp( line, "fbcon" ) ) gfx_card = GFX_FBCON;
         #endif

         #ifdef GFX_GGI
         if( !strcmp( line, "ggi" ) ) gfx_card = GFX_GGI;
         #endif
      }

      if( !strcmp( line, "set_gfx_mode" ) )
      {
         colordepth = 8;
         set_color_depth( 8 );
         is >> screenw >> screenh;
         cout << screenw << " x " << screenh << " requested" << endl;
         if( set_gfx_mode( gfx_card, screenw, screenh, 0, 0 ) < 0 )
         { cerr << "Coudn't set screen mode: " << allegro_error; return false; }
	 cout << "Screenmode ok " << endl;
         clear( screen );
         #ifdef CLIPPING
         set_clip( screen, 0, 0, 0, 0 );
         #endif
      }

      if( !strcmp( line, "set_palette" ) )
      while( !is.eof() )
      {
         char c;
         is >> c;
         if( c == '#' ) break;
         is.putback( c );
         int i, r, g, b, ir;
         is >> i >> r >> g >> b >> ir;
         palette[i].r = r;
         palette[i].g = g;
         palette[i].b = b;
         IR_palette[i] = ir;
         set_color( i, &palette[i] );
         palette[i+128].r = palette[i].r >> 1;
         palette[i+128].g = palette[i].g >> 1;
         palette[i+128].b = palette[i].b >> 1;
         set_color( 128 + i, &palette[i+128] );
      }
   }

   if( !(BACKSLANT = load_datafile_object( "glider.dat", "Backslant" )) )
   { cerr << "Couldn't load font"; return false; }

   if( !(NUMBERS = load_datafile_object( "glider.dat", "Numbers" )) )
   { cerr << "Couldn't load font"; return false; }

   if( !(TITLE = load_datafile_object( "glider.dat", "Title" )) )
   { cerr << "Couldn't load title bitmap"; return false; }

   return true;
}

}
