
#ifndef GAMEMOB_H
#define GAMEMOB_H

#include "engine.h"

namespace game
{

// ------------------------------------------------------------------

struct cMOB : newton_object
{
   bool kill_me_please;
   char *name;
   cmesh *mesh;
   cmesh *meshlow;
   number lowdist;
   number visdist;

   cMOB() { kill_me_please = false; mesh = meshlow = 0; }

   void pace( const number ) {};

   virtual void draw( cview &, const space &, const volume & );
   virtual void draw_shadow( cview &, const space &, const volume & );

   virtual cMOB *copy() const { return new cMOB( *this ); };
};

struct cMOB_bullet : cMOB
{
   number time_to_live;

   void draw_shadow( cview &, const space &, const volume & )
   {}

   void pace( const number dt )
   {
      s += dt * v;
      time_to_live -= dt;
      if( time_to_live < 0 ) kill_me_please = true;
   }

   cMOB *copy() const { return new cMOB_bullet( *this ); }
};

struct cMOB_airplane : cMOB
{
   number hdest;
   bool turn;
   vector headvector;
   int loop;
   number wait;
   bool iflag;

   cMOB_airplane() { hdest = 0; loop = 0; wait = 0; iflag = true; }
   void pace( const number );
   cMOB *copy() const { return new cMOB_airplane( *this ); }
};

// ------------------------------------------------------------------

struct cMOBlist : node
{
   virtual ~cMOBlist() {};

   list< cMOB > list;
   bool update;

   cMOBlist() { update = false; }

   void zzap()
   { list.zzap(); }

   unsigned extract_half( cMOB **, unsigned, const unsigned );

   virtual void pace( const number );

   void push( cMOB *pcMOB )
   {
      list.push( pcMOB );
      update = true;
   }

   void kill( cMOB *pcMOB )
   {
      pcMOB->pop();
      delete pcMOB;
      update = true;
   }
};

struct cMOBlist_cloud : cMOBlist
{
   number d, s, h;
   cMOB *prototype;
   cMOBlist_cloud();

   void pace( const number );
   void put( const number );
   void init();
};

// ------------------------------------------------------------------

struct cMOBS : list< cMOBlist >
{
   cMOB **halflist;
   cMOB **farlist;
   cMOB **nearlist;

   unsigned maxhalf, maxfar, maxnear;
   unsigned numhalf, numfar, numnear;

   int half_counter, visible_counter;

   cMOBS()
   {
      maxhalf = 5000; halflist = new (cMOB *) [ maxhalf ];
      maxfar = 500; farlist = new (cMOB *) [ maxfar ];
      maxnear = 500; nearlist = new (cMOB *) [ maxnear ];
      flush();
   }

   void flush()
   { half_counter = visible_counter = 0; }

   void draw_far( cview &view, const space &spc, const volume &vol );
   void draw_near( cview &view, const space &spc, const volume &vol );
   void draw_shadow( cview &view, const space &spc, const volume &vol );

   void extract_half()
   {
      numhalf = 0;
      for( pointer< cMOBlist > p = begin(); !p.finish(); ++p )
         numhalf = (*p).extract_half( halflist, numhalf, maxhalf );
   }

   void extract_visible();

   void pace( const number dt )
   { for( pointer< cMOBlist > p = begin(); !p.finish(); ++p ) (*p).pace( dt ); }
};

// ------------------------------------------------------------------

extern list< cMOB > prototypes;
bool load_prototypes();
cMOB *give_prototype( const char * );

}

#endif
