/*
	Programa: Bejeweled.c

	Grupo: Flvio Almada de Frana,
		   Suellen Silva Sampaio e
	       Vincius Lima Ribeiro

	Data: Ms de Novembro e Dezembro de 2006

	Descrio: Jogo Bejeweled.
*/

#include "jogo.h"

int main (void)
{
	srand(time(NULL));

	pega_nome();

    if (!inicia())
    {

		finaliza();
    }

    principal();
    finaliza();

    return 0;
}
END_OF_MAIN()

int inicia (void)
{
	allegro_init();
	install_keyboard();
	install_mouse();
	install_timer();

	set_color_depth(COLOR_BITS);
	if (set_gfx_mode(GFX_AUTODETECT, MAX_X, MAX_Y, V_MAX_X, V_MAX_Y) < 0)
	{
 		printf(MSG);
        return (FALSE);
    }

    if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL) < 0)
	{
	   printf(MSG);
	   return (FALSE);
	}

	set_volume(255,255); /* som digital e msica; 0 a 255 */

	return (TRUE);
 }

void principal (void)
{
	srand(time(NULL));

	buffer = create_bitmap(MAX_X, MAX_Y);
	if (!buffer) return;

	relogio = create_bitmap(100, 50);

	carrega_imagens();
	carrega_sons();

	play_sample(beethoven, 255, 128, 1000, TRUE);
	pre_abertura();
	abertura();

	menu_opcoes();
}

void copia_buffer (void)
{
	blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
	/*Copia o buffer para a screen.*/
}

void carrega_imagens(void)
{
	fundo_menu = load_bitmap("./imagens/fundomenu.bmp", NULL);
	if(fundo_menu == NULL) printf(MSG);
	cursor = load_bitmap("./imagens/cursor.bmp", NULL);
	if(cursor == NULL) printf(MSG);
	logo = load_bitmap("./imagens/salario3menor.bmp", NULL);
	if(logo == NULL) printf(MSG);
	fundo1 = load_bitmap("./imagens/fundo1v2.bmp", NULL);
	if(fundo1 == NULL) printf(MSG);
	fundo2 = load_bitmap("./imagens/fundo2v2.bmp", NULL);
	if(fundo2 == NULL) printf(MSG);
	fundo3 = load_bitmap("./imagens/fundo3v2.bmp", NULL);
	if(fundo3 == NULL) printf(MSG);
	fundo4 = load_bitmap("./imagens/fundo4v2.bmp", NULL);
	if(fundo4 == NULL) printf(MSG);
	fundo5 = load_bitmap("./imagens/fundo5v2.bmp", NULL);
	if(fundo5 == NULL) printf(MSG);
	peca_azul = load_bitmap("./imagens/peca_azul.bmp", NULL);
	if(peca_azul == NULL) printf(MSG);
	peca_amarelo = load_bitmap("./imagens/peca_amarelo.bmp", NULL);
	if(peca_azul == NULL) printf(MSG);
	peca_cinza = load_bitmap("./imagens/peca_cinza.bmp", NULL);
	if(peca_cinza == NULL) printf(MSG);
	peca_laranja = load_bitmap("./imagens/peca_laranja.bmp", NULL);
	if(peca_laranja == NULL) printf(MSG);
	peca_roxo = load_bitmap("./imagens/peca_roxo.bmp", NULL);
	if(peca_roxo == NULL) printf(MSG);
	peca_verde = load_bitmap("./imagens/peca_verde.bmp", NULL);
	if(peca_verde == NULL) printf(MSG);
	peca_vermelho = load_bitmap("./imagens/peca_vermelho.bmp", NULL);
	if(peca_vermelho == NULL) printf(MSG);
	menu = load_bitmap("./imagens/menucopy.bmp", NULL);
	if(menu == NULL) printf(MSG);
	salariopequeno = load_bitmap("./imagens/salariopequeno.bmp", NULL);
	if(salariopequeno == NULL) printf(MSG);
	logobej = load_bitmap("./imagens/logo.bmp", NULL);
	if(logobej == NULL) printf(MSG);
	relogio = load_bitmap("./imagens/relogio.bmp", NULL);
	if(relogio == NULL) printf(MSG);
	pontuacao = load_bitmap("./imagens/pontuacao.bmp", NULL);
	if(pontuacao == NULL) printf(MSG);
	scores = load_bitmap("./imagens/fundo.bmp", NULL);
	if(scores == NULL) printf(MSG);
	ufrj = load_bitmap("./imagens/ufrjcinza.bmp", NULL);
	if(ufrj == NULL) printf(MSG);
	flavio = load_bitmap("./imagens/flavio.bmp", NULL);
	if(flavio == NULL) printf(MSG);
	suellen = load_bitmap("./imagens/suellen.bmp", NULL);
	if(suellen == NULL) printf(MSG);
	vinicius = load_bitmap("./imagens/vinicius.bmp", NULL);
	if(vinicius == NULL) printf(MSG);
	josef = load_bitmap("./imagens/josef.bmp", NULL);
	if(josef == NULL) printf(MSG);
	chucknorris = load_bitmap("./imagens/chuck_norris.bmp", NULL);
	if(chucknorris == NULL) printf(MSG);
	darthvader = load_bitmap("./imagens/darthvader.bmp", NULL);
	if(darthvader == NULL) printf(MSG);
	acre = load_bitmap("./imagens/acre.bmp", NULL);
	if(acre == NULL) printf(MSG);
	gameover = load_bitmap("./imagens/gameover.bmp", NULL);
	if(gameover == NULL) printf(MSG);
	jack_bauer = load_bitmap("./imagens/24horas.bmp", NULL);
	if(jack_bauer == NULL) printf(MSG);
	malandro = load_bitmap("./imagens/malandro.bmp", NULL);
	if(malandro == NULL) printf(MSG);
	pegadinha = load_bitmap("./imagens/parabens.bmp", NULL);
	if(pegadinha == NULL) printf(MSG);

	/*Carrega as imagens que sero usadas no jogo. Se pelo menos uma
	imagem no existir, ou houver algum erro no carregamento, a mensagem
	de erro  impressa.*/
}

void carrega_sons (void)
{
	jaguar = load_wav("./sons/jaguar.wav");
	if(jaguar == NULL) printf(MSG);
	escolha = load_wav("./sons/chimes.wav");
	if(escolha == NULL) printf(MSG);
	beethoven = load_wav("./sons/Sinfonia.wav");
	if(beethoven == NULL) printf(MSG);
	starwars = load_wav("./sons/darthvader.wav");
	if(starwars == NULL) printf(MSG);
	zelda = load_wav("./sons/link.wav");
	if(zelda == NULL) printf(MSG);
	mortalkombat = load_wav("./sons/mortal.wav");
	if(mortalkombat == NULL) printf(MSG);
	unreal = load_wav("./sons/unreal.wav");
	if(unreal == NULL) printf(MSG);
	shaman = load_wav("./sons/Shaman.wav");
	if(shaman == NULL) printf(MSG);
}

void parar_samples(void)
{
	if(fase == 1)
	{
		stop_sample(shaman);
		/*Para de tocar a msica da primeira fase, caso esteja na primeira fase.*/
	}
	if(fase == 2)
	{
		stop_sample(zelda);
		/*Para de tocar o tema de Zelda, caso esteja na segundo fase.*/
	}
	if(fase == 3)
	{
		stop_sample(mortalkombat);
		/*Para de tocar o tema de Mortal Kombat, caso esteja na terceira fase.*/
	}
	if(fase == 4)
	{
		stop_sample(starwars);
		/*Para de tocar a Marcha Imperial, caso esteja na quarta fase.*/
	}
	if(fase == 5)
	{
		stop_sample(unreal);
		/*Para de tocar o tema de Unreal, caso esteja na quinta fase.*/
	}
}

void abertura (void)
{
	int x, y, tam_x, tam_y;

	x = 395;
	y = 295;
	tam_x = 10;
	tam_y = 8;

	tempo_abertura = 0; /*iniciando o timer*/
	LOCK_VARIABLE(tempo_abertura);
	LOCK_FUNCTION(ctrl_abertura);
	install_int(ctrl_abertura, 1000/10);

	while (mouse_b != 1)
	/*Mostra a abertura enqunato o mouse no for clicado.*/
	{
		while (x > 175)
		{
			if(tempo_abertura)
			{
				clear(buffer);
				stretch_blit(logo, buffer, 0, 0, logo->w, logo->h, x, y, tam_x, tam_y); /*stretch blit  para deformar um bitmap*/
				/*uns calculos bizarros q eu fiz pro algoritmo rodar direitinho, eu nao sabia como implantar
				  esses calculos dentro do algoritmo, ento resolvi eu fazer e colocar aki os numeros pro pc...*/
				x = x - 5;
				y = y - 1.47727272727;
				tam_x = tam_x + 9.40909090909;
				tam_y = tam_y + 4.27272727272;
				copia_buffer();
				tempo_abertura = 0;
			}
		}

		blit(logo, buffer, 0, 0, 175, 230, logo->w, logo->h);
		rest(1000); /*o rest serve pra esperar um segundo antes de apagar o logo da tela.*/

		break;
	}

	remove_int(ctrl_abertura);

	return;
}

int menu_principal (void)
{
	int x = 0, dx = 3, escolha=0;

	ctrl_menu = 0; /*iniciando o timer*/
	LOCK_VARIABLE(ctrl_menu);
	LOCK_FUNCTION(inc_ctrl_vel);
	install_int(inc_ctrl_vel, 1000 / 40);

	while (segundos >= 0)
	{
		if(ctrl_menu)
		{
			set_mouse_sprite(cursor);
			show_mouse(NULL);
			clear(buffer);
			blit(fundo_menu, buffer, x + 400, 0, 0, 0, buffer->w, buffer->h); /*faz o fundo que fica atras do menu andar*/
			blit(fundo_menu, buffer, 0, 0, 400 - x, 0, buffer->w, buffer->h); /*faz o fundo que fica atras do menu andar*/
			x = x + dx;
			if (x >= 200 || x <= -200)
			{
				dx = -dx;
			}
			draw_sprite(buffer, menu, 0, 0);
			show_mouse(buffer);
			/*verificacao de em que botao do menu o mouse est e se est clicado.*/
			if (mouse_x >= 250 && mouse_x <= 550 && mouse_y >= 200 && mouse_y <= 260)
			{
				if(mouse_b == 1)
				{
					escolha = 1;
					return 1;
				}
			}
			if (mouse_x >= 250 && mouse_x <= 550 && mouse_y >= 270 && mouse_y <= 325)
			{
				if(mouse_b == 1)
				{
					escolha = 2;
					return 2;
				}
			}
			if (mouse_x >= 250 && mouse_x <= 550 && mouse_y >= 335 && mouse_y <= 395)
			{
				if(mouse_b == 1)
				{
					escolha = 3;
					return 3;
				}
			}
			if (mouse_x >= 250 && mouse_x <= 550 && mouse_y >= 405 && mouse_y <= 465)
			{
				if(mouse_b == 1)
				{
					escolha = 4;
					return 4;
				}
			}
			if (mouse_x >= 250 && mouse_x <= 550 && mouse_y >= 475 && mouse_y <= 535)
			{
				if(mouse_b == 1)
				{
					finaliza();
				}
			}

			/*o menu retorna um valor diferente dependendo do botao que foi apertado.*/
			copia_buffer();
			ctrl_menu = 0;
		}

	}

	return escolha;
}

void desenha_grade(BITMAP *fundo)
{
	int i;
	for(i=0; i<11; i++)
	{
		hline(fundo, 250, 50 + i*QUADRADO, 750, PRETO);
		vline(fundo, 250 + i*QUADRADO, 50, 550, PRETO);
	}
	blit(fundo, buffer, 0, 0, 0, 0, buffer->w, buffer->h);
}

void sorteia_pecas (int i, int j)
{
	pecas[i][j] = rand()%7;
	/*isso  a soluo para o problema de aparecerem tres peas repetidas*/
	while (pecas[i][j] == pecas[i-1][j] && pecas[i][j] == pecas[i-2][j] && i >= 2)
	{
		pecas[i][j] = rand()%7;
	}
	while (pecas[i][j] == pecas[i][j-1] && pecas[i][j] == pecas[i][j-2] && j >= 2)
	{
		pecas[i][j] = rand()%7;
	}
}

void desenha_pecas(int n, int i, int j)
{
	if (n==0)	draw_sprite(buffer, peca_azul, 250 + i*QUADRADO, 50 + j*QUADRADO);
	if (n==1)	draw_sprite(buffer, peca_amarelo, 250 + i*QUADRADO, 50 + j*QUADRADO);
	if (n==2)	draw_sprite(buffer, peca_cinza, 250 + i*QUADRADO, 50 + j*QUADRADO);
	if (n==3)	draw_sprite(buffer, peca_laranja, 250 + i*QUADRADO, 50 + j*QUADRADO);
	if (n==4)	draw_sprite(buffer, peca_roxo, 250 + i*QUADRADO, 50 + j*QUADRADO);
	if (n==5)	draw_sprite(buffer, peca_verde, 250 + i*QUADRADO, 50 + j*QUADRADO);
	if (n==6)	draw_sprite(buffer, peca_vermelho, 250 + i*QUADRADO, 50 + j*QUADRADO);
}

void inc_ctrl_vel (void)
{
	ctrl_menu++;
}
END_OF_FUNCTION(inc_ctrl_vel)

void ctrl_abertura (void)
{
	tempo_abertura++;
}
END_OF_FUNCTION(ctrl_abertura)

void tempo (void)
{
	if(fase == 1)
	{
		tempo_jogo(fundo1);
	}
	if(fase == 2)
	{
		tempo_jogo(fundo2);
	}
	if(fase == 3)
	{
		tempo_jogo(fundo3);
	}
	if(fase == 4)
	{
		tempo_jogo(fundo4);
	}
	if(fase == 5)
	{
		tempo_jogo(fundo5);
	}
}
END_OF_FUNCTION(tempo)

void ctrl_pre_abertura (void)
{
	minerva++;
}
END_OF_FUNCTION(ctrl_pre_abertura)


int verifica (void)
{
	int i, j, verdade = 0;

	for (j=0; j<10; j++)
	{
		for (i=0; i<10; i++)
		{
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i+2][j] && i < 8 && pecas[i][j] != 7)
			{
				verdade = 1;
			}
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i][j+2] && j < 8 && pecas[i][j] != 7)
			{
				verdade = 1;
			}
		}
	}
	return verdade;
}

void desaparece (BITMAP *fundo)
{
	int i, j, n[10][10]; /*matriz auxiliar para facilitar o desaparecimento das pecas.*/

	for (j=0; j<10; j++)
	{
		for (i=0; i<10; i++)
		{
			n[i][j] = 0; /*a matriz deve ser zerada.*/
		}
	}

	for(j=0; j<10; j++)
	{
		for(i=0; i<10; i++)
		{
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i+2][j] && i < 8)
			/*Testa se existem 3 peas iguais juntas na vertical.*/
			{
				while (pecas[i][j] == pecas[i+1][j] && pecas[i][j] != 7)
				/*Executa a tarefa enquanto existirem peas iguais juntas.*/
				{
					n[i][j] = 1; /*cada peca que devera ser apagada recebera o valor 1 na matriz auxiliar.*/
					i++;
				}
				n[i][j] = 1;
			}
		}
	}
	/*Esse loop percorre a matriz, testando se existem 3 ou mais peas iguais juntas.
	Se existirem, elas recebem o valor 1 na matriz temporria.
	O valor 1 indica quais peas devem ser apagadas.*/

	for(j=0; j<10; j++)
	{
		for(i=0; i<10; i++)
		{
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i][j+2] && j < 8)
			/*Testa se existem 3 peas iguais juntas na horizaontal.*/
			{
				while (pecas[i][j] == pecas[i][j+1] && pecas[i][j] != 7)
				/*Executa a tarefa enquanto existirem peas iguais juntas.*/
				{
					n[i][j] = 1; /*cada peca que devera ser apagada recebera o valor 1 na matriz auxiliar.*/
					j++;
				}
				n[i][j] = 1;
			}
		}
	}
	/*Esse loop percorre a matriz, testando se existem 3 ou mais peas iguais juntas.
	Se existirem, elas recebem o valor 1 na matriz temporria.
	O valor 1 indica quais peas devem ser apagadas.*/

	for (j=0; j<10; j++)
	{
		for (i=0; i<10; i++)
		{
			if (n[i][j] == 1)
			{
				pecas[i][j] = 7; /*cada lugar onde a matriz auxiliar recebeu 1 vai receber 7.*/
				jogador.score += 5;

				clear(pontuacao);
				text_mode(-1);
				textprintf(pontuacao, font, 0, 0, BRANCO, "%d", jogador.score);
				draw_sprite(fundo, pontuacao, 50, 270);
				copia_buffer();
			}

		}
	}
}

void cai_pecas (void)
{
	int i, j, l;

	for(i=0; i<10; i++)
	{
		for(j=0; j<10; j++)
		{
			if(pecas[i][j] == 7 && j == 0)
			{
				pecas[i][j] = rand()%7;
				redesenha_matriz();
				continue;
			}
			if(pecas[i][j] == 7 && j > 0)
			{
				for(l=j; l>0; l--)
				{
					pecas[i][l] = pecas[i][l-1];
					redesenha_matriz();
				}

				pecas[i][0] = rand()%7;
				redesenha_matriz();

				continue;
			}
		}
	}

}

void destruir_bitmaps (void)
{
	destroy_bitmap(fundo1);
	destroy_bitmap(fundo2);
	destroy_bitmap(buffer);
	destroy_bitmap(peca_azul);
	destroy_bitmap(peca_roxo);
	destroy_bitmap(peca_amarelo);
	destroy_bitmap(peca_verde);
	destroy_bitmap(peca_vermelho);
	destroy_bitmap(peca_cinza);
	destroy_bitmap(peca_laranja);
	destroy_bitmap(logo);
	destroy_bitmap(cursor);
	destroy_bitmap(menu);
	destroy_bitmap(fundo_menu);
	destroy_bitmap(salariopequeno);
	destroy_bitmap(logobej);
	destroy_bitmap(relogio);
	destroy_bitmap(scores);
	destroy_bitmap(ufrj);
	destroy_bitmap(flavio);
	destroy_bitmap(suellen);
	destroy_bitmap(vinicius);
	destroy_bitmap(josef);
	destroy_bitmap(chucknorris);
	destroy_bitmap(darthvader);
	destroy_bitmap(acre);
	destroy_bitmap(gameover);
	destroy_bitmap(jack_bauer);
	destroy_bitmap(malandro);
	destroy_bitmap(pegadinha);
}

void destruir_samples (void)
{
	destroy_sample(escolha);
	destroy_sample(jaguar);
	destroy_sample(beethoven);
	destroy_sample(starwars);
	destroy_sample(zelda);
	destroy_sample(mortalkombat);
	destroy_sample(unreal);
	destroy_sample(shaman);
}

void texto(BITMAP *fundo)
{
	text_mode(-1);
	textout(fundo, font, "Nome:", 45, 140, BRANCO);
	textprintf(fundo, font, 45, 160, BRANCO, "%s", jogador.nome);
	textprintf(fundo, font, 50, 200, BRANCO, "FASE %d", fase);
	textout(fundo, font, "PONTOS:", 45, 250, BRANCO);
	textout(fundo, font, "tempo restante:", 40, 480, BRANCO);
	textout(fundo, font, "Voltar ao menu", 300, 20, PRETO);
	textout(fundo, font, "Iniciar novo jogo", 600, 20, PRETO);
	textout(fundo, font, "Sair do jogo", 500, 570, PRETO);
	textout(fundo, font, "DICA", 50, 400, BRANCO);
}

void dica (void)
{
	int i, j, cont=0;
	PONTO ponto;

	for(i=0; i<10; i++)
	{
		for(j=0; j<10; j++)
		{
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i][j+3] && (j+3) <= 9)
			{
				ponto.x = 250 + i*QUADRADO;
				ponto.y = 50 + (j+3)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i-1][j+2] && (i-1) >= 0 && (j+2) <= 9)
			{
				ponto.x = 250 + (i-1)*QUADRADO;
				ponto.y = 50 + (j+2)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i+1][j+2] && (i+1) <= 9 && (j+2) <= 9)
			{
				ponto.x = 250 + (i+1)*QUADRADO;
				ponto.y = 50 + (j+2)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i][j-2] && (j-2) >= 0)
			{
				ponto.x = 250 + i*QUADRADO;
				ponto.y = 50 + (j-2)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i-1][j-1] && (i-1) >= 0 && (j-1) >= 0)
			{
				ponto.x = 250 + (j-1)*QUADRADO;
				ponto.y = 50 + (i-1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i][j+1] && pecas[i][j] == pecas[i+1][j-1] && (i+1) <= 9 && (j-1) >= 0)
			{
				ponto.x = 250 + (i+1)*QUADRADO;
				ponto.y = 50 + (j-1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i+3][j] && (i+3) <= 9)
			{
				ponto.x = 250 + (i+3)*QUADRADO;
				ponto.y = 50 + j*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i+2][j-1] && (i+2) <= 9 && (j-1) >= 0)
			{
				ponto.x = 250 + (i+2)*QUADRADO;
				ponto.y = 50 + (j-1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i+2][j+1] && (i+2) <= 9 && (j+1) <= 9)
			{
				ponto.x = 250 + (i+2)*QUADRADO;
				ponto.y = 50 + (j+1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i-2][j] && (i-2) >= 0)
			{
				ponto.x = 250 + (i-2)*QUADRADO;
				ponto.y = 50 + j*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i-1][j-1] && (i-1) >= 0 && (j-1) >= 0)
			{
				ponto.x = 250 + (i-1)*QUADRADO;
				ponto.y = 50 + (j-1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+1][j] && pecas[i][j] == pecas[i-1][j+1] && (i-1) >= 0 && (j+1) <= 9)
			{
				ponto.x = 250 + (i-1)*QUADRADO;
				ponto.y = 50 + (j+1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+2][j] && pecas[i][j] == pecas[i+1][j-1] && (i+1) <= 9 && (j-1) >= 0)
			{
				ponto.x = 250 + (i+1)*QUADRADO;
				ponto.y = 50 + (j-1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i+2][j] && pecas[i][j] == pecas[i+1][j+1] && (i+1) <= 9 && (j+1) <= 9)
			{
				ponto.x = 250 + (i+1)*QUADRADO;
				ponto.y = 50 + (j+1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i][j+2] && pecas[i][j] == pecas[i+1][j+1] && (i+1) <= 9 && (j+1) <= 9)
			{
				ponto.x = 250 + (i+1)*QUADRADO;
				ponto.y = 50 + (j+1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
			if(pecas[i][j] == pecas[i][j+2] && pecas[i][j] == pecas[i-1][j+1] && (i-1) >= 0 && (j+1) <= 9)
			{
				ponto.x = 250 + (i-1)*QUADRADO;
				ponto.y = 50 + (j+1)*QUADRADO;

				rect(screen, ponto.x, ponto.y, ponto.x + QUADRADO, ponto.y + QUADRADO, AMARELO);
				cont++;
				rest(1000);
				break;
			}
		}

		if(cont == 1) break;
	}
}

void jogo (BITMAP *fundo)
{
	int i, j, selecao = 0;
	/* contadores necessarios, variaveis de origem dos quadrados,
	e variavel de verificacao de selecao de um quadrado. */

	int iselecao_x1, iselecao_y1, iselecao_x2, iselecao_y2;
	/*variaveis do indice do quadrado selecionado. */

	PONTO ponto1, ponto2;

	desenha_grade(fundo);

	texto(fundo);

	draw_sprite(fundo, logobej, 30, 50);
	draw_sprite(fundo, salariopequeno, 50, 530);

	 /*iniciando o timer*/
	LOCK_VARIABLE(segundos);
	LOCK_FUNCTION(tempo);
	install_int(tempo, 1000);


	for(j=0; j<10; j++)
	{
		for(i=0; i<10; i++)
		{
			sorteia_pecas(i, j); /*sorteio das jias*/
			desenha_pecas(pecas[i][j], i, j);
		}
	}

	copia_buffer();

	while (!key[KEY_ESC] && (segundos >= 0) && (jogador.score <= fase*1000) && (jogador.score < 4500))
	/*Executa o jogo enquanto a tecla ESC no for apertada e no acabar o tempo*/
	{

		set_mouse_sprite(cursor);
		show_mouse(NULL);
		while (!key[KEY_ESC] && segundos >= 0 && jogador.score < 4500)
		/*Executa o loop enquanto a tecla ESC no for pressionada e no acabar o tempo.*/
		{
			while(mouse_x >= 300 && mouse_x <= 410 && mouse_y >= 10 && mouse_y <= 30)
			{
				textout(fundo, font, "Voltar ao menu", 300, 20, BRANCO);

				if(mouse_b == 1)
				{

					principal();
				}
			}

			while(mouse_x >= 600 && mouse_x <= 735 && mouse_y >= 10 && mouse_y <= 30)
			{
				textout(fundo, font, "Iniciar novo jogo", 600, 20, BRANCO);

				if(mouse_b == 1)
				{
					parar_samples();
					stop_sample(beethoven);
					fase = 1;
					segundos = 300;
					clear(pontuacao);
					jogador.score = 0;
					play_sample(shaman, 255, 128, 1000, TRUE);
					textout(fundo1, font, "Voce ainda eh", 30, 300, BRANCO);
					textout(fundo1, font, "um INICIANTE!", 30, 320, BRANCO);
					play_sample(shaman, 255, 128, 1000, TRUE);
					jogo(fundo1);
					armazena_arquivo();
				}
			}

			while(mouse_x >= 500 && mouse_x <= 600 && mouse_y >= 560 && mouse_y <= 580)
			{
				textout(fundo, font, "Sair do jogo", 500, 570, BRANCO);

				if(mouse_b == 1)
				{
					finaliza();
				}
			}

			while(mouse_x >= 50 && mouse_x <= 80 && mouse_y >= 390 && mouse_y <= 410)
			{
				textout(fundo, font, "DICA", 50, 400, AMARELO);

				if(mouse_b == 1)
				{
					jogador.score -= 10;
					dica();
					clear(pontuacao);
					text_mode(-1);
					textprintf(pontuacao, font, 0, 0, BRANCO, "%d", jogador.score);
					draw_sprite(fundo, pontuacao, 50, 270);
					copia_buffer();
					break;
				}
			}

			if ((mouse_b == 1) && (mouse_x >= 250) && (mouse_x <= 750) && (mouse_y >= 50) && (mouse_y <= 550)) /*verificao da posio do mouse.*/
			{
				ponto1.x = mouse_x - (mouse_x%QUADRADO); /*Coordenada x do primeiro vrtice do quadraddo selecionado.*/
				ponto1.y = mouse_y - (mouse_y%QUADRADO); /*Coordenada y do primeiro vrtice do quadraddo selecionado.*/
				rect(screen, ponto1.x, ponto1.y, ponto1.x + QUADRADO, ponto1.y + QUADRADO, BRANCO);
				/* Quando clicar em algum lugar da grade, encontra as coordenadas do primeiro vrtice do quadrado onde o mouse foi clicado*/
				iselecao_x1 = (mouse_x - 250)/QUADRADO; /*ndice horizontal do primeiro quadrado*/
				iselecao_y1 = (mouse_y - 50)/QUADRADO; /*ndice vertical do primeiro quadrado*/
				selecao = 1; /*indicador de selecao*/
				break;
			}

			show_mouse(NULL); /*apenas redesenhando o mouse e o fundo...*/
			blit(fundo, buffer, 0, 0, 0, 0, buffer->w, buffer->h);

			redesenha_matriz();

			if (selecao == 1)
			{
				rect(buffer, ponto1.x, ponto1.y, ponto1.x + QUADRADO, ponto1.y + QUADRADO, BRANCO);

				if(iselecao_x1 != 9)
				{
					rect(buffer, ponto1.x + QUADRADO, ponto1.y, ponto1.x + 2*QUADRADO, ponto1.y + QUADRADO, BRANCO);
				}

				if(iselecao_x1 != 0)
				{
					rect(buffer, ponto1.x - QUADRADO, ponto1.y, ponto1.x, ponto1.y + QUADRADO, BRANCO);
				}

				if(iselecao_y1 != 0)
				{
					rect(buffer, ponto1.x, ponto1.y - QUADRADO, ponto1.x + QUADRADO, ponto1.y, BRANCO);
				}

				if(iselecao_y1 != 9)
				{
					rect(buffer, ponto1.x, ponto1.y + QUADRADO, ponto1.x + QUADRADO, ponto1.y + 2*QUADRADO, BRANCO);
				}
				/*Marca o quadrado selecionado e seus vizinhos, com um quadrdao branco.*/
				/*Os ifs servem para que no seja marcado nada fora da grade.*/
			}

			show_mouse(buffer);
			copia_buffer();
		}

		while (mouse_b == 1);
		/*No faz nada enquanto o boto do mouse estiver pressionado.*/

		while (!key[KEY_ESC] && segundos >= 0)
		/*Executa o loop enquanto no acabar o tempo.*/
		{
			if ((mouse_b == 1) && (mouse_x >= 250) && (mouse_x <= 750) && (mouse_y >= 50) && (mouse_y <= 550))
			/*Testa se o mouse foi clicado dentro da grade.*/
			{
				ponto2.x = mouse_x -(mouse_x%QUADRADO); /*Coordenada x do primeiro vrtice do quadraddo selecionado.*/
				ponto2.y = mouse_y -(mouse_y%QUADRADO); /*Coordenada y do primeiro vrtice do quadraddo selecionado.*/
				/* Quando clicar em algum lugar da grade, encontra as coordenadas do primeiro vrtice do quadrado onde o mouse foi clicado*/
				iselecao_x2 = (mouse_x - 250)/QUADRADO; /*ndice horizontal do primeiro quadrado*/
				iselecao_y2 = (mouse_y - 50)/QUADRADO; /*indice vertical do primeiro quadrado*/
				selecao = 1; /*indicador de selecao*/
				break;
			}

			show_mouse(NULL);
			blit(fundo, buffer, 0, 0, 0, 0, buffer->w, buffer->h);

			redesenha_matriz();

			if (selecao == 1)
			{
				rect(buffer, ponto1.x, ponto1.y, ponto1.x + QUADRADO, ponto1.y + QUADRADO, BRANCO);

				if(iselecao_x1 != 9)
				{
					rect(buffer, ponto1.x + QUADRADO, ponto1.y, ponto1.x + 2*QUADRADO, ponto1.y + QUADRADO, BRANCO);
				}

				if(iselecao_x1 != 0)
				{
					rect(buffer, ponto1.x - QUADRADO, ponto1.y, ponto1.x, ponto1.y + QUADRADO, BRANCO);
				}

				if(iselecao_y1 != 0)
				{
					rect(buffer, ponto1.x, ponto1.y - QUADRADO, ponto1.x + QUADRADO, ponto1.y, BRANCO);
				}

				if(iselecao_y1 != 9)
				{
					rect(buffer, ponto1.x, ponto1.y + QUADRADO, ponto1.x + QUADRADO, ponto1.y + 2*QUADRADO, BRANCO);
				}
				/*Marca o quadrado selecionado e seus vizinhos, com um quadrdao branco.*/
				/*Os ifs servem para que no seja marcado nada fora da grade.*/
			}

			show_mouse(buffer);
			copia_buffer();
		}

		while (mouse_b == 1);

		if (((ponto1.x == ponto2.x && (ponto1.y == ponto2.y + QUADRADO)) ||
			 (ponto1.x == ponto2.x && (ponto1.y == ponto2.y - QUADRADO)) ||
			 (ponto1.y == ponto2.y && (ponto1.x == ponto2.x + QUADRADO)) ||
			 (ponto1.y == ponto2.y && (ponto1.x == ponto2.x - QUADRADO))))
		{
			pecas[iselecao_x1][iselecao_y1] = pecas[iselecao_x1][iselecao_y1] ^ pecas[iselecao_x2][iselecao_y2];
			pecas[iselecao_x2][iselecao_y2] = pecas[iselecao_x2][iselecao_y2] ^ pecas[iselecao_x1][iselecao_y1];
			pecas[iselecao_x1][iselecao_y1] = pecas[iselecao_x1][iselecao_y1] ^ pecas[iselecao_x2][iselecao_y2];
			/*troca feita com ou exclusivo bit a bit!*/

			blit(fundo, buffer, 0, 0, 0, 0, buffer->w, buffer->h);

			redesenha_matriz(); /*redesenha a matriz aps a troca...*/

			rect(buffer, ponto1.x, ponto1.y, ponto1.x + QUADRADO, ponto1.y + QUADRADO, PRETO);
			/*desmarcar o quadrado selecionado*/

			selecao = 0;	/*desativar o marcador de selecao*/


		}
		else
		{
			/*Este else destroca as pecas se elas no forem vizinhas.*/
			pecas[iselecao_x1][iselecao_y1] = pecas[iselecao_x1][iselecao_y1] ^ pecas[iselecao_x2][iselecao_y2];
			pecas[iselecao_x2][iselecao_y2] = pecas[iselecao_x2][iselecao_y2] ^ pecas[iselecao_x1][iselecao_y1];
			pecas[iselecao_x1][iselecao_y1] = pecas[iselecao_x1][iselecao_y1] ^ pecas[iselecao_x2][iselecao_y2];
			selecao = 0;

		}


		if (!verifica())
		{
			/*Este else destroca as pecas se nenhuma peca sumir apos a troca.*/
			pecas[iselecao_x1][iselecao_y1] = pecas[iselecao_x1][iselecao_y1] ^ pecas[iselecao_x2][iselecao_y2];
			pecas[iselecao_x2][iselecao_y2] = pecas[iselecao_x2][iselecao_y2] ^ pecas[iselecao_x1][iselecao_y1];
			pecas[iselecao_x1][iselecao_y1] = pecas[iselecao_x1][iselecao_y1] ^ pecas[iselecao_x2][iselecao_y2];
			selecao = 0;
		}

		while (verifica())
		{
			desaparece(fundo);

			redesenha_matriz();
			copia_buffer();

			cai_pecas();

			redesenha_matriz();
			copia_buffer();
		}

		if(verifica())
		{
			while(verifica())
			{
				desaparece(fundo);

				redesenha_matriz();
				copia_buffer();

				cai_pecas();

				redesenha_matriz();
				copia_buffer();
			}
		}

		if(testa_combinacoes())
		{
			break;
		}

	}

	if(segundos <= 0)
	{
		armazena_arquivo();

		while(mouse_b != 1)
		{
			game_over();
		}
	}
	else if (testa_combinacoes())
	{
		armazena_arquivo();

		textout(gameover, font, "Acabaram as combinacoes possiveis", 300, 225, BRANCO);

		while(!key[KEY_ESC])
		{
			game_over();
		}
	}
	else if (jogador.score >= 4500)
	{
		segundos = 5;

		while (segundos >= 0)
		{
			jack();
		}

		parabens();
	}
	else
	{
		fase++;
		muda_fase();
		remove_int(tempo);
	}
}

void pega_nome (void)
{
	printf("Digite seu nome.\n");
	gets(jogador.nome);
	/*L o nome do jogador.*/
}

void redesenha_matriz (void)
{
	int i, j;

	for(j=0; j<10; j++)
	{
		for(i=0; i<10; i++)
		{
			desenha_pecas(pecas[i][j], i, j);
		}
	}
	/*Redesenha a tela do jogo sempre q for preciso.*/
}

void high_scores(void)
{
	FILE *pontuacao;
	char linha[DIM];
	int i=0;

	pontuacao = fopen("recordes.txt", "r");

	if(!pontuacao)
	{
		printf("Erro ao abrir o arquivo de recordes!");
		finaliza();
	}

	draw_sprite(scores, logobej, 50, 50);
	draw_sprite(scores, salariopequeno, 600, 500);

	while(!feof(pontuacao))
	{
		fgets(jogador.nome, DIM, pontuacao);
		fgets(linha, DIM, pontuacao);
		sscanf(linha, "%d", &jogador.score);

		text_mode(-1);
		textprintf(scores, font, 200, 200 + i, PRETO, "%s", jogador.nome);
		textprintf(scores, font, 500, 200 + i, PRETO, "%d", jogador.score);

		i += 30;
	}

	while(!key[KEY_ESC])
	{
		textout(scores, font, "Voltar ao menu", 400, 100, PRETO);
		blit(scores, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		show_mouse(scores);

		while (mouse_x >= 400 && mouse_x <= 510 && mouse_y >= 90 && mouse_y <= 110)
		{
			textout(scores, font, "Voltar ao menu", 400, 100, BRANCO);
			blit(scores, screen, 0, 0, 0, 0, MAX_X, MAX_Y);

			if(mouse_b == 1)
			{
				parar_samples();
				principal();
			}
		}
	}
}

void creditos (void)
{
	while(!key[KEY_ESC])
	{
		show_mouse(scores);
		text_mode(-1);
		textout(scores, font, "Desenvolvido por:", 100, 100, PRETO);
		textout(scores, font, "Flavio Almada de Franca", 100, 140, PRETO);
		textout(scores, font, "Suellen Silva Sampaio", 100, 160, PRETO);
		textout(scores, font, "Vinicius Lima Ribeiro", 100, 180, PRETO);
		textout(scores, font, "Projeto de 2006/02 de Computacao para a Informatica", 200, 450, PRETO);
		textout(scores, font, "Ciencia da Computacao UFRJ", 200, 500, PRETO);
		textout(scores, font, "Voltar ao menu", 200, 550, PRETO);
		blit(flavio, scores, 0, 0, 100, 200, flavio->w, flavio->h);
		blit(suellen, scores, 0, 0, 300, 200, suellen->w, suellen->h);
		blit(vinicius, scores, 0, 0, 500, 200, vinicius->w, vinicius->h);
		blit(scores, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		show_mouse(scores);

		while (mouse_x >= 200 && mouse_x <= 310 && mouse_y >= 540 && mouse_y <= 560)
		{
			textout(scores, font, "Voltar ao menu", 200, 550, BRANCO);
			blit(scores, screen, 0, 0, 0, 0, MAX_X, MAX_Y);

			if(mouse_b == 1)
			{
				parar_samples();
				principal();
			}
		}
	}
}

void pre_abertura (void)
{
	minerva = 0; /*iniciando o timer*/
	LOCK_VARIABLE(minerva);
	LOCK_FUNCTION(ctrl_pre_abertura);
	install_int(ctrl_pre_abertura, 6000);

	while(!minerva)
	{
		text_mode(-1);
		blit(ufrj, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		rest(1000);
		textout(ufrj, font, "Projeto de 2006/02 de Computacao para a Informatica", 200, 150, makecol(255, 0, 0));
		blit(ufrj, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		rest(1000);
		textout(ufrj, font, "Ciencia da Computacao UFRJ", 300, 200, makecol(255, 0, 0));
		blit(ufrj, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		rest(1000);
		textout(ufrj, font, "Flavio", 250, 300, makecol(255, 0, 0));
		textout(ufrj, font, "Vinicius", 250, 350, makecol(255, 0, 0));
		textout(ufrj, font, "Suellen", 250, 400, makecol(255, 0, 0));
		blit(ufrj, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		rest(1000);
		textout(ufrj, font, "Almada", 350, 300, makecol(255, 0, 0));
		textout(ufrj, font, "Lima", 350, 350, makecol(255, 0, 0));
		textout(ufrj, font, "Silva", 350, 400, makecol(255, 0, 0));
		blit(ufrj, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		rest(1000);
		textout(ufrj, font, "de Franca", 450, 300, makecol(255, 0, 0));
		textout(ufrj, font, "Ribeiro", 450, 350, makecol(255, 0, 0));
		textout(ufrj, font, "Sampaio", 450, 400, makecol(255, 0, 0));
		blit(ufrj, screen, 0, 0, 0, 0, MAX_X, MAX_Y);
		rest(1000);
	}
	remove_int(ctrl_pre_abertura);
}

void ajuda (void)
{
	while(!key[KEY_ESC])
	{
		show_mouse(NULL);
		text_mode(-1);
		textout(scores, font, "O jogo consiste em uma grade 10X10 com pecas dispostas aleatoriamente.", 100, 200, makecol(0, 0, 0));
		textout(scores, font, "Sao 7 pecas diferentes e cada vez que 3 ou mais pecas iguais sao postas", 100, 220, makecol(0, 0, 0));
		textout(scores, font, "juntas na mesma linha, ou na mesma coluna, essas pecas desaparecem,", 100, 240, makecol(0, 0, 0));
		textout(scores, font, "dando lugar as pecas imediatamente acima. Na primeira linha, novas", 100, 260, makecol(0, 0, 0));
		textout(scores, font, "pecas sao sorteadas. 5 pontos sao somados para cada peca desaparecida.", 100, 280, makecol(0, 0, 0));
		textout(scores, font, "Seu objetivo eh somar o maximo de pontos possivel. O jogo termina quando", 100, 300, makecol(0, 0, 0));
		textout(scores, font, "acaba o tempo, a tecla ESC eh pressionada ou acabam as combinacoes possiveis.", 100, 320, makecol(0, 0, 0));
		textout(scores, font, "Para mover as pecas, clique no quadrado desejado e depois clique em um", 100, 340, makecol(0, 0, 0));
		textout(scores, font, "quadrado vizinho, o qual voce deseja que seja trocado pelo anterior.", 100, 360, makecol(0, 0, 0));
		textout(scores, font, "Obs: A funcao dica acarreta em um custo de 10 pontos.", 100, 400, makecol(0, 0, 0));
		textout(scores, font, "Voltar ao menu", 150, 100, PRETO);
		show_mouse(scores);
		blit(scores, screen, 0, 0, 0, 0, MAX_X, MAX_Y);

		while (mouse_x >= 150 && mouse_x <= 260 && mouse_y >= 90 && mouse_y <= 110)
		{
			textout(scores, font, "Voltar ao menu", 150, 100, BRANCO);
			blit(scores, screen, 0, 0, 0, 0, MAX_X, MAX_Y);

			if(mouse_b == 1)
			{
				parar_samples();
				principal();
			}
		}
	}
}

void tempo_jogo(BITMAP *fundo)
{
	text_mode(-1);
	textprintf_centre(relogio, font, 50, 0, BRANCO, "     %02d:%02d:%02d     ", segundos/3600, segundos/60, segundos%60);
	draw_sprite(fundo, relogio, 50, 500);
	segundos--;
	clear(relogio);

	if(segundos <= 30)
	{
		textout(fundo, font, "Seu tempo esta acabando!", 3, 450, BRANCO);
	}
}

void muda_fase(void)
/*Muda o tempo de jogo, o fundo e ainda acresecenta uma figura e uma mensagem para cada fase nova.*/
{
	if(fase == 2)
	{
		stop_sample(shaman);
		play_sample(jaguar, 230, 128, 1000, FALSE);
		play_sample(zelda, 255, 128, 1000, TRUE);
		segundos = 240;
		textout(fundo2, font, "Voce eh um exemplo", 30, 300, BRANCO);
		textout(fundo2, font, "de Perseveranca!", 30, 320, BRANCO);
		draw_sprite(fundo2, josef, 10, 350);
		jogo(fundo2);
	}
	if(fase == 3)
	{
		stop_sample(zelda);
		play_sample(jaguar, 230, 128, 1000, FALSE);
		play_sample(mortalkombat, 255, 128, 1000, TRUE);
		segundos = 180;
		textout(fundo3, font, "Round House Kick!!!", 30, 300, BRANCO);
		draw_sprite(fundo3, chucknorris, 50, 320);
		jogo(fundo3);
	}
	if(fase == 4)
	{
		stop_sample(mortalkombat);
		play_sample(jaguar, 230, 128, 1000, FALSE);
		play_sample(starwars, 255, 128, 1000, TRUE);
		segundos = 120;
		textout(fundo4, font, "Que a forca", 30, 300, BRANCO);
		textout(fundo4, font, "esteja com voce!", 30, 320, BRANCO);
		draw_sprite(fundo4, darthvader, 30, 340);
		jogo(fundo4);
	}
	if(fase == 5)
	{
		stop_sample(starwars);
		play_sample(jaguar, 230, 128, 1000, FALSE);
		play_sample(unreal, 230, 128, 1000, TRUE);
		segundos = 60;
		textout(fundo5, font, "***GODLIKE!!!***", 30, 300, BRANCO);
		draw_sprite(fundo5, acre, 30, 320);
		jogo(fundo5);
	}
}

void armazena_arquivo (void)
{
	FILE *recordes;

	recordes = fopen("recordes.txt", "a");
	/*Abre um arquivo para a atualizao, ou seja, escreve sem apagar os dados escritos anteriormente.*/

	if(!recordes) /*Caso o arquivo no possa ser aberto*/
	{
		printf("Erro ao abrir o arquivo de recordes!\n");
		finaliza();
	}

	fprintf(recordes, "%s\n", jogador.nome); /*Imprime o nome do jogador no arquivo.*/
	fprintf(recordes, "%d\n", jogador.score); /*Impime a pontuao do jogador em um arquivo.*/

	fclose(recordes); /*Fecha o arquivo.*/
}


void game_over (void) /*Mostra o game over na tela*/
{
	blit(gameover, buffer, 0, 0, 0, 0, MAX_X, MAX_Y); /*Copia o gameover no buffer*/
	show_mouse(NULL);
	textprintf(buffer, font, 300, 20, BRANCO, "Voce fez %d pontos", jogador.score);
	show_mouse(buffer); /*Mostra o mouse no buffer*/
	copia_buffer(); /*Copia o buffer para a screen*/

	while (mouse_x >= 450 && mouse_x <= 800 && mouse_y >= 470 && mouse_y <= 600)
	/*Volta ao menu, caso o mouse seja clicado em cima do boto "Voltar ao menu"*/
	{
		if(mouse_b == 1)
		{
			parar_samples();
			principal();
		}
	}

	while (mouse_x >= 0 && mouse_x <= 400 && mouse_y >= 470 && mouse_y <= 600)
	/*Inicia um novo jogo, caso o mouse seja clicado em cima do boto "Iniciar novo jogo"*/
	{
		if(mouse_b == 1)
		{
			parar_samples();
			fase = 1;
			segundos = 300;
			clear(pontuacao);
			jogador.score = 0;
			textout(fundo1, font, "Voce ainda eh", 30, 300, BRANCO);
			textout(fundo1, font, "um INICIANTE!", 30, 320, BRANCO);
			play_sample(shaman, 255, 128, 1000, TRUE);
			jogo(fundo1);
			armazena_arquivo();
		}
	}


}

void menu_opcoes (void)
/*Mostra o menu e todas suas opes.*/
{
	if (menu_principal() == 1)
	{
		stop_sample(beethoven);
		play_sample(escolha, 250, 128, 1000, FALSE);
		jogador.score = 0;
		segundos = 300;
		textout(fundo1, font, "Voce ainda eh", 30, 300, BRANCO);
		textout(fundo1, font, "um INICIANTE!", 30, 320, BRANCO);
		play_sample(shaman, 255, 128, 1000, TRUE);
		jogo(fundo1); /*Inicia o jogo*/
		armazena_arquivo();
	}

	if (menu_principal() == 2)
	{
		play_sample(escolha, 250, 128, 1000, FALSE);
		ajuda(); /*Mostra a tela de instrues do jogo*/
	}

	if (menu_principal() == 3)
	{
		play_sample(escolha, 250, 128, 1000, FALSE);
		high_scores(); /*Mostra as pontuaes.*/
	}

	if (menu_principal() == 4)
	{
		play_sample(escolha, 250, 128, 1000, FALSE);
		creditos(); /*Mostra os crditos do jogo*/
	}
}

int testa_combinacoes (void)
/*Essa funo retorna zero se no houverem mais combinaes e retorna um se ainda houverem*/
{
	int teste, i, j;

	for(i=0; i<10; i++)
	{
		for(j=0; j<10; j++)
		{
			if(pecas[i][j] == pecas[i][j+1] && (pecas[i][j] == pecas[i][j+3]
			|| pecas[i][j] == pecas[i-1][j+2] || pecas[i][j] == pecas[i+1][j+2]
			|| pecas[i][j] == pecas[i][j-2] || pecas[i][j] == pecas[i-1][j-1]
			|| pecas[i][j] == pecas[i+1][j-1]))
			/*Condies para existirem combinaes na horizontal*/
			{
				teste = 1;
			}
			else
			{
				if(pecas[i][j] == pecas[i+1][j] && (pecas[i][j] == pecas[i+3][j]
				|| pecas[i][j] == pecas[i+2][j-1] || pecas[i][j] == pecas[i+2][j+1]
				|| pecas[i][j] == pecas[i-2][j] || pecas[i][j] == pecas[i-1][j-1]
				|| pecas[i][j] == pecas[i-1][j+1]))
				/*Condies para existirem combinaes na vertical*/
				{
					teste = 1;
				}
				else
				{
					teste = 0;
				}
			}
		}
	}

	return teste;
}

void jack (void)
{
	clear(buffer);
	blit(jack_bauer, buffer, 0, 0, 0, 0, MAX_X, MAX_Y);

	text_mode(-1);
	textout(buffer, font, "Nome:", 45, 140, BRANCO);
	textprintf(buffer, font, 45, 160, BRANCO, "%s", jogador.nome);
	textout(buffer, font, "PONTOS:", 45, 250, BRANCO);
	textout(buffer, font, "Agora voce tera 24 horas", 50, 400, BRANCO);
	textout(buffer, font, "para jogar Bejeweled!!!", 50, 410, BRANCO);
	textout(buffer, font, "O novo jogo comecara daqui a", 45, 490, BRANCO);

	clear(relogio);
	textprintf_centre(relogio, font, 50, 0, BRANCO, "     %02d:%02d:%02d     ", segundos/3600, segundos/60, segundos%60);
	draw_sprite(buffer, relogio, 50, 500);

	copia_buffer();
}

void parabens (void)
{
	clear(buffer);
	blit(malandro, buffer, 0, 0, 0, 0, MAX_X, MAX_Y);
	copia_buffer();
	rest(2000);
	blit(pegadinha, buffer, 0, 0, 150, 200, pegadinha->w, pegadinha->h);
	copia_buffer();
}

void destruir_macros (void)
/*Essa funo serve para tirar as definies de constantes com a finalidade de liberar memria.*/
{
	#undef MAX_X
	#undef MAX_Y
	#undef V_MAX_X
	#undef V_MAX_Y
	#undef COLOR_BITS
	#undef QUADRADO
	#undef HORZONTAL
	#undef VERTICAL
	#undef DIM
	#undef MSG
	#undef BRANCO
	#undef PRETO
	#undef AMARELO
}

void finaliza (void)
/*Essa funo libera a memria e finaliza o allegro.*/
{
	destruir_bitmaps();
	destruir_samples();
	destruir_macros();

	allegro_message("Voce fez %d pontos", jogador.score);
	allegro_message("Ate a proxima!");

    allegro_exit();
}











