#include <allegro.h>
#include "camera.h"
#include "controls.h"

void CControls::set_keys(int f, int b, int l, int r, int br, int c, int li)
{
  forward=f;
  backward=b;
  left=l;
  right=r;
  brake=br;
  camera=c;
  lift=li;
}

void CControls::work(CCar & car, CCamera & cam, double m)
{
  if(key[lift])
    car.fly();

  car.set_engine(CARENGINE_COAST);
  if(key[forward])
    car.set_engine(CARENGINE_FORWARD);
  if(key[backward])
    car.set_engine(CARENGINE_REVERSE);
  if(key[brake])
    car.set_engine(CARENGINE_BRAKE);
  
  if(!key[right] && !key[left])
    car.set_steer(0);
  if(key[right])
    car.add_steer(0.6*m);
  if(key[left])
    car.add_steer(-0.6*m);
  
  if(key[camera])
    {
      cam.set_mode((cam.get_mode()+1)%3);
      key[camera]=0;
    }
}
