#ifndef _TIMER_H_
#define _TIMER_H_

#include <allegro.h>

inline void tickf(void);

class CTimer
{
 public:
  unsigned long ticks;
  double ticks_per_sec;
  
  void install(double tps) { install_int_ex(tickf, (long int)((double)1193181.0/tps)); ticks_per_sec=tps; ticks=0; }
  double seconds(void) { return (double)ticks/ticks_per_sec; }
  void reset(void) { ticks=0; }
};

extern CTimer timer;

void tickf(void) { timer.ticks++; }

#endif








