#include "camera.h"

void CCamera::init(dBodyID c)
{
	car=c;
	mode=CAMERA_CHASE1;
	update_tpos();
	update_ttar();
	position=tpos;
	target=ttar;
}

void CCamera::update_tpos(void)
{
	const dReal *p = dBodyGetPosition(car);
	const dReal *r = dBodyGetRotation(car);
	
	if(mode==CAMERA_CHASE0)
	{
		tpos.x=p[0]-r[1]*7;
		tpos.y=p[1]-r[5]*7;
		tpos.z=p[2]+3;
	}
	if(mode==CAMERA_CHASE1)
	{
		tpos.x=p[0]-r[1]*15;
		tpos.y=p[1]-r[5]*15;
		tpos.z=p[2]+5;
	}
	if(mode==CAMERA_CHASE2)
	{
		tpos.x=p[0]-r[1]*25;
		tpos.y=p[1]-r[5]*25;
		tpos.z=p[2]+10;
	}
}

void CCamera::update_ttar(void)
{
	const dReal *p = dBodyGetPosition(car);
	if(mode==CAMERA_CHASE0)
	{
		ttar.x=p[0];
		ttar.y=p[1];
		ttar.z=p[2]+0.8;
	}
	if(mode==CAMERA_CHASE1)
	{
		ttar.x=p[0];
		ttar.y=p[1];
		ttar.z=p[2];
	}
	if(mode==CAMERA_CHASE2)
	{
		ttar.x=p[0];
		ttar.y=p[1];
		ttar.z=p[2];
	}
}

void CCamera::update(double t)
{
	update_tpos();
	update_ttar();
	
	if((tpos-position).length() > t*11)
		position=position+((tpos-position).unit()*t*11);
	else
		position=tpos;

	if((ttar-target).length() > t*11)
		target=target+((ttar-target).unit()*t*11);
	else
		target=ttar;
}

void CCamera::set_mode(int m)
{
	mode=m;
	update_tpos();
	update_ttar();
	position=tpos;
	target=ttar;
}
