#include <allegro.h>
#include <alleggl.h>

static int mode = AGL_FULLSCREEN, width, height;

struct resolution_entry {
	int w,h;
	char *s;
} resolutions[] = {
	{  640,  480, " 640x480 "  },
	{  800,  600, " 800x600 "  },
	{ 1024,  768, "1024x768 "  },
	{ 1280, 1024, "1280x1024" },
	{ 1600, 1200, "1600x1200" }
};

static char *resolution_lister (int i, int *size)
{
	if (i < 0) {
		*size = sizeof resolutions / sizeof *resolutions;
		return NULL;
	}
	return resolutions[i].s;
}



struct colour_depth_entry {
	int depth;
	char *s;
} colour_depths[] = {
	{ 15, "15 bpp" },
	{ 16, "16 bpp" },
	{ 24, "24 bpp" },
	{ 32, "32 bpp" }
};

static char *colour_depth_lister (int i, int *size)
{
	if (i < 0) {
		*size = sizeof colour_depths / sizeof *colour_depths;
		return NULL;
	}
	return colour_depths[i].s;
}

struct zbuffer_depth_entry {
	int depth;
	char *s;
} zbuffer_depths[] = {
	{  8, " 8 bpp" },
	{ 16, "16 bpp" },
	{ 24, "24 bpp" },
	{ 32, "32 bpp" }
};

static char *zbuffer_depth_lister (int i, int *size)
{
	if (i < 0) {
		*size = sizeof zbuffer_depths / sizeof *zbuffer_depths;
		return NULL;
	}
	return zbuffer_depths[i].s;
}


static int setup (void)
{
#define RESOLUTION_LIST   4
#define COLOUR_LIST       6
#define ZBUFFER_LIST      8
#define WINDOWED_BOX      9
#define DOUBLEBUFFER_BOX 10
#define BUTTON_OK        11
	
	DIALOG dlg[] = {
    /*	proc                 x    y    w    h  fg bg  key    flags d1 d2  dp */
    {	d_shadow_box_proc,   0,   0, 320, 200,  0, 0,   0,         0, 0, 0, NULL },
    {	d_ctext_proc,      160,  10,   0,   0,  0, 0,   0,         0, 0, 0, (char*)"______________________________" },
    {	d_ctext_proc,      160,   8,   0,   0,  0, 0,   0,         0, 0, 0, (char*)"carterrain OpenGL window setup" },
    {	d_text_proc,        10,  30,   0,   0,  0, 0,   0,         0, 0, 0, (char*)"Resolution" },
    {	d_list_proc,        10,  40,  96,  48,  0, 0,   0,         0, 1, 0, resolution_lister },
    {	d_text_proc,       120,  30,   0,   0,  0, 0,   0,         0, 0, 0, (char*)"Colour depth" },
    {	d_list_proc,       120,  40,  96,  48,  0, 0,   0,         0, 1, 0, colour_depth_lister },
    {	d_text_proc,        10, 104,  96,  48,  0, 0,   0,         0, 0, 0, (char*)"Z-buffer depth" },
    {	d_list_proc,        10, 114,  96,  48,  0, 0,   0,         0, 1, 0, zbuffer_depth_lister },
    {	d_check_proc,       10, 170,  96,   8,  0, 0,   0,         0, 1, 0, (char*)"Windowed" },
    {	d_check_proc,       10, 180, 128,   8,  0, 0,   0,D_SELECTED, 1, 0, (char*)"Double Buffered" },
    {	d_button_proc,     220, 150,  96,  18,  0, 0,   0,    D_EXIT, 0, 0, (char*)"Ok" },
    {	d_button_proc,     220, 174,  96,  18,  0, 0,   0,    D_EXIT, 0, 0, (char*)"Exit" },
    {	NULL }
	};

	int x;

	if (mode == AGL_WINDOWED)
		dlg[WINDOWED_BOX].flags |= D_SELECTED;

	centre_dialog (dlg);
	set_dialog_color (dlg, makecol(0, 212, 0), makecol(0, 0, 0));
		
	x = do_dialog (dlg, 4);
	
	allegro_gl_clear_settings();
	allegro_gl_set (AGL_COLOR_DEPTH, colour_depths[dlg[COLOUR_LIST].d1].depth);
	allegro_gl_set (AGL_Z_DEPTH, zbuffer_depths[dlg[ZBUFFER_LIST].d1].depth);
	allegro_gl_set (AGL_DOUBLEBUFFER, (dlg[DOUBLEBUFFER_BOX].flags & D_SELECTED) ? 1 : 0);
	allegro_gl_set (AGL_RENDERMETHOD, 1);
	mode = ((dlg[WINDOWED_BOX].flags & D_SELECTED) ? AGL_WINDOWED : AGL_FULLSCREEN);
	allegro_gl_set(mode, TRUE);
	allegro_gl_set(AGL_REQUIRE, AGL_RENDERMETHOD);
	allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH | AGL_DOUBLEBUFFER | AGL_RENDERMETHOD | mode);
	width  = resolutions[dlg[RESOLUTION_LIST].d1].w;
	height = resolutions[dlg[RESOLUTION_LIST].d1].h;

	return (x == BUTTON_OK);
}


void splash (void)
{
  int ok;

  allegro_init();
  install_timer();
  

  set_color_depth(8);
  if (set_gfx_mode (GFX_AUTODETECT_WINDOWED, 320, 200, 0, 0) < 0)
    {
      allegro_message ("Error setting plain graphics mode:\n%s\n", allegro_error);
      exit(-1);
    }
  
  install_allegro_gl();
  
  install_keyboard();
  install_mouse();
  ok = setup();
  if(!ok)
    exit(0);
  set_color_depth (32);
  if (set_gfx_mode(GFX_OPENGL, width, height, 0, 0) < 0) {
    allegro_message ("Error setting OpenGL graphics mode:\n%s\n", allegro_error);
    return;
  }
}  
