#include <allegro.h>
#include <alleggl.h>

#include "timer.h"

void intro(void)
{
  
	GLuint odelogotex, bennykramektex, allegrogllogotex;
	BITMAP *bmp = load_tga("data/odelogo.tga", NULL);
	if (bmp==0)
	{
		allegro_message("Can't open \"odelogo.tga\"!\n");
		exit(-1);
	}
	odelogotex = allegro_gl_make_texture(bmp);
	destroy_bitmap(bmp);
	bmp = load_tga("data/bennykramek.tga", NULL);
	if (bmp==0)
	{
		allegro_message("Can't open \"bennykramek.tga\"!\n");
		exit(-1);
	}
	bennykramektex = allegro_gl_make_texture(bmp);
	destroy_bitmap(bmp);
	bmp = load_tga("data/allegrogllogo.tga", NULL);
	if (bmp==0)
	{
		allegro_message("Can't open \"allegrogllogo.tga\"!\n");
		exit(-1);
	}
	allegrogllogotex = allegro_gl_make_texture(bmp);
	destroy_bitmap(bmp);

	allegro_gl_begin();
	glDisable(GL_DEPTH_TEST);
	allegro_gl_end();
	
	while(timer.ticks<15000 && !(key[KEY_SPACE] || key[KEY_ESC]))
	{
		allegro_gl_begin();
		glClear(GL_COLOR_BUFFER_BIT);
		glEnable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		if((timer.ticks%5000)<=1000)
			glColor3f(0, 0, 0);
		else if((timer.ticks%5000)<2000)
			glColor3f(((timer.ticks%5000)-1000)/1000.0, ((timer.ticks%5000)-1000)/1000.0, ((timer.ticks%5000)-1000)/1000.0);
		else if((timer.ticks%5000)<4000)
			glColor3f(1, 1, 1);
		else
			glColor3f((5000-(timer.ticks%5000))/1000.0, (5000-(timer.ticks%5000))/1000.0, (5000-(timer.ticks%5000))/1000.0);
		if(timer.ticks<5000)
		{
			glBindTexture(GL_TEXTURE_2D, bennykramektex);
			glBegin(GL_QUADS);
			glTexCoord2f(1, 1);
			glVertex3f(4, 1, -8);
			glTexCoord2f(0, 1);
			glVertex3f(-4, 1, -8);
			glTexCoord2f(0, 0);
			glVertex3f(-4, -1, -8);
			glTexCoord2f(1, 0);
			glVertex3f(4, -1, -8);
			glEnd();
		}
		else
		{
			if(timer.ticks<10000)
				glBindTexture(GL_TEXTURE_2D, allegrogllogotex);
			else
				glBindTexture(GL_TEXTURE_2D, odelogotex);
			glBegin(GL_QUADS);
			glTexCoord2f(1, 1);
			glVertex3f(2, 1, -5);
			glTexCoord2f(0, 1);
			glVertex3f(-2, 1, -5);
			glTexCoord2f(0, 0);
			glVertex3f(-2, -1, -5);
			glTexCoord2f(1, 0);
			glVertex3f(2, -1, -5);
			glEnd();
		}
		glEnable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
		glFinish();
		allegro_gl_flip();
		allegro_gl_end();
	}

	allegro_gl_begin();
	glDeleteTextures(1, &odelogotex);
	glDeleteTextures(1, &allegrogllogotex);
	glDeleteTextures(1, &bennykramektex);
	glEnable(GL_DEPTH_TEST);
	allegro_gl_end();
}
