#ifndef _CAR_H_
#define _CAR_H_

#include <ode/ode.h>

#define CARENGINE_COAST		0
#define CARENGINE_BRAKE		1
#define CARENGINE_FORWARD	2
#define CARENGINE_REVERSE	3

class CCar
{
private:
	int alive;
	
	double steer;
	
	void adjust_steer(void);
public:
	dWorldID world_citzen;
	dSpaceID space_citzen;

	dBodyID chassis;
	dGeomID chassisbox;
	dBodyID wheel[4];
	dGeomID wheelsphere[4];
	dJointID wheeljoint[4];
	
	CCar() { alive=0; }
	~CCar() { if(alive) destroy(); }
	
	void init(dWorldID w, dSpaceID s, double x, double y, double z);
	void destroy();
	
	void fly(void);
	void set_engine(int mode);
	
	void set_steer(double s);
	void add_steer(double s);
};

#endif
