#include "trig.h"
#include <math.h>

CVector::CVector(void)
{
	x=0;
	y=0;
	z=0;
}

CVector::CVector(double x0, double y0, double z0)
{
	x=x0;
	y=y0;
	z=z0;
}

CVector::~CVector(void)
{
}

CVector CVector::operator+(const CVector & b) const
{
	CVector sum(x+b.x, y+b.y, z+b.z);
	return sum;
}

CVector CVector::operator-(const CVector & b) const
{
	CVector diff(x-b.x, y-b.y, z-b.z);
	return diff;
}

CVector CVector::operator-() const
{
	CVector neg(-x, -y, -z);
	return neg;
}

CVector CVector::operator*(double n) const
{
	CVector mult(x*n, y*n, z*n);
	return mult;
}

CVector operator*(double n, const CVector & a)
{
	return a*n;
}

CVector CVector::operator/(double n) const
{
	CVector div(x/n, y/n, z/n);
	return div;
}

double CVector::length(void) const
{
	return sqrt(x*x + y*y + z*z);
}

double CVector::operator*(const CVector & b) const
{
	return (x*b.x + y*b.y + z*b.z);
}

double CVector::operator^(const CVector & b) const
{
	CVector a(x, y, z);
	return acos((a*b)/(a.length()*b.length()))*180/PI;
}

CVector CVector::operator%(const CVector & b) const
{
	CVector cross(y*b.z - z*b.y, z*b.x - x*b.z, x*b.y - y*b.x);
	return cross;
}

CVector CVector::unit(void) const
{
	CVector a(x/length(), y/length(), z/length());
	return a;
}
