#include <allegro.h>
#include <alleggl.h>
#include <GL/gl.h>
#include "menu.h"

extern FONT *allegro_fnt;
extern int players;

double mousex, mousey;
int focus;

int playersselect(void);

void main_menu(void)
{
  glViewport(0, 0, SCREEN_W, SCREEN_H);
  while(1)
    {
      mousex=(double)mouse_x/SCREEN_W*40-20;
      mousey=(double)(SCREEN_H-mouse_y)/SCREEN_H*30-15;

      if(mousex>=-3 && mousex<=3 && mousey>=-1 && mousey<=1)
	focus=1;
      else if(mousex>=-3 && mousex<=3 && mousey>=-4 && mousey<=-2)
	focus=2;
      else if(mousex>=-3 && mousex<=3 && mousey>=-7 && mousey<=-5)
	focus=3;
      else
	focus=0;

      allegro_gl_begin();

      glMatrixMode(GL_PROJECTION);
      glPushMatrix();
      glLoadIdentity();
      glOrtho(-20,20,-15,15,-1,1);
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
      glDisable(GL_LIGHTING);

      glBegin(GL_QUADS);
      glColor3f(0, focus==1?1:0.7, 0);
      glVertex2f(3, 1);
      glVertex2f(-3, 1);
      glVertex2f(-3, -1);
      glVertex2f(3, -1);
      //      glColor3f(0, focus==2?1:0.7, 0);
      //      glVertex2f(3, -2);
      //      glVertex2f(-3, -2);
      //      glVertex2f(-3, -4);
      //      glVertex2f(3, -4);
      glColor3f(0, focus==3?1:0.7, 0);
      glVertex2f(3, -5);
      glVertex2f(-3, -5);
      glVertex2f(-3, -7);
      glVertex2f(3, -7);
      glEnd();

      glEnable(GL_TEXTURE_2D);
      glEnable(GL_BLEND);
      allegro_gl_printf(allegro_fnt, -2, 10, 0, makecol(0, 255, 0), "carterrain");
      allegro_gl_printf(allegro_fnt, -1.5, 0, 0, makecol(255, 0, 0), "New Game");
      //      allegro_gl_printf(allegro_fnt, -1.5, -3, 0, makecol(255, 0, 0), "Options");
      allegro_gl_printf(allegro_fnt, -1.5, -6, 0, makecol(255, 0, 0), "Quit");
      glDisable(GL_BLEND);
      glDisable(GL_TEXTURE_2D);

      glColor3f(1, 1, 1);
      glTranslatef(mousex, mousey, 0);
      glBegin(GL_TRIANGLES);
      glVertex2f(0, 0);
      glVertex2f(0, -1);
      glVertex2f(0.7, -0.8);
      glEnd();

      glMatrixMode(GL_PROJECTION);
      glPopMatrix();
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      allegro_gl_end();

      allegro_gl_begin();
      glFinish();
      allegro_gl_flip();
      allegro_gl_end();

      if(mouse_b&1 && focus>0)
	{
	  while(mouse_b&1);
	  if(focus==3)
	    {
	allegro_gl_begin();
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glViewport(0, 0, SCREEN_W, SCREEN_H);
	glOrtho(-20,20,-15,15,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);

	glClear(GL_COLOR_BUFFER_BIT);
	allegro_gl_printf(allegro_fnt, -2, 10, 0, makecol(0, 255, 0), "carterrain");
	allegro_gl_printf(allegro_fnt, -8, 7, 0, makecol(0, 0, 255), "Programming & Graphics:  Benny Kramek");
	allegro_gl_printf(allegro_fnt, -6, 5, 0, makecol(255, 255, 0), "http://www.wolfman8k.barrysworld.net");
	allegro_gl_printf(allegro_fnt, -3, -3, 0, makecol(0, 128, 0), "Uses AllegroGL game programming library");
	allegro_gl_printf(allegro_fnt, -3, -5, 0, makecol(0, 128, 0), "Uses ODE real-time physics library");
	allegro_gl_printf(allegro_fnt, -7, -10, 0, makecol(255, 255, 255), "I hope you enjoyed playing!");

	glFinish();
	allegro_gl_flip();
	allegro_gl_end();

	rest(2000);
	while(!key[KEY_ESC]);

	exit(0);
	    }
	  if(focus==1)
	    if(playersselect()==1)
	      break;
	}
    }
}

int playersselect(void)
{
  int i;
  while(1)
    {
      mousex=(double)mouse_x/SCREEN_W*40-20;
      mousey=(double)(SCREEN_H-mouse_y)/SCREEN_H*30-15;

      focus=0;
      for(i=0; i<6; i++)
	if(mousex>=i*3-1-7.5 && mousex<=i*3+1-7.5 && mousey>=-1 && mousey<=1)
	  focus=i+1;
      if(mousex>=-3 && mousex<=3 && mousey>=-7 && mousey<=-5)
	focus=7;

      allegro_gl_begin();

      glMatrixMode(GL_PROJECTION);
      glPushMatrix();
      glLoadIdentity();
      glOrtho(-20,20,-15,15,-1,1);
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
      glDisable(GL_LIGHTING);

      glBegin(GL_QUADS);
      for(i=0; i<6; i++)
	{
	  glColor3f(0, focus==i+1?1:0.7, 0);
	  glVertex2f(i*3+1-7.5, 1);
	  glVertex2f(i*3-1-7.5, 1);
	  glVertex2f(i*3-1-7.5, -1);
	  glVertex2f(i*3+1-7.5, -1);
	}
      glColor3f(0, focus==7?1:0.7, 0);
      glVertex2f(3, -5);
      glVertex2f(-3, -5);
      glVertex2f(-3, -7);
      glVertex2f(3, -7);
      glEnd();

      glEnable(GL_TEXTURE_2D);
      glEnable(GL_BLEND);
      allegro_gl_printf(allegro_fnt, -4, 4, 0, makecol(0, 255, 0), "How many players?");
      for(i=0; i<6; i++)
	allegro_gl_printf(allegro_fnt, i*3-7.5, 0, 0, makecol(255, 0, 0), "%d", i+1);
      allegro_gl_printf(allegro_fnt, -1.5, -6, 0, makecol(255, 0, 0), "Cancel");
      glDisable(GL_BLEND);
      glDisable(GL_TEXTURE_2D);

      glColor3f(1, 1, 1);
      glTranslatef(mousex, mousey, 0);
      glBegin(GL_TRIANGLES);
      glVertex2f(0, 0);
      glVertex2f(0, -1);
      glVertex2f(0.7, -0.8);
      glEnd();

      glMatrixMode(GL_PROJECTION);
      glPopMatrix();
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      allegro_gl_end();

      allegro_gl_begin();
      glFinish();
      allegro_gl_flip();
      allegro_gl_end();

      if(mouse_b&1 && focus>0)
	{
	  while(mouse_b&1);
	  if(focus==7)
	    return 0;
	  else
	    {
	      players=focus;
	      return 1;
	    }
	}
    }  
}
