#include <string.h>
#include <stdio.h>
#include <time.h>
#include "allegro.h"
#include "button.h"
#include "data.h"
#include "map.h"
#include "item.h"
#include "tileset.h"
#include "charset.h"
#include "music.h"

#define SCREEN_Y  	14
#define SCREEN_X	14

#define COLOR_TOP		187
#define COLOR_BOTTOM	38
#define WHITE			187
#define BLUE 			240
#define GREEN			136
#define RED				108
#define YELLOW			75
#define BROWN			129
#define ORANGE			78
#define GREY			14

#define WARRIOR			0
#define	MAGE			1
#define	THIEF			2

#define HUMAN			0
#define	DWARF			1
#define	ELF				2

#define UP      1
#define DOWN	2
#define LEFT	3
#define RIGHT	4

#define IN			0
#define OUT			1
#define WATER		2

#define SAFE		0
#define AREA01		1
#define AREA02		2
#define AREA03		3
#define AREA04		4
#define AREA05		5
#define AREA06		6
#define AREA07		7
#define AREA08		8
#define AREA09		9
#define AREA10		10


#define MAX_BUTTON	32
#define MAX_ITEM	110
#define MAX_P_ITEM	31
#define MAX_P_SPELL	20
#define MAX_MON		50
#define MAX_SKILL	20
#define MAX_SPELL	30
#define MAX_QUEST	40

// spot on body
#define	NULL		0		
#define HEAD		1		
#define	NECK		2
#define HAND1		3
#define	HAND2		4
#define	BODY		5
#define FINGER		6		
#define FEET		7
#define QUIVER		8

//item type
#define HELMET		1
#define NECKLACE	2
#define WEAPON1		3	//one handed
#define WEAPON2		4	//two handed
#define SHIELD		5
#define ARMOR		6
#define RING		7
#define BOOT		8
#define ARROW		9
#define GOLD		10
#define GEM			11
#define SCROLL		12
#define LIGHT		13
#define POTION		14
#define BOAT		15

#define BN			13  // how many base buttons

///////////////////////////////VARIABLES/////////////////////////

typedef struct TIME_STRUCT
{
	int d;
	int h;
	int m;

} TIME_STRUCT;

typedef struct BUTTON_STRUCT
{
	int state;
	int spr;
	int x;
	int y;
	int sx;
	int sy;
	int flag1;
	int flag2;
	char text[20];

} BUTTON_STRUCT;


typedef struct ITEM_STRUCT
{
	int type;
	int spot;
	int spr;
	int flag1;
	int flag2;
	int flag3;
	int flag4;
	int flag5;
	int flag6;
	int cost;
	int value;
	char name[20];

} ITEM_STRUCT;

typedef struct MON_STRUCT
{
	int sprx;
	int spry;
	int d1;
	int d2;
	int d3;
	int defense;
	int magic;
	int life;
	int hitchance;
	int level;
	int area;
	int gold;
	char name[20];

} MON_STRUCT;

typedef struct PLAYER_STRUCT
{
    char    name[20];   
	int		frame;
	int		framex;
	int		framey;
	int		sex;
	int		race;
	int		clas;
	int		x;
	int		y;
	int		dir;
	int		sy;
	int		sx;
	int		ssx;
	int		ssy;
	int		rx;
	int		ry;
	int		rn;
	int		level;
	int		thaco;
	int		gold;
	int		light;
	long	exp;
	int		d1;
	int		d2;
	int		d3;
	int		area;
	int		inout;
	int		strength;
	int		agility;
	int		magic;
	int		mana;
	int		life;
	int		health;
	int		hitchance;
	int		defense;
	int		map_number;
	int		skill[MAX_SKILL];
	int  	spell[MAX_P_SPELL];
	int		quest[MAX_QUEST];
	BITMAP	*sprt[8];
	ITEM_STRUCT		item[MAX_P_ITEM];
	TIME_STRUCT		game_time;
} PLAYER_STRUCT;

typedef struct TOWN
{
	int l;
	ITEM_STRUCT it[10];
} TOWN;

///////////////////////GLOBAL FUNCTIONS////////////////////////////

void	dan_text(BITMAP *bmp,char *str,int x,int y,int p);
void	value_button(BUTTON_STRUCT &butn,int st,int sp,int x,int y,int sx,int sy,int f1,int f2,char *tx);
void	init_buttons();
void	value_mons(int i,int spx,int spy,int d1,int d2,int d3,int de,int ma,int lf,int lv, int gp,char *nm);
void	init_mons();
int		 get_item(PLAYER_STRUCT &pl,ITEM_STRUCT &it);
void	make_window(BITMAP *bmp,int x1,int y1,int x2,int y2);
void	make_box(BITMAP *bmp,int x1,int y1,int x2,int y2);
void	draw_buttons(BITMAP *bmp,int a);
int		check_buttons(int a,int x,int y);
void	draw_graphics(BITMAP *bmp,int e);
int		cell_check(PLAYER_STRUCT &pl,int dx,int dy);
void	move(int dir);
void	open_screen();
int		program();
int		battle(int p);
int		do_fight(PLAYER_STRUCT &player,MON_STRUCT &mon1);
int		hit_back(PLAYER_STRUCT &player,MON_STRUCT &mon1);
void	create_character(PLAYER_STRUCT &player);
void	show_inventory(PLAYER_STRUCT &player);
int 	show_inventory(PLAYER_STRUCT &player,MON_STRUCT &mon);
void	show_items(BITMAP *bmp,int a,int s1,int s2);
void	make_mouse(BITMAP *mse,int p1);
void	show_stats(BITMAP *bmp,PLAYER_STRUCT &player);
void	refresh_stats(PLAYER_STRUCT &pl);
int		load_screen(int mp,int x,int y);
void	load_my_data();
void	clear_my_data();
int		basic_message1(char *text1,char *text2,char *b1);
int		basic_message2(char *text1,char *text2,char *b1,char *b2);
int		check_new_screen();
void	adjust_points();
void	check_level(PLAYER_STRUCT &player);
void	check_skill(PLAYER_STRUCT &player);

int		open_chest(PLAYER_STRUCT &pl);
void	convert_item(ITEM_STRUCT &to,ITEM_STRUCT &from);
int		load_game(int p,PLAYER_STRUCT &pl);
void	save_game(int p,PLAYER_STRUCT &pl);
void	reset_screen(BITMAP *bmp);
void	main_menu();
int		file_menu(BITMAP *bmp,int s);
void	check_file(char *s1,char *s2,char *s3);
int		main();
void	clear_item(ITEM_STRUCT &item);
void	draw_mouse(BITMAP *bmp, int s,int x,int y);
void	load_map(BITMAP *mapbmp,int s);
void	distribute_points(PLAYER_STRUCT &player,int amount);
void	options();
void	cast_spell(PLAYER_STRUCT &player);
int		cast_spell(PLAYER_STRUCT &player,MON_STRUCT &mon);
int		choose_spell(PLAYER_STRUCT &player,int &sp,int ty);
void	spell_name(char *str,int i);
void	v_spell(PLAYER_STRUCT &pl,int sp);
void	v_spell(PLAYER_STRUCT &pl,MON_STRUCT &mon,int sp);
void	memorize_spell(PLAYER_STRUCT &player);

void	m_save(BITMAP *bmp,int x,int y);
void	m_draw(BITMAP *bmp);


//misc.cpp
int		dan_key(int k);
int		Random(int u);
void	check_time(char *lstring,TIME_STRUCT &gt);

//player.cpp
void	init_player(PLAYER_STRUCT &player);
void	uninit_player(PLAYER_STRUCT &player);
void	draw_player(BITMAP *bmp,PLAYER_STRUCT &player);
void	load_player_sprite(PLAYER_STRUCT &player,int p);

//event.cpp
void	inn(PLAYER_STRUCT &player,int s);
void	sell_item(PLAYER_STRUCT &player,int it);
void	buy_item(PLAYER_STRUCT &player,ITEM_STRUCT &it);
void	town_store(PLAYER_STRUCT &player,int type,int town);

void play_song(int s);
void play_sound(int s);
void stop_song();

void basic_text(char *s1,char *s2,char *s3,char *s4,char *s5);
void add_to_log(char *tx);
void draw_log(BITMAP *bmp);

int load_town(char *fname,TOWN &tn);
