#include "arkane.h"
#include "time.h"
#include <fstream.h>

RGB_MAP rgb_table;
COLOR_MAP light_table;
COLOR_MAP trans_table;


BUTTON_STRUCT	btn[MAX_BUTTON];
PLAYER_STRUCT	player;
MON_STRUCT		mon[MAX_MON];

char game_title[30]="The Lost Sword of Arkane!",lstring[30];
DATAFILE *datafile,*button,*map,*itemfile,*tileset,*charset,*music;
BITMAP *mapbmp,*temp,*tspr[8],*mousebmp,*blog;
int mstate=UP,snd=0,speed=20,mmx=0,mmy=0;
int maxh=480,maxw=640,paus=1,test=0;

char aff[4][20]={"Bless","Curse","Blind","Armor"};

int  plog_m=0;

volatile int x = 0;

void inc_time()
{
	char msg[80];
	int t;
	player.game_time.m+=3;
	if(player.item[HAND2].type==LIGHT)
	{
		if (player.item[HAND2].flag1>0)
		{
			player.item[HAND2].flag1-=3;
		}
	}
	if (player.light>0) player.light-=3;
	if (player.game_time.m>=60)
	{
		player.game_time.m=0;
		player.game_time.h++;
		t=player.game_time.h;
		if (t>11) t-=12;
		if (t==0) t=12;
		sprintf(msg,"&W%d o'clock",t);
		add_to_log(msg);
		add_to_log("");

		if (player.game_time.h==24)
		{
			player.game_time.h=0;
			player.game_time.d++;
		}
	}
}

void inc_x(void)
{
   if (paus==1)
	   x++;
   if(x==3)
   {
	   x=0;
	   inc_time();
   }
}

END_OF_FUNCTION(inc_x);

void inn(PLAYER_STRUCT &player,int s)
{
	BITMAP *bmp;
	int p,dn=0,done=0,a,mstate=UP,h=0;
	char msg[80];
	DATAFILE *dfile;
	
	dfile	=	load_datafile("people.dat");

	bmp		=	create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	do
	{	
		a=3;
		value_button(btn[BN],UP,BUTTON_BLANK    ,199,300,60,20,0,0,"Room");
		value_button(btn[BN+1],UP,BUTTON_BLANK    ,289,300,60,20,0,0,"Talk");
		value_button(btn[BN+2],UP,BUTTON_BLANK	 ,379,300,60,20,1,0,"Leave");

		done=0;

			do
			{
				if (mouse_b & 1)
				{	
					if (mstate==UP)
					{
						mstate=DOWN;
					}
				}			
				else			
				{
					if (mstate==DOWN)
					{	
						mstate=UP;
						p=check_buttons(a,mouse_x,mouse_y);			
						if (p>=BN && p<100) done=1;
					}
				}	

				if (dan_key(KEY_ENTER)) 
				{
					while (dan_key(KEY_ENTER)) {}
					p=check_buttons(a,-1,0);
					if (p>=BN && p<100) done=1;
				}
	
				make_window(bmp,169,50,469,330);
				blit((BITMAP*)dfile[3].dat,bmp,0,0,189,70,88,88);
				dan_text(bmp,"Town Inn",290,104,0);
				sprintf(msg,"Room %d gold",s);
				dan_text(bmp,msg,189,180,0);

				draw_buttons(bmp,a);

				m_save(bmp,mouse_x,mouse_y);

				acquire_screen();
				blit(bmp,screen,0,0,0,0,640,480);
				release_screen();

				m_draw(bmp);

			} while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p==BN) 
		{
			if (player.gold>=s)
			{
				player.gold-=s;
				player.life=2*player.health;
				player.mana=2*player.magic;
				basic_message1("You are fully","restored.","Ok");
			}
			else
			{				basic_message1("You don't have enough","gold.","Ok");
			}
		}
		if (p==BN+1)
		{			
		}


		if (p==BN+2) dn=1;
	}	while (!dn);
	
	unload_datafile(dfile);
	destroy_bitmap(bmp);
}


void buy_item(PLAYER_STRUCT &player,ITEM_STRUCT &it)
{
	int i,h=-1;
	
	for (i=11; i<MAX_P_ITEM; i++)
	{
		if (player.item[i].spr==ITEM_000 && h<0) 
			h=i;
	}
	if (h==-1)
	{
		basic_message1("You can't carry",it.name,"Ok");
	}

	if (h>=0)
	{
		if (player.gold>=it.cost)
		{
			player.gold-=it.cost;
			convert_item(player.item[h],it);
		}
		else
		{
			basic_message1("You can't afford",it.name,"Ok");
		}
	}

}

void sell_item(PLAYER_STRUCT &player,int it)
{
	int h;
	h=player.item[it].cost;
	player.gold+=(h/4);
	clear_item(player.item[it]);
}

void store_sell(PLAYER_STRUCT &player)
{
	BITMAP *bmp;
	DATAFILE *ifile;
	int p,dn=0,done=0,a,s,i,mstate=UP,h=0;
	char msg[80];

	ifile			=	load_datafile("item.dat");


	bmp		=	create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	s=11;

	do
	{	
		a=8;
		value_button(btn[BN  ],UP,BUTTON_UP       ,239,100,32,32,0,0,"");
		value_button(btn[BN+1],UP,BUTTON_DOWN     ,239,262,32,32,0,0,"");
		value_button(btn[BN+2],UP,BUTTON_BLANK    ,220,149,50,20,0,0,"Sell");
		value_button(btn[BN+3],UP,BUTTON_BLANK    ,220,169,50,20,0,0,"Sell");
		value_button(btn[BN+4],UP,BUTTON_BLANK    ,220,189,50,20,0,0,"Sell");
		value_button(btn[BN+5],UP,BUTTON_BLANK    ,220,209,50,20,0,0,"Sell");
		value_button(btn[BN+6],UP,BUTTON_BLANK    ,220,229,50,20,0,0,"Sell");
		value_button(btn[BN+7],UP,BUTTON_BLANK	 ,400,306,50,20,1,0,"Done");

		done=0;

			do
			{
				if (mouse_b & 1)
				{	
					if (mstate==UP)
					{
						mstate=DOWN;
					}
				}			
				else			
				{
					if (mstate==DOWN)
					{	
						mstate=UP;
						p=check_buttons(a,mouse_x,mouse_y);			
						if (p>=BN && p<100) done=1;
					}
				}	

				if (dan_key(KEY_ENTER)) 
				{
					while (dan_key(KEY_ENTER)) {}
					p=check_buttons(a,-1,0);
					if (p>=BN && p<100) done=1;
				}
	
				make_window(bmp,169,50,509,330);
				dan_text(bmp,"What do you want",370,100,1);
				dan_text(bmp,"to Sell?",370,120,1);


				draw_buttons(bmp,a);

				for(i=0; i<5; i++)
				{
					sprintf(msg,"%s:%d",player.item[i+s].name,(player.item[i+s].cost/4));
					draw_sprite(bmp,(BITMAP*)ifile[player.item[i+s].spr].dat,290,150+(i*20));
					dan_text(bmp,msg,330,149+(i*20),0);
				}

				m_save(bmp,mouse_x,mouse_y);

				acquire_screen();
				blit(bmp,screen,0,0,0,0,640,480);
				release_screen();

				m_draw(bmp);

			} while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p==BN && s>11) 
		{
			s--;
		}
		if (p==BN+1 && s<MAX_P_ITEM)
		{
			s++;
		}
		if (p==BN+2)
		{
			sell_item(player,s);
		}
		if (p==BN+3)
		{
			sell_item(player,s+1);
		}
		if (p==BN+4)
		{
			sell_item(player,s+2);
		}
		if (p==BN+5)
		{
			sell_item(player,s+3);
		}
		if (p==BN+6)
		{
			sell_item(player,s+4);
		}



		if (p==BN+7) dn=1;
	}	while (!dn);
	
	destroy_bitmap(bmp);
	unload_datafile(ifile);
}


void store_buy(PLAYER_STRUCT &player,int type,int town)
{
	BITMAP *bmp;
	DATAFILE *ifile;
	int p,dn=0,done=0,a,s,i,mstate=UP,h=0;
	char msg[80],fname[20];
	TOWN tn;

		
	for (i=0; i<10; i++)
		clear_item(tn.it[i]);

	ifile			=	load_datafile("item.dat");


	bmp		=	create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	s=0;

	if (type==0)
	{
		sprintf(fname,"town\\town%d_a.ark",town);
	}
	if (type==1)
	{
		sprintf(fname,"town\\town%d_w.ark",town);
	}
	if (type==2)
	{
		sprintf(fname,"town\\town%d_m.ark",town);
	}

	load_town(fname,tn);
	if (tn.l<5) tn.l=5;

	do
	{	
		a=8;
		value_button(btn[BN  ],UP,BUTTON_UP       ,239,100,32,32,0,0,"");
		value_button(btn[BN+1],UP,BUTTON_DOWN     ,239,262,32,32,0,0,"");
		value_button(btn[BN+2],UP,BUTTON_BLANK    ,220,149,50,20,0,0,"Buy");
		value_button(btn[BN+3],UP,BUTTON_BLANK    ,220,169,50,20,0,0,"Buy");
		value_button(btn[BN+4],UP,BUTTON_BLANK    ,220,189,50,20,0,0,"Buy");
		value_button(btn[BN+5],UP,BUTTON_BLANK    ,220,209,50,20,0,0,"Buy");
		value_button(btn[BN+6],UP,BUTTON_BLANK    ,220,229,50,20,0,0,"Buy");
		value_button(btn[BN+7],UP,BUTTON_BLANK	 ,400,306,50,20,1,0,"Done");

		done=0;

		do
		{
			if (mouse_b & 1)
			{	
				if (mstate==UP)
				{
					mstate=DOWN;
				}
			}			
			else			
			{
				if (mstate==DOWN)
				{	
					mstate=UP;
					p=check_buttons(a,mouse_x,mouse_y);			
					if (p>=BN && p<100) done=1;
				}
			}	
				if (dan_key(KEY_ENTER)) 
			{
				while (dan_key(KEY_ENTER)) {}
				p=check_buttons(a,-1,0);
				if (p>=BN && p<100) done=1;
			}

			make_window(bmp,169,50,509,330);
			dan_text(bmp,"What do you want",370,80,1);
			dan_text(bmp,"to Buy?",370,100,1);
			sprintf(msg,"You have %d gold pieces",player.gold);
			dan_text(bmp,msg,370,120,1);

			draw_buttons(bmp,a);
			for(i=0; i<5; i++)
			{
				draw_sprite(bmp,(BITMAP*)ifile[tn.it[i+s].spr].dat,290,150+(i*20));
				sprintf(msg,"%s:%d",tn.it[i+s].name,tn.it[i+s].cost);
				dan_text(bmp,msg,330,149+(i*20),0);				
			}

			m_save(bmp,mouse_x,mouse_y);

			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();

			m_draw(bmp);

			} while (!done);

			acquire_screen();
			m_draw(screen);
			release_screen();
			
			if (p==BN && s>0) 
			{
				s--;
			}
			if (p==BN+1 && s<(tn.l-5))
			{
				s++;
			}
			if (p==BN+2)
			{
				buy_item(player,tn.it[s]);
			}
			if (p==BN+3)
			{
				buy_item(player,tn.it[s+1]);
			}
			if (p==BN+4)
			{
				buy_item(player,tn.it[s+2]);
			}
			if (p==BN+5)
			{
				buy_item(player,tn.it[s+3]);
			}
			if (p==BN+6)
			{
				buy_item(player,tn.it[s+4]);
			}


			if (p==BN+7) dn=1;
		}	while (!dn);

	destroy_bitmap(bmp);
	unload_datafile(ifile);
}

void town_store(PLAYER_STRUCT &player,int type,int town)	
{
	BITMAP *bmp;
	int p,dn=0,done=0,a,mstate=UP,h=0;
//	char msg[80];
	DATAFILE *dfile;
	
	dfile	=	load_datafile("people.dat");

	bmp		=	create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	do
	{	
		a=3;
		value_button(btn[BN  ],UP,BUTTON_BLANK    ,199,300,60,20,0,0,"Buy");
		value_button(btn[BN+1],UP,BUTTON_BLANK    ,289,300,60,20,0,0,"Sell");
		value_button(btn[BN+2],UP,BUTTON_BLANK	 ,379,300,60,20,1,0,"Leave");

		done=0;

			do
			{
				if (mouse_b & 1)
				{	
					if (mstate==UP)
					{
						mstate=DOWN;
					}
				}			
				else			
				{
					if (mstate==DOWN)
					{	
						mstate=UP;
						p=check_buttons(a,mouse_x,mouse_y);			
						if (p>=BN && p<100) done=1;
					}
				}	

				if (dan_key(KEY_ENTER)) 
				{
					while (dan_key(KEY_ENTER)) {}
					p=check_buttons(a,-1,0);
					if (p>=BN && p<100) done=1;
				}
	
				make_window(bmp,169,50,469,330);
				blit((BITMAP*)dfile[type].dat,bmp,0,0,189,70,88,88);
				if (type==0)
				{
					dan_text(bmp,"Armor Shop",290,104,0);
				}
				if (type==1)
				{
					dan_text(bmp,"Weapon Shop",290,104,0);
				}
				if (type==2)
				{
					dan_text(bmp,"Magic Shop",290,104,0);
				}


				draw_buttons(bmp,a);

				m_save(bmp,mouse_x,mouse_y);

				acquire_screen();
				blit(bmp,screen,0,0,0,0,640,480);
				release_screen();

				m_draw(bmp);

			} while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p==BN) 
		{
			store_buy(player,type,town);
		}
		if (p==BN+1)
		{
			store_sell(player);
		}

		if (p==BN+2) dn=1;
	}	while (!dn);
	
	unload_datafile(dfile);
	destroy_bitmap(bmp);
}
void m_save(BITMAP *bmp,int x,int y)
{
	mmx=x;mmy=y;
	blit(bmp,mousebmp,mmx,mmy,0,0,32,16);
	draw_mouse(bmp,MOUSE_BMP_1,mmx,mmy);
}

void m_draw(BITMAP *bmp)
{
	blit(mousebmp,bmp,0,0,mmx,mmy,32,16);
}

void drink_potion(PLAYER_STRUCT &pl,int it)
{
	int h;
	char msg[80];
	if (it==1)
	{
		h=Random(10)+11;
		sprintf(msg,"&W%s,&G+%d life",pl.name,h);
		add_to_log(msg);
		pl.life+=h;

		if (pl.life>2*pl.health)
		{
			pl.life=2*pl.health;
		}
	}
	if (it==2)
	{
		h=Random(10)+11;
		sprintf(msg,"&W%s,&G+%d mana",pl.name,h);
		add_to_log(msg);
		pl.mana+=h;

		if (pl.mana>2*pl.magic)
		{
			pl.mana=2*pl.magic;
		}
	}
}

/////////////////////////////////////////////////////////////////
void value_button(BUTTON_STRUCT &butn,int st,int sp,int x,int y,int sx,int sy,int f1,int f2,char *tx)
{
	butn.state=st;
	butn.spr=sp;
	butn.x=x;
	butn.y=y;
	butn.sx=sx;
	butn.sy=sy;
	butn.flag1=f1;
	butn.flag2=f2;
	strcpy(butn.text,tx);
}

void init_player(PLAYER_STRUCT &player)
{
	int i,j,k,h;
	strcpy(player.name,"");
	player.frame=0;
	player.framex=64;
	player.framey=0;
	player.sex=0;
	player.race=HUMAN;
	player.clas=WARRIOR;
	player.x=192;
	player.y=192;
	player.dir=UP;
	player.sx=40;
	player.sy=82;
	player.ssx=0;
	player.ssy=0;
	player.rx=-1;
	player.ry=-1;
	player.rn=-1;
	player.area=SAFE;
	player.inout=IN;
	player.d1=1;
	player.d2=2;
	player.d3=0;
	player.level=1;
	player.thaco=20;
	player.gold=25;
	player.light=0;
	player.exp=0;
	player.strength=10;
	player.agility=5;
	player.magic=0;
	player.mana=2*player.magic;
	player.health=5;
	player.life=2*player.health;
	player.defense=10;
	player.game_time.d=0;
	player.game_time.h=8;
	player.game_time.m=0;
	player.hitchance=45+(player.level*5);
	player.map_number=2;
	for (k=0; k<MAX_SKILL; k++)
		player.skill[k]=0;
	for (k=0; k<MAX_QUEST; k++)
		player.quest[k]=0;
	for (h=0; h<MAX_SPELL; h++)
		player.spell[h]=0;
	for (i=0; i<MAX_P_ITEM; i++)
		clear_item(player.item[i]);
	for (j=0; j<8; j++)
	{
		tspr[j]	=	create_bitmap(32,32);
	}
	load_player_sprite(player,0);
}

void uninit_player(PLAYER_STRUCT &player)
{
	int j;
	for (j=0; j<8; j++)
		destroy_bitmap(tspr[j]);
}

void draw_player(BITMAP *bmp)
{
	draw_sprite(bmp,tspr[player.frame],player.x,player.y);
}

void load_player_sprite(PLAYER_STRUCT &player,int p)
{
	int j,
		x[8]={0,32,0,32,0,32,0,32},
		y[8]={0,0,32,32,64,64,96,96};
	
	if (p==0)
	{
		for (j=0; j<8; j++)
		{
			blit((BITMAP*)charset[CHARSET_1].dat,tspr[j],x[j]+player.framex,y[j]+player.framey,0,0,32,32);
		}
	}
	if (p==1)
	{
		for (j=0; j<8; j++)
		{
			blit((BITMAP*)charset[CHARSET_1].dat,tspr[j],x[j]+704,y[j]+384,0,0,32,32);
		}
	}
}

void show_stats(BITMAP *bmp,PLAYER_STRUCT &pl)
{
	int p,dn=0,done=0,n=0,a,s=0,l=0,mstate=UP;
	char msg[80];
	
	a=1;

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	refresh_stats(pl);


	value_button(btn[BN],UP,BUTTON_BLANK    ,380,306,50,20,1,0,"Done");


		while (!done)
		{

			if (mouse_b & 1)
			{	
				p=check_buttons(a,mouse_x,mouse_y);
				if (mstate==UP)
				{
					mstate=DOWN;
				}
			}			
			else			
			{
				if (mstate==DOWN)
				{	
					p=check_buttons(a,mouse_x,mouse_y);			
					if (p>=BN && p<100) done=1;
					mstate=UP;
				}
			}

			if (dan_key(KEY_ENTER)) 
			{
				while (dan_key(KEY_ENTER)) {}
				p=check_buttons(a,-1,0);
				if (p>=BN && p<100) done=1;
			}
				
			make_window(bmp,120,90,470,330);
			dan_text(bmp,pl.name,140,110,0);
			sprintf(msg,"Life: %d/%d Mana: %d/%d",pl.life,2*pl.health,pl.mana,2*pl.magic);
			dan_text(bmp,msg,295,130,1);

			sprintf(msg,"Attack: %dd%d+%d Defense: %d",pl.d1,pl.d2,pl.d3,pl.defense);
			dan_text(bmp,msg,295,160,1);
			sprintf(msg,"Experience: %d   Level: %d",pl.exp,pl.level);
			dan_text(bmp,msg,295,180,1);
			
			sprintf(msg,"Strength: %d Agility: %d",pl.strength,pl.agility);
			dan_text(bmp,msg,295,210,1);
			sprintf(msg,"Magic: %d Health: %d",pl.magic,pl.health);
			dan_text(bmp,msg,295,230,1);


			
			draw_buttons(bmp,a);
		
			
			m_save(bmp,mouse_x,mouse_y);


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();
			m_draw(bmp);
		}

		acquire_screen();
		m_draw(screen);
		release_screen();
		
}

void	clear_item(ITEM_STRUCT &it)
{
	it.type	=	NULL;
	it.spot	=	NULL;
	it.spr	=	ITEM_000;
	it.flag1	=	0;
	it.flag2	=	0;
	it.flag3	=	0;
	it.flag4	=	0;
	it.flag5	=	0;
	it.flag6	=	0;
	it.value	=	0;
	it.cost	=	0;
	strcpy(it.name,"----------");
}


void dan_text(BITMAP *bmp,char *str,int x,int y,int p)
{
	if (p==0)
	{
		textout(bmp,(FONT*)button[BUTTON_FONT].dat,str,x+1,y+1,0);
		textout(bmp,(FONT*)button[BUTTON_FONT].dat,str,x,y,COLOR_TOP);
	}
	else
	{
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,str,x+1,y+1,0);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,str,x,y,COLOR_TOP);
	}
}

void init_buttons()
{
	int i;
	for (i=0; i<MAX_BUTTON; i++)
	value_button(btn[i],UP,BUTTON_BLANK,0,0,32,32,0,0,"");


	value_button( btn[0],UP,BUTTON_UP		,544,360,32,32,0,0,"");
	value_button( btn[1],UP,BUTTON_DOWN		,544,440,32,32,0,0,"");
	value_button( btn[2],UP,BUTTON_LEFT		,506,400,32,32,0,0,"");
	value_button( btn[3],UP,BUTTON_RIGHT		,580,400,32,32,0,0,"");	
	value_button( btn[4],UP,BUTTON_SCROLL	,102,432,32,32,0,0,"");
	value_button( btn[5],UP,BUTTON_INVENTORY	,64 ,432,32,32,0,0,"");
	value_button( btn[6],UP,BUTTON_SOUND		,16,216,32,32,0,0,"");
	value_button( btn[7],UP,BUTTON_HELP		,16,254,32,32,0,0,"");
	value_button( btn[8],UP,BUTTON_QUIT		,16,292,32,32,0,0,"");
	value_button( btn[9],UP,BUTTON_LOAD		,16,64,32,32,0,0,"");
	value_button(btn[10],UP,BUTTON_PAUSE		,16,178,32,32,0,0,"");
	value_button(btn[11],UP,BUTTON_OPTION	,16,140,32,32,0,0,"");
	value_button(btn[12],UP,BUTTON_GUY		,488,8,48,48,0,0,"");

}

/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
void value_mons(int i,int spx,int spy,int d1,int d2,int d3,int de,int ma,int lf,int lv,int ar, int gd,char *nm)
{
	mon[i].sprx=98*spx;
	mon[i].spry=104*spy;
	mon[i].d1=d1;
	mon[i].d2=d2;
	mon[i].d3=d3;
	mon[i].defense=de;
	mon[i].magic=ma;
	mon[i].life=lf;
	mon[i].level=lv;
	mon[i].gold=gd;
	mon[i].area=ar;
	mon[i].hitchance=45+(lv*5);
	strcpy(mon[i].name,nm);
}

void value_item(ITEM_STRUCT &it,char *nm,int cs,int f1,int f2,int f3,int f4,int f5,int f6,int spt,int spr,int ty,int vl)
{
	it.cost=cs;
	it.flag1=f1;
	it.flag2=f2;
	it.flag3=f3;
	it.flag4=f4;
	it.flag5=f5;
	it.flag6=f6;
	it.spot=spt;
	it.spr=spr;
	it.type=ty;
	it.value=vl;
	strcpy(it.name,nm);
}

/////////////////////////////////////////////////////////////////

void init_mons()
{
	int i,x=0,y=0;

	for (i=0; i<MAX_MON; i++)
	{
		value_mons(i,x,y,0,0,0,0,0,0,0,0,0,"----------");
		x++;
		if (x>=10) 
		{
			x=0;
			y++;
		}
	}

	//		    i, x, y,d1,d2,d3,de,ma,lf,lv,ar ,gd,nm)

	value_mons( 0, 9, 3, 1, 2, 0,10, 0, 0, 1, 1 ,  1 ,"Small Rat");
	value_mons( 1, 6, 4, 1, 2, 0,10, 0, 0, 1, 1 ,  1 ,"Green Slime");
	value_mons( 2, 8, 3, 1, 3, 0,13, 0, 0, 2, 1 ,  1 ,"Small Rat");
	value_mons( 3, 6, 4, 1, 3, 0,13, 0, 0, 2, 1 ,  1 ,"Green Slime");

	value_mons( 4, 9, 3, 2, 4, 0,16, 0, 0, 3, 1 ,  2 ,"Giant Rat");
	value_mons( 5, 5, 4, 2, 4, 0,16, 0, 0, 3, 1 ,  2 ,"Blue Slime");
	value_mons( 6, 8, 3, 2, 5, 0,20, 0, 0, 4, 1 ,  3 ,"Giant Rat");
	value_mons( 7, 5, 4, 2, 5, 0,20, 0, 0, 4, 1 ,  4 ,"Blue Slime");

	value_mons( 8, 3, 0, 1, 4,10,20, 0, 0, 4, 2 ,  5 ,"Kobold");
	value_mons( 9, 3, 2, 1, 5,14,25, 0, 0, 5, 2 ,  6 ,"Gryffon");
	value_mons(10, 9, 1, 1, 6,18,30, 0, 0, 6, 2 ,  6 ,"Ork");

	value_mons(11, 5, 3, 1, 6,18,35, 0, 0, 7, 2 ,  8 ,"Ork Mage");
	value_mons(12, 2, 1, 1,10,30,100, 0, 0,20, 0 , 200,"Ork King");
	value_mons(13, 3, 2, 1,11,40,40, 0, 0, 8, 2 ,  1 ,"Giant Gryffon");
	value_mons(14, 5, 0, 1,11,50,45, 0, 0, 9, 2 ,  1 ,"Lizard");
	value_mons(15, 5, 0, 1,11,60,50, 0, 0,10, 2 ,  1 ,"Lizard Mage");


	value_mons(15, 0, 2, 1,12,70,55, 0, 0,11, 0 ,  1 ,"Dwarf Berzerker");
	value_mons(16, 8, 2, 1,12,80,60, 0, 0,12, 0 ,  1 ,"Python");
	value_mons(17, 9, 2, 1,12,90,65, 0, 0,13, 0 ,  1 ,"Giant Python");
	value_mons(18, 3, 1, 1,15,100,70, 0, 0,14, 0 ,  1 ,"Priest");
	value_mons(19, 7, 2, 1,15,110,75, 0, 0,15, 0 ,  1 ,"Killer Flower");
	value_mons(20, 4, 4, 1,16,120,80, 0, 0,16, 0 ,  1 ,"Boulder");
	value_mons(21, 0, 2, 1,17,130,85, 0, 0,17, 0 ,  1 ,"Dwarf Priest");
	value_mons(22, 5, 2, 1,18,140,90, 0, 0,18, 0 ,  1 ,"Centaur Knight");
	value_mons(23, 2, 3, 1,20,150,95, 0, 0,19, 0 ,  1 ,"Zombie");

/*	value_mons(24, 2, 1, 1, 0, 0,100, 0, 0,20, 0 ,  1 ,"Cyclops");
	value_mons(25, 2, 3, 1, 0, 0,105, 0, 0,21, 0 ,  1 ,"Giant Zombie");
	value_mons(26, 4, 1, 1, 0, 0,110, 0, 0,22, 0 ,  1 ,"Priest of Agra");
	value_mons(27, 1, 2, 1, 0, 0,115, 0, 0,23, 0 ,  1 ,"Dwarf Wizard");
	value_mons(28, 2, 4, 1, 0, 0,120, 0, 0,24, 0 ,  1 ,"Centaur Warrior");
	value_mons(29, 4, 4, 1, 0, 0,125, 0, 0,25, 0 ,  1 ,"Huge Boulder");
	value_mons(30, 8, 0, 1, 0, 0,130, 0, 0,26, 0 ,  1 ,"Gargoyle");
	value_mons(31, 4, 4, 1, 0, 0,135, 0, 0,30, 0 ,  1 ,"Giant Boulder");
	value_mons(32, 7, 3, 1, 0, 0,140, 0, 0,35, 0 ,  1 ,"Earth Elemental");
	value_mons(33, 0, 1, 1, 0, 0,145, 0, 0,35, 0 ,  1 ,"B'Rhog");
	value_mons(34, 0, 1, 0, 0, 0,150, 0, 0,40, 0 ,  1 ,"B'Rhog Mage");
*/
}

void make_window(BITMAP *bmp,int x1,int y1,int x2,int y2)
{
	blit((BITMAP*)button[BACKGROUND_1].dat,bmp,0,0,x1,y1,x2-x1,y2-y1);
	hline(bmp,x1,y1,x2-1,COLOR_TOP);
	vline(bmp,x1,y1,y2-1,COLOR_TOP);
	hline(bmp,x1,y2-1,x2-1,0);
	vline(bmp,x2-1,y1,y2-1,0);
}

void make_box(BITMAP *bmp,int x1,int y1,int x2,int y2)
{
	blit((BITMAP*)button[BACKGROUND_2].dat,bmp,0,0,x1,y1,x2-x1,y2-y1);
	hline(bmp,x1,y1,x2-1,COLOR_TOP);
	vline(bmp,x1,y1,y2-1,COLOR_TOP);
	hline(bmp,x1,y2-1,x2-1,0);
	vline(bmp,x2-1,y1,y2-1,0);
}

void draw_buttons(BITMAP *bmp,int a)
{
	int p,w=0,l,c1,c2;
	if (a>0) w=BN;

	for (int i=w; i<(BN+a); i++)
	{
		p=BACKGROUND_2;
		c1=COLOR_TOP;
		c2=0;
		if ((mouse_b & 1) && mouse_x>=btn[i].x && mouse_x<=(btn[i].x+btn[i].sx) &&
		    mouse_y>=btn[i].y && mouse_y<=(btn[i].y+btn[i].sy))
		{
			p=BACKGROUND_1;
			c2=COLOR_TOP;
			c1=0;
		}
		
		blit((BITMAP*)button[p].dat,bmp,0,0,btn[i].x,btn[i].y,btn[i].sx,btn[i].sy);
		hline(bmp,btn[i].x,btn[i].y,btn[i].x+btn[i].sx-1,c1);
		vline(bmp,btn[i].x,btn[i].y,btn[i].y+btn[i].sy-1,c1);
		hline(bmp,btn[i].x,btn[i].y+btn[i].sy-1,btn[i].x+btn[i].sx-1,c2);
		vline(bmp,btn[i].x+btn[i].sx-1,btn[i].y,btn[i].y+btn[i].sy-1,c2);

		draw_sprite(bmp,(BITMAP*)button[btn[i].spr].dat,btn[i].x,btn[i].y);
		l=text_height((FONT*)button[BUTTON_FONT].dat);
		text_mode(-1);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,btn[i].text,btn[i].x+(btn[i].sx/2)+1,btn[i].y+(btn[i].sy/2)-(l/2)+1,c2);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,btn[i].text,btn[i].x+(btn[i].sx/2),btn[i].y+(btn[i].sy/2)-(l/2),c1);
	}
}

int check_buttons(int a,int x,int y)
{
	int h=100,p=0;
	if (a>0) p=BN;

	for (int i=p; i<(BN+a); i++)
	{
		if (x>0)
		{
			if (x>=btn[i].x && x<=(btn[i].x+btn[i].sx) &&
				y>=btn[i].y && y<=(btn[i].y+btn[i].sy))
			{
				h=i;
			}
		}
		else
		{
			if (btn[i].flag1==1) h=i;
		}
	}
	return h;
}

///////////////////////////////////////////////////////////////////
void add_to_log(char *tx)
{
	BITMAP *tmp,*chr;
	char m[10];
	int l,s,i,p,co;

	co=0;
	
	chr=create_bitmap(150,8);
	rectfill(chr,0,0,150,8,0);

	p=0,i=0;
	l=strlen(tx);
	do
	{
		s=tx[i];
		if (s==38)
		{
			i++;
			s=tx[i];			
			if (s==66) co=BLUE;
			if (s==71) co=GREEN;
			if (s==82) co=RED;
			if (s==87) co=WHITE;
			if (s==89) co=YELLOW;
			if (s==98) co=BROWN;
			if (s==79) co=ORANGE;
			if (s==103) co=GREY;
		}
		else
		{
			sprintf(m,"%c",s);
			textout(chr,font,m,4+p*8,0,co);
			p++;
		}

		i++;
	} while (i<l);

	tmp=create_bitmap(150,164);
	rectfill(tmp,0,0,150,164,0);

	if (plog_m==20)
	{
		blit(blog,tmp,0,10,0,2,150,152);
		blit(chr,tmp,0,0,0,154,150,8);
//		textout(tmp,font,tx,4,154,co);	
	}
	if (plog_m<20)
	{
		blit(blog,tmp,0,0,0,0,150,164);
		blit(chr,tmp,0,0,0,2+(plog_m*8),150,8);
//		textout(tmp,font,tx,4,2+(plog_m*8),co);
		plog_m++;
	}

	blit(tmp,blog,0,0,0,0,150,164);

	destroy_bitmap(chr);
	destroy_bitmap(tmp);
}

void draw_log(BITMAP *bmp)
{
	blit(blog,bmp,0,0,484,100,150,164);
}


void draw_graphics(BITMAP *bmp,int e)
{
	char msg[80];
	int p,l,w,r,tr[8]={0,1,2,3,0,1,2,3},t,z;

    for (int i=0; i<SCREEN_X; i++)
	for (int j=0; j<SCREEN_Y; j++)
	{
		p=getpixel(mapbmp,player.sx+i+1,player.sy+j+1);
		r=getpixel(mapbmp,player.sx+512+i+1,player.sy+j+1);
		if (p>=0   && p<32)  {l=0;w=p;}
		if (p>=32  && p<64)  {l=1;w=p-32;}
		if (p>=64  && p<96)  {l=2;w=p-64;}
		if (p>=96  && p<128) {l=3;w=p-96;}
		if (p>=128 && p<160) {l=4;w=p-128;}
		if (p>=160 && p<192) {l=5;w=p-160;}
		if (p>=192 && p<224) {l=6;w=p-192;}
		if (p>=224 && p<256) {l=7;w=p-224;}
		if (r<8)
		{
			t=tr[r];
			if (t>3) 
				t=3;
			blit((BITMAP*)tileset[t].dat,temp,l*32,w*32,i*32-player.ssx,j*32-player.ssy,32,32);
		}
		if (r==40)
			blit((BITMAP*)datafile[CHEST_CLOSED].dat,temp,0,0,i*32-player.ssx,j*32-player.ssy,32,32);
		if (r==41)
			blit((BITMAP*)datafile[CHEST_OPEN].dat,temp,0,0,i*32-player.ssx,j*32-player.ssy,32,32);
		
	}


	draw_player(temp);

	z=0;
	if (player.area!=SAFE) 
	{
		if (player.inout==IN)
		{	
			z=1;
		}
		if (player.game_time.h<6 || player.game_time.h>=18) 
		{
			z=1;
		}
	}

	if (z==1)
	{
		if (player.item[4].type==LIGHT)
		{	
			if (player.item[4].flag1>0)
			{
				z=2;
			}
		}
		if (player.light>0)
			z=2;
	}

	if (z==0)
	{
		blit(temp,bmp,0,0,64,0,416,416);      
	}
	if (z>0)
	{
		rectfill(bmp,64,0,479,415,0);
		blit(temp,bmp,80,80,144,80,256, 256);
		if (z==2)
			draw_trans_sprite(bmp,(BITMAP*)datafile[SPOT1].dat, 144,80);
		else
			draw_trans_sprite(bmp,(BITMAP*)datafile[SPOT2].dat, 144,80);
		
	}



	rectfill(bmp,490,326,632,347,8);
	rectfill(bmp,491,327,631,346,0);
	text_mode(0);
	textout(bmp,(FONT*)datafile[FONT_1].dat,lstring,492,327,COLOR_TOP);

	draw_buttons(bmp,0);	
	if (player.game_time.h<6 || player.game_time.h>=18) 
		blit((BITMAP*)datafile[TIME_MOON].dat,bmp,0,0,8,8,48,48);
	else
		blit((BITMAP*)datafile[TIME_SUN].dat,bmp,0,0,8,8,48,48);


	blit((BITMAP*)button[BACKGROUND_1].dat,bmp,550,28,550,28,80,40);
	sprintf(msg,"Life: %d",player.life);
	dan_text(bmp,msg,550,28,0);
	sprintf(msg,"Gold: %d",player.gold);
	dan_text(bmp,msg,550,48,0);

	draw_log(bmp);

	if (e==0)
	{
		m_save(bmp,mouse_x,mouse_y);
	}


	acquire_screen();
	blit(bmp,screen,0,0,0,0,640,480);
	release_screen();



	if (e==0)
		m_draw(bmp);
}

int have_item(PLAYER_STRUCT &pl,int ty,int nu)
{
	int i,h=-1;
	for (i=0; i<MAX_P_ITEM; i++)
	{
		if (pl.item[i].type==ty && pl.item[i].flag1==nu)
			h=i;
	}
	return h;
}


int cell_check(PLAYER_STRUCT &pl,int dx,int dy)
{
	int x,y,h=0,p,l,q;
	char msg[80];
	ITEM_STRUCT it;

	
	x=pl.sx+7+dx;
	y=pl.sy+7+dy;

	if (pl.inout==WATER)
	{
		p=getpixel(mapbmp,x,y);
		if (p==36) return 0;
		if (p==0)
		{
			load_player_sprite(pl,0);
			pl.inout=OUT;
			return 0;
		}
		return 1;
	}
	else
	{
		if (pl.map_number==2 && pl.sx+dx==114 && pl.sy+dy==55)
		{
			h=1;
			if (pl.quest[0]==0)
			{
				pl.quest[0]=1;
				basic_text(	"Hello, there adventurer",
							"I am King Fredo. I have",	
							"a small quest. To the north",
							"of here is a small house.",
							"In it lives Abdra");
				basic_text(	"Abdra has potions of",
							"great healing. Could you",	
							"bring me a potion?",
							"the one I seek is:",
							"Potion of Heartburn-Relief");
				basic_text(	"I would be ever so ",
							"greatful Here is some gold",	
							"to purchase it, and I will",
							"reward you on your return.",
							"Go with good haste");
				pl.gold+=500;
				return 1;
			}
			if (pl.quest[0]==1)
			{
				l=have_item(pl,POTION,3);
				if (l>=0)
				{
					clear_item(pl.item[l]);
					sprintf(msg,"&W%s",pl.name);
					add_to_log(msg);
					sprintf(msg,"&W -&R%s","Heartburn Relief");
					add_to_log(msg);
					basic_text( "Thank you for bringing me",
								"the potion. I thought that",
								"I would be in pain forever!",
								"As Promised",
								"Here is your reward");
					pl.gold+=250;
					value_item(it,"Sword_of_Breah",0,3,8,5,0,0,0,HAND1,ITEM_012,WEAPON1,0);
					sprintf(msg,"&W%s",pl.name);
					add_to_log(msg);
					sprintf(msg,"&W +&G%s",it.name);
					add_to_log(msg);
					sprintf(msg,"&Y +%d Gold",250);
					add_to_log(msg);
					get_item(pl,it);
					pl.quest[0]=3;
				}
				return 1;
			}
		}
		else
		{
			q=getpixel(mapbmp,x,y);
			p=getpixel(mapbmp,x+512,y);
			if (q==36 && p==4)
			{
				if (getpixel(mapbmp,x-dx,y-dy)==0)
				{
					if (have_item(pl,BOAT,1)>=0)
					{
						load_player_sprite(pl,1);
						pl.inout=WATER;
						return 0;
					}
				}
			}

			if (p>3) h=1;
			if (p==40) 
			{	
				pl.sx+=dx;
				pl.sy+=dy;
				if (open_chest(pl)==0)
				{
					putpixel(mapbmp,x+512,y,41);
				}
				pl.sx-=dx;
				pl.sy-=dy;
				return h;
			}
			if (p==41) 
			{
				add_to_log("&WChest");
				add_to_log("   &BEmpty");
			}
		}	
	}
	return h;
}

void move(int dir)
{
	if (dir==UP)
	{	
		player.frame++;
		player.dir=dir;
		if (player.frame>1) player.frame=0;
		player.sy--;
	}
	if (dir==DOWN)
	{
		player.frame++;
		player.dir=dir;
		if (player.frame<4 || player.frame>5) player.frame=4;
		player.sy++;
	}
	if (dir==LEFT)
	{
		player.frame++;
		player.dir=dir;
		if (player.frame<6 || player.frame>7) player.frame=6;
		player.sx--;
	}
	if (dir==RIGHT)
	{
		player.frame++;
		player.dir=dir;
		if (player.frame<2 || player.frame>3) player.frame=2;
		player.sx++;
	}
}

void play_song(int s)
{
	if (snd==0)
		play_midi((MIDI*)music[s].dat, TRUE);
}

void play_sound(int s)
{
	if (snd==0)
	play_sample((SAMPLE*)music[s].dat, 255, 128, 1000,FALSE);
}

void stop_song()
{
	play_midi(NULL,FALSE);
}

void open_screen()
{
	int done=0;
	play_song(MIDI_TITLE);

	acquire_screen();
	blit((BITMAP*)datafile[MAINBACK].dat,screen,0,0,0,0,640,480);
	release_screen();
	fade_in((RGB*)datafile[MY_PAL].dat,1);
	acquire_screen();
	textout(screen,(FONT*)datafile[FONT_1].dat,"Press Enter to Continue!",390,459,COLOR_TOP);
	release_screen();

	
	while (!done)
	{
		if (dan_key(KEY_ENTER))
		{
			while (dan_key(KEY_ENTER)) {}
			done=1;
		}
		if (mouse_b & 1)
		{
			while (mouse_b & 1) {}
			done=1;
		}
			
	}
	acquire_screen();
	blit((BITMAP*)datafile[MAINBACK].dat,screen,0,0,0,0,640,480);
	release_screen();
	set_palette((RGB*)datafile[MY_PAL].dat);
	stop_song();

}


void reset_screen(BITMAP *bmp)
{

	make_window(bmp,0,0,639,479);

	hline(bmp,63,416,480,COLOR_TOP);
	vline(bmp,480,0,416,COLOR_TOP);
	vline(bmp,63,0,416,0);
	text_mode(-1);
	dan_text(bmp,player.name,550,8,0);

	rectfill((BITMAP*)button[BUTTON_GUY].dat,0,0,48,48,0);
	draw_sprite((BITMAP*)button[BUTTON_GUY].dat,tspr[4],8,8);

	text_mode(0);
	strcpy(lstring,"  ");
	draw_graphics(bmp,0);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

}

void paus_game()
{
        paus=0;
        basic_message1("Click 'OK' to","Unpaus Game","Ok");
        paus=1;
}

int program()
{
	int done=0,h=0,c=0,mt=1,pl,p=0,t;
	BITMAP *bmp;
	plog_m=0;
	add_to_log("&WGame Started");
	add_to_log("");

	bmp=create_bitmap(640,480);
				
	reset_screen(bmp);
	play_song(MIDI_TOWN);
								
    while (!done)
	{
		strcpy(lstring,"  ");
		if (mouse_x>7 && mouse_x<57 &&
			mouse_y>7 && mouse_y<57)
				check_time(lstring,player.game_time);

		if (mouse_x<64 || mouse_x>480 || mouse_y>416)
		{
			pl=check_buttons(0,mouse_x,mouse_y);
			if (mouse_b & 1)
			{
				if (pl==0)
				{
					if (cell_check(player,0,-1)==0)
					{
						move(UP);
						p=1;
					}
				}
				if (pl==1)
				{
					if (cell_check(player,0,1)==0)
					{
						move(DOWN);
						p=1;
					}
				}	
				if (pl==2)
				{
					if (cell_check(player,-1,0)==0)
					{
						move(LEFT);
						p=1;
					}
				}
				if (pl==3)
				{
					if (cell_check(player,1,0)==0)
					{
						move(RIGHT);
						p=1;
					}
				}

			}
			else
			{
				if (pl==0)
				{
					strcpy(lstring,"Move Up?");
				}
				if (pl==1)
				{
					strcpy(lstring,"Move Down?");
				}
				if (pl==2)
				{
					strcpy(lstring,"Move Left?");
				}
				if (pl==3)
				{
					strcpy(lstring,"Move Right?");
				}
				if (pl==4)
				{
					strcpy(lstring,"Cast Spell!");
				}
				if (pl==5)
				{
					strcpy(lstring,"Check Inventory?");
				}
				if (pl==6) 
				{
					if (snd==0) strcpy(lstring,"Turn Sound Off?");
					else		strcpy(lstring,"Turn Sound On?");
				}
				if (pl==7) 
				{
					strcpy(lstring,"Need Help?");
				}				
				if (pl==8) 
				{
					strcpy(lstring,"Quit!");
				}
				if (pl==9) 
				{
					strcpy(lstring,"Load Game?");
				}
				if (pl==10) 
				{
					strcpy(lstring,"Pause Game?");
				}
				if (pl==11) 
				{
					strcpy(lstring,"Change Options?");
				}				
				if (pl==12)
				{
					strcpy(lstring,"Stats");
				}
			}
		}
	

		if (mouse_b & 1)
		{	
			mstate=DOWN;
		}			
		else		
		{
			if (mstate==DOWN)
			{

				mstate=UP;
				pl=check_buttons(0,mouse_x,mouse_y);
				if (pl==4)
				{
					acquire_screen();
					m_draw(screen);
					release_screen();
					cast_spell(player);
				}
				if (pl==5)
				{
					acquire_screen();
					m_draw(screen);
					release_screen();
					show_inventory(player);
				}
				if (pl==6) 
				{
					snd++;
					if (snd==1)
					{
						add_to_log("&WSound &ROff");
						stop_song();
					}
					if (snd==2)
					{ 
						add_to_log("&WSound &GOn");
						snd=0;
						if (player.area==SAFE)
						{
							play_song(MIDI_TOWN);
						}
						else
						{
							play_song(MIDI_WORLD);
						}
					}
					add_to_log("");
				}

				if (pl==8) 
				{
					acquire_screen();
					m_draw(screen);
					release_screen();
					if (basic_message2("Are you Sure"," that you want to quit?","Yes","No")==0)
						done=1;
				}
				if (pl==9) 
				{
					acquire_screen();
					m_draw(screen);
					release_screen();
					if (basic_message2("Are you Sure that you","want to Load a saved Game?","Yes","No")==0)
					{
						t=file_menu(bmp,0);
						if (t<3)
						{
							load_game(t,player);
							load_map(mapbmp,player.map_number);
							load_player_sprite(player,0);
						}
				
						reset_screen(bmp);
						if (player.area==SAFE)
						{
							play_song(MIDI_TOWN);
						}
						else
						{
							play_song(MIDI_WORLD);
						}
					}
				}
				if (pl==10) 
				{
					acquire_screen();
					m_draw(screen);
					release_screen();					
                                        paus_game();
				}
				if (pl==11) 
				{
					acquire_screen();
					m_draw(screen);
					release_screen();
					options();
				}
				if (pl==12)
				{
					acquire_screen();
					m_draw(screen);
					release_screen();					
					show_stats(bmp,player);
				}

			}
		}

			if (dan_key(KEY_UP))
			{
				if (cell_check(player,0,-1)==0)
				{
					move(UP);
					p=1;
				}
			}
			else
			if (dan_key(KEY_DOWN))
			{
				if (cell_check(player,0,1)==0)
				{
					move(DOWN);
					p=1;
				}
			}
			else
			if (dan_key(KEY_LEFT))
			{
				if (cell_check(player,-1,0)==0)
				{
					move(LEFT);
					p=1;
				}
			}
			else
			if (dan_key(KEY_RIGHT))
			{
				if (cell_check(player,1,0)==0)
				{
					move(RIGHT);
					p=1;
				}
			}


				
		draw_graphics(bmp,0);

		if (p==1) 
		{	
			rest(2*speed);
			p=check_new_screen();
			if (p==1 && player.area>SAFE)
			{
				if (Random(1000)<=50 && test==0)
				{
					play_song(MIDI_BATTLE);
					done=battle(0);
					if (done>0)
						basic_message1("You were killed","Game Over","Ok");
					else
						play_song(MIDI_WORLD);
				}
			}
			if (p==2)
			{
				play_song(MIDI_BATTLE);
				done=battle(-1);
				if (done>0)
				{
					play_sound(SAMPLE_PDIE);
					basic_message1("You were killed","Game Over","Ok");
				}
				else
					play_song(MIDI_WORLD);				
			}
			p=0;
		}

		if (key[KEY_M]) 
		{
			while (key[KEY_M]) {}
			player.game_time.h++;
		}
	
		if (key[KEY_Q]) 
		{
			test=1;
		}
		if (key[KEY_W]) 
		{
			test=0;
		}
		if (key[KEY_ESC]) done=1;
	}
	destroy_bitmap(bmp);
	stop_song();
	return (0);
}
//////////////////////////////////////////////////////////////////

int choose_spell(PLAYER_STRUCT &player,int &sp,int ty)
{
	BITMAP *bmp;
	int p,dn=0,done=0,a,s,i,mstate=UP,h=0,t;
	char msg[80];

	bmp		=	create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	s=0;

	do
	{	
		a=8;
		value_button(btn[BN  ],UP,BUTTON_UP       ,239,100,32,32,0,0,"");
		value_button(btn[BN+1],UP,BUTTON_DOWN     ,239,262,32,32,0,0,"");
		value_button(btn[BN+2],UP,BUTTON_BLANK    ,230,149,50,20,0,0,"Cast");
		value_button(btn[BN+3],UP,BUTTON_BLANK    ,230,169,50,20,0,0,"Cast");
		value_button(btn[BN+4],UP,BUTTON_BLANK    ,230,189,50,20,0,0,"Cast");
		value_button(btn[BN+5],UP,BUTTON_BLANK    ,230,209,50,20,0,0,"Cast");
		value_button(btn[BN+6],UP,BUTTON_BLANK    ,230,229,50,20,0,0,"Cast");
		value_button(btn[BN+7],UP,BUTTON_BLANK	 ,400,306,50,20,1,0,"Done");

		if (ty==0)		
		{
			a=9;
			value_button(btn[BN+8],UP,BUTTON_BLANK	 ,189,306,180,20,0,0,"Memorize Spell");
		}

		done=0;

			do
			{
				if (mouse_b & 1)
				{	
					if (mstate==UP)
					{
						mstate=DOWN;
					}
				}			
				else			
				{
					if (mstate==DOWN)
					{	
						mstate=UP;
						p=check_buttons(a,mouse_x,mouse_y);			
						if (p>=BN && p<100) done=1;
					}
				}	

				if (dan_key(KEY_ENTER)) 
				{
					while (dan_key(KEY_ENTER)) {}
					p=check_buttons(a,-1,0);
					if (p>=BN && p<100) done=1;
				}
	
				make_window(bmp,169,50,469,330);
				sprintf(msg,"Mana %d",player.mana);
				dan_text(bmp,msg,189,70,0);
				dan_text(bmp,"Memorized Spell/",290,109,0);
				dan_text(bmp,"Cost of Mana",310,129,0);


				draw_buttons(bmp,a);

				for(i=0; i<5; i++)
				{
					t=player.spell[i+s];
					spell_name(msg,player.spell[i+s]);
					dan_text(bmp,msg,290,149+(i*20),0);
				}

				m_save(bmp,mouse_x,mouse_y);

				acquire_screen();
				blit(bmp,screen,0,0,0,0,640,480);
				release_screen();

				m_draw(bmp);

			} while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p==BN && s>0) 
		{
			s--;
		}
		if (p==(BN+1) && s<(MAX_SPELL-5))
		{
			s++;
		}

		if (p==BN+2 && player.spell[s]>0)
		{
			sp=s;
			h=1;
		}
		if (p==(BN+3) && player.spell[s+1]>0)
		{
			sp=s+1;
			h=1;
		}
		if (p==(BN+4) && player.spell[s+2]>0)
		{
			sp=s+2;
			h=1;
		}
		if (p==(BN+5) && player.spell[s+3]>0)
		{
			sp=s+3;
			h=1;
		}
		if (p==(BN+6) && player.spell[s+4]>0)
		{
			sp=s+4;
			h=1;
		}

		if (p==BN+8)
		{
			memorize_spell(player);
		}

		if (p==(BN+7) || h==1) dn=1;
	}	while (!dn);
	
	destroy_bitmap(bmp);
	return (h);
}

void memorize_spell(PLAYER_STRUCT &player)
{
	BITMAP *bmp;
	int j,p,dn=0,done=0,a,s,i,mstate=UP,ms,t[20],k=0,w=0;
	ITEM_STRUCT f[20];

	for (i=0; i<20; i++)
	{
		clear_item(f[i]);
		t[i]=0;
	}

	for (j=0; j<MAX_P_ITEM; j++)
	{
		if (player.item[j].type==SCROLL) 
		{
			convert_item(f[w],player.item[j]);
			t[w]=j;
			w++;
		}
	}

	for (i=0; i<MAX_SPELL; i++)
	{
		if (player.spell[i]==0 && k==0) 
		{
			ms=i;
			k=1;
		}
	}

	if (w<5) w=5;

	bmp		=	create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	s=0;

	do
	{	
		a=8;
		value_button(btn[BN  ],UP,BUTTON_UP       ,239,100,32,32,0,0,"");
		value_button(btn[BN+1],UP,BUTTON_DOWN     ,239,262,32,32,0,0,"");
		value_button(btn[BN+2],UP,BUTTON_BLANK    ,189,149,100,20,0,0,"Memorize");
		value_button(btn[BN+3],UP,BUTTON_BLANK    ,189,169,100,20,0,0,"Memorize");
		value_button(btn[BN+4],UP,BUTTON_BLANK    ,189,189,100,20,0,0,"Memorize");
		value_button(btn[BN+5],UP,BUTTON_BLANK    ,189,209,100,20,0,0,"Memorize");
		value_button(btn[BN+6],UP,BUTTON_BLANK    ,189,229,100,20,0,0,"Memorize");
		value_button(btn[BN+7],UP,BUTTON_BLANK	 ,400,306,50,20,1,0,"Done");

		done=0;

			do
			{
				if (mouse_b & 1)
				{	
					if (mstate==UP)
					{
						mstate=DOWN;
					}
				}			
				else			
				{
					if (mstate==DOWN)
					{	
						mstate=UP;
						p=check_buttons(a,mouse_x,mouse_y);			
						if (p>=BN && p<100) done=1;
					}
				}	

				if (dan_key(KEY_ENTER)) 
				{
					while (dan_key(KEY_ENTER)) {}
					p=check_buttons(a,-1,0);
					if (p>=BN && p<100) done=1;
				}
	
				make_window(bmp,169,50,469,330);
				dan_text(bmp,"Memorize Spell",290,109,0);


				draw_buttons(bmp,a);

				for(i=0; i<5; i++)
				{
					dan_text(bmp,f[i+s].name,309,149+(i*20),0);
				}

				m_save(bmp,mouse_x,mouse_y);

				acquire_screen();
				blit(bmp,screen,0,0,0,0,640,480);
				release_screen();

				m_draw(bmp);

			} while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p==BN && s>0) 
		{
			s--;
		}
		if (p==(BN+1) && s<w)
		{
			s++;
		}

		if (p==BN+2 && f[s].flag1>0)
		{
			clear_item(player.item[t[s]]);
			player.spell[ms]=f[s].flag1;
			dn=1;
		}
		if (p==BN+3 && f[s+1].flag1>0)
		{
			clear_item(player.item[t[s+1]]);
			player.spell[ms]=f[s+1].flag1;
			dn=1;
		}
		if (p==BN+4 && f[s+2].flag1>0)
		{
			clear_item(player.item[t[s+2]]);
			player.spell[ms]=f[s+2].flag1;
			dn=1;
		}
		if (p==BN+5 && f[s+3].flag1>0)
		{
			clear_item(player.item[t[s+3]]);
			player.spell[ms]=f[s+3].flag1;
			dn=1;
		}
		if (p==BN+6 && f[s+4].flag1>0)
		{
			clear_item(player.item[t[s+4]]);
			player.spell[ms]=f[s+4].flag1;
			dn=1;
		}

		if (p==BN+7) dn=1;
	}	while (!dn);
	
	destroy_bitmap(bmp);
}


void spell_name(char *str,int i)
{
	char nm[41][20]={
		"---------",
		"Light",
		"Charm",
		"Curse",
		"Cure Light",
		"Cause Light",
		"Detect Magic",
		"Mana Ray",
		"Recall",
		"Shield",
		"Sleep",
		"Detect Invisibility",
		"Find Traps",
		"Hold Person",
		"Invisibility",
		"Knock",
		"Resist Fire",
		"Slow Poison",
		"Snake Charm",
		"Spiritual Hammer",
		"Stinking Cloud",
		"Cure Blindness",
		"Cause Blindness",
		"Cure Disease",
		"Cause Disease",
		"Dispel Magic",
		"Fire Blast",
		"Haste",
		"Prayer",
		"Remove Curse",
		"Bestow Curse",		

		"Cloudkill",
		"Cold",
		"Cure Critical",
		"Cause Critical",
		"Dispel Evil",
		"Feeblemind",
		"Flame",
		"Hold Monster",
		"Raise Dead",
		"Slay Living"};
	int r=0;

	if (i>0 && i<11) r=3;
	if (i>10) r=8;
	if (i==1) r=4;
	if (i==8) r=12;

	if (r==0)
	{
		strcpy(str,nm[i]);
	}
	else
	{
		sprintf(str,"%s %d",nm[i],r);
	}
}

void v_spell(PLAYER_STRUCT &pl,int sp)
{
	char msg[40];
	int t,mag;
	mag=pl.magic;
	if (player.clas==MAGE)
	{
		if (player.skill[1]==1) mag*=2;
		if (player.skill[2]==1) mag*=3;
		if (player.skill[3]==1) mag*=4;
	}
	switch(sp)
	{
		play_sound(SAMPLE_MAGIC);
	case 1:
		{
			add_to_log("&BCast:&W Light");
			pl.light=120;
			if (player.skill[1]==1) 240;
			if (player.skill[2]==1) 360;
			if (player.skill[3]==1) 480;

			basic_message1("There is a soft","glow surrounding you!","Ok");
		} break;
	case 2:
		{
		} break;
	case 3:
		{
		} break;
	case 4:
		{
			add_to_log("&BCast:&W Cure");
			t=Random(3)+1+(mag/3)+pl.level;			
			sprintf(msg,"  %d points",t);
			add_to_log(msg);
			pl.life+=t;
		} break;
	case 5:
		{
		} break;
	case 6:
		{
		} break;
	case 7:
		{
		} break;
	case 8:
		{
			add_to_log("&BCast:&W Recall");
			load_screen(pl.rn,pl.rx,pl.ry);
			pl.area=SAFE;
			pl.inout=OUT;		
		} break;
	case 9:
		{
		} break;
	case 10:
		{
		} break;
	case 11:
		{
		} break;
	case 12:
		{
		} break;
	case 13:
		{
		} break;
	case 14:
		{
		} break;
	case 15:
		{
		} break;
	case 16:
		{
		} break;
	case 17:
		{
		} break;
	case 18:
		{
		} break;
	case 19:
		{
		} break;
	case 20:
		{
		} break;
	case 21:
		{
		} break;
	case 22:
		{
		} break;
	case 23:
		{
		} break;
	case 24:
		{
		} break;
	case 25:
		{
		} break;
	case 26:
		{
		} break;
	case 27:
		{
		} break;
	case 28:
		{
		} break;
	case 29:
		{
		} break;
	case 30:
		{
		} break;
	case 31:
		{
		} break;
	case 32:
		{
		} break;
	case 33:
		{
		} break;
	case 34:
		{
		} break;
	case 35:
		{
		} break;
	case 36:
		{
		} break;
	case 37:
		{
		} break;
	case 38:
		{
		} break;
	case 39:
		{
		} break;
	case 40:
		{
		} break;

	} // end switch

	if (pl.life>(2*pl.health))
		pl.life=(2*pl.health);
	add_to_log("");
}

void v_spell(PLAYER_STRUCT &pl,MON_STRUCT &mon,int sp)
{
	int t,mag;
	char msg[80];
	mag=pl.magic;
	if (player.clas==MAGE)
	{
		if (player.skill[1]==1) mag*=2;
		if (player.skill[2]==1) mag*=3;
		if (player.skill[3]==1) mag*=4;
	}

	switch(sp)
	{
		play_sound(SAMPLE_MAGIC);
	case 1:
		{
		} break;
	case 2:
		{
		} break;
	case 3:
		{
		} break;
	case 4:
		{
			add_to_log("&BCast:&W Cure");
			t=Random(3)+1+(mag/3)+pl.level;			
			sprintf(msg,"  %d points",t);
			add_to_log(msg);
			pl.life+=t;
		} break;
	case 5:
		{
		} break;
	case 6:
		{
		} break;
	case 7:
		{
			add_to_log("&BCast:&W Mana Ray");
			t=mag/3+Random(3)+1+pl.level;
			sprintf(msg,"  %d points",t);
			add_to_log(msg);
			mon.life-=t;
		} break;
	case 8:
		{		
		} break;
	case 9:
		{
		} break;
	case 10:
		{
		} break;
	case 11:
		{
		} break;
	case 12:
		{
		} break;
	case 13:
		{
		} break;
	case 14:
		{
		} break;
	case 15:
		{
		} break;
	case 16:
		{
		} break;
	case 17:
		{
		} break;
	case 18:
		{
		} break;
	case 19:
		{
		} break;
	case 20:
		{
		} break;
	case 21:
		{
		} break;
	case 22:
		{
		} break;
	case 23:
		{
		} break;
	case 24:
		{
		} break;
	case 25:
		{
		} break;
	case 26:
		{
			add_to_log("&BCast:&W Fire Blast");
			t=mag+Random(8)+1+pl.level;
			sprintf(msg,"  %d points",t);
			add_to_log(msg);
			mon.life-=t;
		} break;
	case 27:
		{
		} break;
	case 28:
		{
		} break;
	case 29:
		{
		} break;
	case 30:
		{
		} break;
	case 31:
		{
		} break;
	case 32:
		{
		} break;
	case 33:
		{
		} break;
	case 34:
		{
		} break;
	case 35:
		{
		} break;
	case 36:
		{
		} break;
	case 37:
		{
		} break;
	case 38:
		{
		} break;
	case 39:
		{
		} break;
	case 40:
		{
		} break;

	} // end switch
}


void cast_spell(PLAYER_STRUCT &player)
{
	int sp,s,c;

	if (choose_spell(player,s,0)==1)
	{	
		sp=player.spell[s];
		if (sp>0 && sp<11) c=3;
		if (sp==1) c=4;
		if (sp==8) c=12;
		if (player.mana>=c)
		{
			player.mana-=c;
			v_spell(player,sp);
		}
		else
		{
			add_to_log("&WMana Not Enough");
		}
	}

}

int cast_spell(PLAYER_STRUCT &player,MON_STRUCT &mon)
{
	int s,h=0,sp,c;

	if (choose_spell(player,s,1)==1)
	{	
		h=1;
		sp=player.spell[s];
		if (sp>=0 && sp<11) c=3;
		if (sp>=11) c=8;
		if (player.mana>=c)
		{
			player.mana-=c;
			v_spell(player,sp);
			v_spell(player,mon,sp);
		}
		else
		{
			add_to_log("&WMana Not Enough");
			h=0;
		}
	}
	return h;
}


void	options()
{
	BITMAP *bmp;
	int p,dn=0,done=0,a;
	char t1[30],t2[30];

	bmp=create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();


	make_window(bmp,219,119,419,359);

	while (!dn)
	{
		sprintf(t1,"Options");
		sprintf(t2,"Game Speed %d",speed);
	
		value_button(btn[BN  ],UP,BUTTON_BLANK,	239,179,15,20,0,0,"-");
		value_button(btn[BN+1],UP,BUTTON_BLANK,	399,179,15,20,0,0,"+");
		value_button(btn[BN+2],UP,BUTTON_BLANK,	329,329,80,20,1,0,"Done");
		a=3;

		done=0;
		while (!done)
		{
			make_window(bmp,219,119,419,359);
			text_mode(-1);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t1,319,139,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t2,319,179,COLOR_TOP);

			if (mouse_b & 1)
			{	
				mstate=DOWN;
				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<(BN+2)) done=1;

			}			
			else			
			{
				if (mstate==DOWN)
				{
					p=check_buttons(a,mouse_x,mouse_y);
					if (p>=BN && p<100) done=1;
				}
				mstate=UP;
			}
	
			draw_buttons(bmp,a);	


			m_save(bmp,mouse_x,mouse_y);


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();

			m_draw(bmp);
		}

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p-BN==0 && speed>0)	
		{
			speed-=2;
		}
		if (p-BN==1 && speed<100)	
		{
			speed+=2;
		}
	
		if (p-BN==2) dn=1;

	}
	destroy_bitmap(bmp);
}

void create_character(PLAYER_STRUCT &player)
{
	BITMAP *spp,*bmp;
	int p,dn=0,done=0,n=0,a,j;
	int k,s,
		ax=0,ay=0,
		fx[8]={0,32,0,32,0,32,0,32},
		fy[8]={0,0,32,32,64,64,96,96};
	char t1[30],t2[30],t3[30],t4[30],t5[30],buf[20];


	bmp=create_bitmap(640,480);
	spp=create_bitmap(32,32);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	make_window(bmp,219,119,419,359);

	while (!dn)
	{
		if (n==0)
		{
//			rectfill(bmp,239,159,399,179,0);
			strcpy(t1,"What is your Name?");
			strcpy(t2,player.name);
			strcpy(t3,"  ");
			strcpy(t4,"  ");
			strcpy(t5,"  ");
			value_button(btn[BN],UP,BUTTON_BLANK,	232,249,80,20,1,0,"Done");
			a=1;
		}
		if (n==1)
		{
			strcpy(t1,"What sex is your");
			strcpy(t2,"character?");
			strcpy(t3,"  ");
			strcpy(t4,"  ");
			strcpy(t5,"  ");
			value_button(btn[BN],UP,BUTTON_BLANK,	232,249,80,20,0,0,"Male");
			value_button(btn[BN+1],UP,BUTTON_BLANK,	325,249,80,20,0,0,"Female");
			a=2;
		}
		if (n==2)
		{
			strcpy(t1,"What is the race");
			strcpy(t2,"of your character?");
			strcpy(t3,"  ");
			strcpy(t4,"  ");
			strcpy(t5,"  ");
			value_button(btn[BN],UP,BUTTON_BLANK,	232,249,80,20,0,0,"Human");
			value_button(btn[BN+1],UP,BUTTON_BLANK,	325,249,80,20,0,0,"Dwarf");
			value_button(btn[BN+2],UP,BUTTON_BLANK,	232,279,80,20,0,0,"Elf");
			a=3;
		}
		if (n==3)
		{
			strcpy(t1,"What is the class");
			strcpy(t2,"of your character?");
			strcpy(t3,"  ");
			strcpy(t4,"  ");
			strcpy(t5,"  ");
			value_button(btn[BN],UP,BUTTON_BLANK,	232,249,80,20,0,0,"Warrior");
			value_button(btn[BN+1],UP,BUTTON_BLANK,	325,249,80,20,0,0,"Mage");
			value_button(btn[BN+2],UP,BUTTON_BLANK,	232,279,80,20,0,0,"Thief");
			a=3;
		}		
		if (n==4)
		{
			distribute_points(player,10);
			n++;
		}
		if (n==5)
		{
			strcpy(t1,"How will your");
			strcpy(t2,"character Look?");
			strcpy(t3,"  ");
			strcpy(t4,"  ");
			strcpy(t5,"  ");
			value_button(btn[BN],UP,BUTTON_LEFT	,	279,289,32,32,0,0,"");
			value_button(btn[BN+1],UP,BUTTON_RIGHT,	327,289,32,32,0,0,"");
			value_button(btn[BN+2],UP,BUTTON_BLANK,	232,329,80,20,1,0,"Done");
			a=3;
		}


		done=0;
		while (!done)
		{
			make_window(bmp,219,119,419,359);
			text_mode(-1);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t1,319,139,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t2,319,159,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t3,319,179,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t4,319,199,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t5,319,219,COLOR_TOP);

			if (mouse_b & 1)
			{	
				mstate=DOWN;
			}			
			else			
			{
				if (mstate==DOWN)
				{
					p=check_buttons(a,mouse_x,mouse_y);
					if (p>=BN && p<100) done=1;
				}
				mstate=UP;
			}
	
			if (n==0)
			{
				if (keypressed())
				{
					k=readkey();
					s=(k & 0xFF);

			        if (s==8 && strlen(player.name)>0 )
					{
						strcpy(buf,"");
						strncat(buf, player.name, strlen(player.name)-1);
						strcpy(player.name,buf);
					}
	
				    if (strlen(player.name)<10) 
					{
						if (s>=65 && s<=90) 
						{
							s+=32;
						}
						if (s>=97 && s<=122)
						{
							sprintf(player.name,"%s%c",player.name,s);
						}
					}
				}

//				rectfill(bmp,239,159,399,179,0);
				dan_text(bmp,player.name,319,159,1);
			}

			if (n==5)
			{
				blit((BITMAP*)charset[CHARSET_1].dat,spp,ax+fx[4],ay+fy[4],0,0,32,32);
				draw_sprite(bmp,spp,302,232);
			}

			
			if (dan_key(KEY_ENTER)) 
			{
				while (dan_key(KEY_ENTER)) {}
				p=check_buttons(a,-1,0);
				if (p>=BN && p<100) done=1;
			}
		
			draw_buttons(bmp,a);	


			m_save(bmp,mouse_x,mouse_y);			


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();
			
			m_draw(bmp);
		}


		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (n==0) 
		{ 
			if (strlen(player.name)<1) 
			{
				n--;
			}
			else
			{
				player.name[0]-=32;
			}
		}
		if (n==1) player.sex=p-BN;
		if (n==2) player.race=p-BN;
		if (n==3) 
		{
			player.clas=p-BN;
			if (player.clas==WARRIOR)
			{
				player.strength	=	10;
				player.agility	=	5;
				player.magic	=	0;
				player.health	=	8;
			}		
			if (player.clas==MAGE)
			{
				player.strength	=	5;
				player.agility	=	5;
				player.magic	=	10;
				player.health	=	3;
			}
			if (player.clas==THIEF)
			{
				player.strength	=	6;
				player.agility	=	10;
				player.magic	=	2;
				player.health	=	5;
			}

			if (player.race==DWARF)
			{
				player.strength++;
				player.agility--;
				player.magic--;
				player.health++;
			}

			if (player.race==ELF)
			{
				player.strength--;
				player.agility++;
				player.magic++;
				player.health--;
			}

			player.life=(2*player.health)+player.level;
			player.mana=(2*player.magic)+player.level;
		}
		if (n==5)
		{
			if (p-BN==0) 
			{
				ax-=64;
				if (ax<0) 
				{
					ax=960;
					ay-=128;
					if (ay<0)	
					{
						ay=384;
						ax=448;
					}
				}
				n--;
			}
			if (p-BN==1) 
			{
				ax+=64;
				if (ax>448 && ay==384)
				{
					ax=0;
					ay=0;
				}			
				if (ax>960) 
				{
					ax=0;
					ay+=128;
					if (ay>384)	ay=0;
				}
				n--;
			}
			if (p-BN==2) 
			{
				for (j=0; j<8; j++)
					blit((BITMAP*)charset[CHARSET_1].dat,tspr[j],ax+fx[j],ay+fy[j],0,0,32,32);
			}
			player.framey=ay;
			player.framex=ax;
		}

		n++;
		if (n==6) dn=1;


	}
	destroy_bitmap(bmp);
	destroy_bitmap(spp);
}


void distribute_points(PLAYER_STRUCT &player,int amount)
{
	BITMAP *bmp,*spp;
	int p,dn=0,done=0,a,
		st,ag,ma,he;
	char t1[30],t2[30],t3[30],t4[30],t5[30];


	bmp=create_bitmap(640,480);
	spp=create_bitmap(32,32);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	make_window(bmp,219,119,419,359);

	st=player.strength;
	ag=player.agility;
	ma=player.mana;
	he=player.health;

	while (!dn)
	{
		sprintf(t1,"Distribute Points: %d",amount);
		sprintf(t2,"Strength %d",player.strength);
		sprintf(t3,"Agility  %d",player.agility);
		sprintf(t4,"Magic    %d",player.magic);
		sprintf(t5,"Health   %d",player.health);
		value_button(btn[BN  ],UP,BUTTON_BLANK,	239,159,15,20,0,0,"-");
		value_button(btn[BN+1],UP,BUTTON_BLANK,	399,159,15,20,0,0,"+");
		value_button(btn[BN+2],UP,BUTTON_BLANK,	239,179,15,20,1,0,"-");
		value_button(btn[BN+3],UP,BUTTON_BLANK,	399,179,15,20,0,0,"+");
		value_button(btn[BN+4],UP,BUTTON_BLANK,	239,199,15,20,0,0,"-");
		value_button(btn[BN+5],UP,BUTTON_BLANK,	399,199,15,20,1,0,"+");
		value_button(btn[BN+6],UP,BUTTON_BLANK,	239,219,15,20,0,0,"-");
		value_button(btn[BN+7],UP,BUTTON_BLANK,	399,219,15,20,0,0,"+");
		value_button(btn[BN+8],UP,BUTTON_BLANK,	329,329,80,20,1,0,"Done");
		a=9;

		done=0;
		while (!done)
		{
			make_window(bmp,219,119,419,359);
			text_mode(-1);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t1,319,139,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t2,319,159,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t3,319,179,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t4,319,199,COLOR_TOP);
			textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,t5,319,219,COLOR_TOP);

			if (mouse_b & 1)
			{	
				mstate=DOWN;
			}			
			else			
			{
				if (mstate==DOWN)
				{
					p=check_buttons(a,mouse_x,mouse_y);
					if (p>=BN && p<100) done=1;
				}
				mstate=UP;
			}
	
			draw_buttons(bmp,a);	


			m_save(bmp,mouse_x,mouse_y);			


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();
			
			m_draw(bmp);
		}

		
		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p-BN==0 && player.strength>st)	
		{
			player.strength--;
			amount++;
		}
		if (p-BN==1 && amount>0)	
		{
			player.strength++;
			amount--;
		}
		if (p-BN==2 && player.agility>ag)
		{
			player.agility--;
			amount++;
		}
		if (p-BN==3 && amount>0)	
		{
			player.agility++;
			amount--;
		}
		if (p-BN==4 && player.magic>ma)
		{
			player.magic--;
			amount++;
		}
		if (p-BN==5 && amount>0)	
		{
			player.magic++;
			amount--;
		}
		if (p-BN==6 && player.health>he)
		{
			player.health--;
			amount++;
		}
		if (p-BN==7 && amount>0)
		{
			player.health++;
			amount--;
		}
	
		if (p-BN==8 && amount==0) dn=1;

	}
	destroy_bitmap(bmp);
	destroy_bitmap(spp);

	player.life=2*player.health;
	player.mana=2*player.magic;
}

void show_credits()
{
	BITMAP *bmp;
	int p,done=0,a;

	bmp=create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	make_window(bmp,219,119,419,359);


	while (!done)
	{

		value_button(btn[BN  ],UP,BUTTON_BLANK,	299,329,40,20,0,0,"Done");
		a=1;
		make_window(bmp,219,119,419,359);
		dan_text(bmp,"Art",319,129,1);
		dan_text(bmp,"From the Web",319,149,1);
		dan_text(bmp,"Programming",319,179,1);
		dan_text(bmp,"Daniel Harmon",319,199,1);
		dan_text(bmp,"Testing",319,229,1);
		dan_text(bmp,"Myself",319,249,1);
		dan_text(bmp,"D&D Advice",319,279,1);
		dan_text(bmp,"Me brother",319,299,1);


		if (mouse_b & 1)
		{	
			mstate=DOWN;
		}			
		else			
		{
			if (mstate==DOWN)
			{
				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<100) done=1;
			}
			mstate=UP;
		}
	

		draw_buttons(bmp,a);	

		m_save(bmp,mouse_x,mouse_y);			


		acquire_screen();
		blit(bmp,screen,0,0,0,0,640,480);
		release_screen();

		m_draw(bmp);

	}

	acquire_screen();
	m_draw(screen);
	release_screen();
		
	destroy_bitmap(bmp);
}

void check_file(char *s1,char *s2,char *s3)
{
	PLAYER_STRUCT pl;
	strcpy(s1,"");
	strcpy(s2,"");
	strcpy(s3,"");

	if (exists("savegme1.svg"))
	{
		ifstream fin("savegme1.svg",ios::binary);
		if (!fin)
		{
			basic_message1("Error opening","Save Game 1","OK");
		}
		fin.read((char*) &pl,sizeof pl);
		fin.close();
		strcpy(s1,pl.name);	
	}
	if (exists("savegme2.svg"))
	{
		ifstream fin("savegme2.svg",ios::binary);
		if (!fin)
		{
			basic_message1("Error opening","Save Game 2","OK");
		}
		fin.read((char*) &pl,sizeof pl);
		fin.close();
		strcpy(s2,pl.name);	
	}
	if (exists("savegme3.svg"))
	{
		ifstream fin("savegme3.svg",ios::binary);
		if (!fin)
		{
			basic_message1("Error opening","Save Game 3","OK");
		}
		fin.read((char*) &pl,sizeof pl);
		fin.close();
		strcpy(s3,pl.name);	
	}


}

void save_game(int p,PLAYER_STRUCT &pl)
{
	char fname[20];
	int proceed=TRUE;

	strcpy(fname,"savegme1.svg");
	if (p==1) 
		strcpy(fname,"savegme2.svg");
	if (p==2) 
		strcpy(fname,"savegme3.svg");

	if (exists(fname))
	{
		if (basic_message2("File Exists","Overwrite?","Yes","No")==1)
			proceed=FALSE;
	}
	

	if (proceed)
	{
		ofstream fout(fname,ios::binary);

		if (!fout)
		{
			basic_message1("Error Opening","File","OK");
		}
		else
		{
			fout.write((char*) &pl,sizeof pl);
			fout.close();
		}
	}

}

int load_game(int p,PLAYER_STRUCT &pl)
{
	char fname[20];

	strcpy(fname,"savegme1.svg");

	if (p==1) 
		strcpy(fname,"savegme2.svg");
	if (p==2) 
		strcpy(fname,"savegme3.svg");
	
	if (exists(fname))
	{
		ifstream fin(fname,ios::binary);

		if (!fin)
		{
			basic_message1("Error opening",fname,"OK");
			return 1;
		}

		fin.read((char*) &pl,sizeof pl);
		fin.close();
	
		refresh_stats(pl);

		return 0;
	}

	basic_message1("File Doesn't","Exist","OK");
	return 1;

}



int file_menu(BITMAP *bmp,int s)
{
	int p,done=0,a,mstate=UP;
	char s1[20],s2[20],s3[20];

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	check_file(s1,s2,s3);


	do
	{

		value_button(btn[BN  ],UP,BUTTON_BLANK,	269,189,100,20,0,0,s1);
		value_button(btn[BN+1],UP,BUTTON_BLANK,	269,219,100,20,0,0,s2);
		value_button(btn[BN+2],UP,BUTTON_BLANK,	269,249,100,20,0,0,s3);
		value_button(btn[BN+3],UP,BUTTON_BLANK,	299,299,60,20,0,0,"Cancel");
		a=4;
		make_window(bmp,219,139,419,339);

		if (s==0) 
			dan_text(bmp,"Which game slot to Load?",319,159,1);
		else
			dan_text(bmp,"Which game slot to Save?",319,159,1);

		if (mouse_b & 1)
		{	
			mstate=DOWN;
		}			
		else			
		{
			if (mstate==DOWN)
			{
				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<100) done=1;
			}
			mstate=UP;
		}
	

		draw_buttons(bmp,a);	

		m_save(bmp,mouse_x,mouse_y);			


		acquire_screen();
		blit(bmp,screen,0,0,0,0,640,480);
		release_screen();

		m_draw(bmp);
	}	while (!done);
	
	acquire_screen();
	m_draw(screen);
	release_screen();
		
	return (p-BN);
}

int load_town(char *fname,TOWN &tn)
{
	ifstream fin(fname,ios::binary | ios::nocreate);

	if (!fin)
	{
		return 1;
	}
	else
	{
		fin.read((char*) &tn,sizeof tn);
		fin.close();
	}
	return 0;
}


int Random(int u)
{
	return(rand() % u);
}

int dan_key(int k)
{
	if (k==KEY_ENTER)
	{
		if (key[KEY_ENTER]) return 1;
		if (key[KEY_ENTER_PAD]) return 1;
	}
	if (k==KEY_UP)
	{
		if (key[KEY_UP]) return 1;
		if (key[KEY_8_PAD]) return 1;
	}
	if (k==KEY_DOWN)
	{
		if (key[KEY_DOWN]) return 1;
		if (key[KEY_2_PAD]) return 1;
	}
	if (k==KEY_LEFT)
	{
		if (key[KEY_LEFT]) return 1;
		if (key[KEY_4_PAD]) return 1;
	}
	if (k==KEY_RIGHT)
	{
		if (key[KEY_RIGHT]) return 1;
		if (key[KEY_6_PAD]) return 1;
	}

	return 0;
}

void check_time(char *lstring,TIME_STRUCT &gt)
{
	char c1[20];
	int d,t;

	d=gt.d;

	t=gt.h;
	if (t>11) t-=12;
	if (t==0) t=12;
	sprintf(c1,"%d o'clock",t);

	sprintf(lstring,"Day %d: %s",d,c1);

}

void main_menu()
{
	BITMAP *bmp;
	int p,done=0,dn=0,a,t,
		fx[8]={0,32,0,32,0,32,0,32},
		fy[8]={0,0,32,32,64,64,96,96};

	bmp=create_bitmap(640,480);
	acquire_screen();
	blit((BITMAP*)datafile[MAINBACK].dat,screen,0,0,0,0,640,480);
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	make_window(bmp,219,119,419,359);


	do
	{
		done=0;

		do
		{

			value_button(btn[BN  ],UP,BUTTON_BLANK,	239,159,160,20,0,0,"Start a New Game");
			value_button(btn[BN+1],UP,BUTTON_BLANK,	239,199,160,20,0,0,"Load a Saved Game");
			value_button(btn[BN+2],UP,BUTTON_BLANK,	239,239,160,20,0,0,"Credits");
			value_button(btn[BN+3],UP,BUTTON_BLANK,	239,279,160,20,0,0,"Quit");
			a=4;
			make_window(bmp,219,119,419,359);

			if (mouse_b & 1)
			{	
				mstate=DOWN;
			}			
			else			
			{
				if (mstate==DOWN)
				{
					p=check_buttons(a,mouse_x,mouse_y);
					if (p>=BN && p<100) done=1;
				}
				mstate=UP;
			}
	

			draw_buttons(bmp,a);	

			m_save(bmp,mouse_x,mouse_y);			


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();

			m_draw(bmp);

		}	while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		

		if ((p-BN)==0)
		{		
			init_player(player);
			create_character(player);
			refresh_stats(player);
			load_screen(2,40,82);
			program();
			blit((BITMAP*)datafile[MAINBACK].dat,bmp,0,0,0,0,640,480);
		}
		if ((p-BN)==1)
		{
			t=file_menu(bmp,0);
			if (t<3)
			{
				if (load_game(t,player)==0)
				{
					load_map(mapbmp,player.map_number);
					load_player_sprite(player,0);
					refresh_stats(player);
					program();
					blit((BITMAP*)datafile[MAINBACK].dat,bmp,0,0,0,0,640,480);
				}
			}
		}
		if ((p-BN)==2)
		{
			show_credits();
		}
		if ((p-BN)==3)
		{
			if (basic_message2("Are you Sure"," that you want to Quit?","Yes","No")==0)
				dn=1;
		}

	} while (!dn);

	destroy_bitmap(bmp);
}

void load_map(BITMAP *mapbmp,int s)
{
	BITMAP *bmp;
	if (s==2)
		bmp=load_pcx("screen2.pcx",(RGB*)datafile[MY_PAL].dat);
	else
		bmp=load_pcx("screen1.pcx",(RGB*)datafile[MY_PAL].dat);
	blit(bmp,mapbmp,0,0,0,0,1024,1024);
	destroy_bitmap(bmp);
}


void draw_mouse(BITMAP *bmp, int s,int x,int y)
{
	draw_sprite(bmp,(BITMAP*)datafile[s].dat,x,y);
}


//////////////////////////////////////////////////////////////////

int inv1(int x,int y,int s,PLAYER_STRUCT &player)
{
	int h=-1,l=5;

	if (x>=299 && x<=299+15 && y>=133 && y<=133+15 && player.item[0].spr!=ITEM_000)
		h=0;
	if (x>=298 && x<=298+15 && y>=172 && y<=172+15 && player.item[1].spr!=ITEM_000)
		h=1;
	if (x>=345 && x<=345+15 && y>=130 && y<=130+15 && player.item[2].spr!=ITEM_000)
		h=2;
	if (x>=266 && x<=266+15 && y>=181 && y<=181+15 && player.item[3].spr!=ITEM_000)
		h=3;
	if (x>=328 && x<=328+15 && y>=179 && y<=179+15 && player.item[4].spr!=ITEM_000)
		h=4;
	if (x>=251 && x<=251+15 && y>=213 && y<=213+15 && player.item[5].spr!=ITEM_000)
		h=5;
	if (x>=348 && x<=348+15 && y>=213 && y<=213+15 && player.item[6].spr!=ITEM_000)
		h=6;
	if (x>=299 && x<=299+15 && y>=242 && y<=242+15 && player.item[7].spr!=ITEM_000)
		h=7;
	if (x>=247 && x<=247+15 && y>=280 && y<=280+15 && player.item[8].spr!=ITEM_000)
		h=8;
	if (x>=269 && x<=269+15 && y>=280 && y<=280+15 && player.item[9].spr!=ITEM_000)
		h=9;
	if (x>=291 && x<=291+15 && y>=280 && y<=280+15 && player.item[10].spr!=ITEM_000)
		h=10;

	if (x>=90 && x<=181)
	{
		if (y>=150 && y<=165) l=0;
		if (y>=170 && y<=185) l=1;
		if (y>=190 && y<=205) l=2;
		if (y>=210 && y<=225) l=3;
		if (y>=230 && y<=245) l=4;
		if (l<5)
		if (player.item[11+s+l].spr!=ITEM_000)
		{
			h=11+s+l;
		}
	}
				
	return h;
}

int inv2(int x,int y,int s,ITEM_STRUCT &mm,PLAYER_STRUCT &player)
{
	int h=-1,l=5;	

	if (x>=299 && x<=299+15 && y>=133 && y<=133+15 && mm.spot==HEAD && player.item[0].spr==ITEM_000)
		h=0;
	if (x>=298 && x<=298+15 && y>=172 && y<=172+15 && mm.spot==BODY && player.item[1].spr==ITEM_000)
		h=1;
	if (x>=345 && x<=345+15 && y>=130 && y<=130+15 && mm.spot==NECK && player.item[2].spr==ITEM_000)
		h=2;
	if (x>=266 && x<=266+15 && y>=181 && y<=181+15)
	{
		if (mm.type==WEAPON1)
		{
			if (mm.spot==HAND1 && 
				player.item[3].spr==ITEM_000)
				h=3;
		}
		if (mm.type==WEAPON2)
		{
			if (mm.spot==HAND1 && 
				player.item[3].spr==ITEM_000 && 
				player.item[4].spr==ITEM_000)
				h=3;
		}
	}
	if (x>=328 && x<=388+15 && y>=179 && y<=179+15 && mm.spot==HAND2 && player.item[4].spr==ITEM_000 && 
		player.item[3].type!=WEAPON2)
			h=4;
	if (x>=251 && x<=251+15 && y>=213 && y<=213+15 && mm.spot==FINGER && player.item[5].spr==ITEM_000)
		h=5;
	if (x>=348 && x<=348+15 && y>=213 && y<=213+15 && mm.spot==FINGER && player.item[6].spr==ITEM_000)
		h=6;
	if (x>=299 && x<=299+15 && y>=242 && y<=242+15 && mm.spot==FEET && player.item[7].spr==ITEM_000)
		h=7;
	if (x>=247 && x<=247+15 && y>=280 && y<=282+15 && mm.spot==QUIVER && player.item[8].spr==ITEM_000)
		h=8;
	if (x>=269 && x<=269+15 && y>=282 && y<=282+15 && mm.spot==QUIVER && player.item[9].spr==ITEM_000)
		h=9;
	if (x>=291 && x<=291+15 && y>=282 && y<=282+15 && mm.spot==QUIVER && player.item[10].spr==ITEM_000)
		h=10;
	if (x>=359 && x<=359+15 && y>=279 && y<=279+15)
		h=40;

	if (x>=90 && x<=181)
	{
		if (y>=150 && y<=165) l=0;
		if (y>=170 && y<=185) l=1;
		if (y>=190 && y<=205) l=2;
		if (y>=210 && y<=225) l=3;
		if (y>=230 && y<=245) l=4;
		if (l<5)
		if (player.item[11+s+l].spr==ITEM_000)
		{
			h=11+s+l;
		}
	}
	return h;
}

void use_item(PLAYER_STRUCT &pl,int it)
{
	it+=11;
	if (pl.item[it].type==POTION)
	{
		drink_potion(player,pl.item[it].flag1);
		clear_item(pl.item[it]);
	}
	if (pl.item[it].type==SCROLL)
	{
		v_spell(player,pl.item[it].flag1);
		clear_item(pl.item[it]);	
	}
}
int use_item(PLAYER_STRUCT &pl,MON_STRUCT &mon,int it)
{
	int h=0;
	it+=11;
	if (pl.item[it].type==POTION)
	{
		drink_potion(player,pl.item[it].flag1);
		clear_item(pl.item[it]);
		h=1;
	}
	if (pl.item[it].type==SCROLL)
	{
		v_spell(player,mon,pl.item[it].flag1);
		clear_item(pl.item[it]);
		h=1;
	}
	return h;
}

void take_off(PLAYER_STRUCT &pl,ITEM_STRUCT &w)
{
	if (w.type==RING)
	{
		if (w.flag1==1)
		{
			pl.strength-=5;
			pl.agility-=5;
			pl.health-=5;
			pl.magic-=5;
		}
	}
	refresh_stats(pl);
}



void put_on(PLAYER_STRUCT &pl,ITEM_STRUCT &w)
{
	if (w.type==RING)
	{
		if (w.flag1==1)
		{
			pl.strength+=5;
			pl.agility+=5;
			pl.health+=5;
			pl.magic+=5;
		}
	}
	refresh_stats(pl);
}

void show_inventory(PLAYER_STRUCT &pl)
{
	BITMAP *bmp,*mse;
	int p,dn=0,done=0,n=0,a,s=0,x,y,l=0,we,wd;
	ITEM_STRUCT mm;
	char msg[80];

	clear_item(mm);

	we=wd=-1;
	a=8;
	bmp=create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();


	mse=create_bitmap(16,16);
	blit((BITMAP*)datafile[MOUSE_BMP_1].dat,mse,0,0,0,0,16,16);


	do
	{	
		done=0;
		do
		{

			value_button(btn[BN  ],UP,BUTTON_UP       ,150,100,32,32,0,0,"");
			value_button(btn[BN+1],UP,BUTTON_DOWN     ,150,262,32,32,0,0,"");
			value_button(btn[BN+2],UP,BUTTON_BLANK    ,380,306,50,20,1,0,"Done");

			value_button(btn[BN+3],UP,BUTTON_BLANK    ,50,150,30,20,0,0,"Use");
			value_button(btn[BN+4],UP,BUTTON_BLANK    ,50,170,30,20,0,0,"Use");
			value_button(btn[BN+5],UP,BUTTON_BLANK    ,50,190,30,20,0,0,"Use");
			value_button(btn[BN+6],UP,BUTTON_BLANK    ,50,210,30,20,0,0,"Use");
			value_button(btn[BN+7],UP,BUTTON_BLANK    ,50,230,30,20,0,0,"Use");

			if (mouse_b & 1)
			{	
/*				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<btn[BN+2)
				{
					done=1;
				}
				if (mstate==UP && p==100 && done==0)
				{
*/
				if (mstate==UP)
				{
					mstate=DOWN;
					x=mouse_x;
					y=mouse_y;
					we=inv1(x,y,s,pl);

					if (we>=0 && mm.spr==ITEM_000)
					{
						convert_item(mm,pl.item[we]);
						if (we>=0 && we<11)
						{
							take_off(pl,pl.item[we]);
						}
						clear_item(pl.item[we]);
					}
				}
//				else
//				{
//					mstate=DOWN;
//				}
			}			
			else			
			{
				if (mstate==DOWN)
				{	
					p=check_buttons(a,mouse_x,mouse_y);			
					mstate=UP;
					if (p>=BN && p<100)
					{
						done=1;
					}
					else
					if (mm.spr!=ITEM_000)
					{
						x=mouse_x;
						y=mouse_y;
						wd=inv2(x,y,s,mm,pl);
						if (wd==40)
						{
							if (basic_message2("Do you want to drop","this item","Ok","Cancel")==0)
							{
								clear_item(mm);
							}
							wd=-1;							
						}

						if (wd>=0)
						{
							convert_item(pl.item[wd],mm);
						if (wd>=0 && wd<11)
						{
							put_on(pl,pl.item[wd]);
						}
						
							clear_item(mm);
						}
						refresh_stats(pl);
					}
				
				}

				if (mm.spr!=ITEM_000)
				{
					convert_item(pl.item[we],mm);
					clear_item(mm);
				}

			}

			if (dan_key(KEY_ENTER)) 
			{
				while (dan_key(KEY_ENTER)) {}
				p=check_buttons(a,-1,0);
				if (p>=BN && p<100) done=1;
			}
				
			make_window(bmp,40,90,530,330);
			draw_buttons(bmp,a);
			draw_sprite(bmp,(BITMAP*)itemfile[INVGUY].dat,240,120);
			show_items(bmp,0,s,0);
			
			sprintf(msg,"Attack: %dd%d+%d",pl.d1,pl.d2,pl.d3);
			dan_text(bmp,msg,390,150,0);
			sprintf(msg,"Defense: %d",pl.defense);
			dan_text(bmp,msg,390,170,0);

			m_save(bmp,mouse_x,mouse_y);
			if (we>=0)
				draw_sprite(bmp,(BITMAP*)itemfile[mm.spr].dat,mouse_x+16,mouse_y);
			


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();

			m_draw(bmp);
		}	while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p==BN && s>0) 
		{
			s--;
		}
		if (p==(BN+1) && s<15)
		{
			s++;
		}
		if (p==BN+3) use_item(pl,s);
		if (p==BN+4) use_item(pl,s+1);
		if (p==BN+5) use_item(pl,s+2);
		if (p==BN+6) use_item(pl,s+3);
		if (p==BN+7) use_item(pl,s+4);

		if (p==BN+2) dn=1;
	}	while (!dn);
	
	destroy_bitmap(bmp);
	destroy_bitmap(mse);

}

int show_inventory(PLAYER_STRUCT &pl,MON_STRUCT &mon)
{
	BITMAP *bmp,*mse;
	int p,dn=0,done=0,n=0,a,s=0,x,y,l=0,we,wd,h=0;
	ITEM_STRUCT mm;
	char msg[80];

	clear_item(mm);

	we=wd=-1;
	a=8;
	bmp=create_bitmap(640,480);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();


	mse=create_bitmap(16,16);
	blit((BITMAP*)datafile[MOUSE_BMP_1].dat,mse,0,0,0,0,16,16);


	do
	{	
		done=0;
		do
		{

			value_button(btn[BN  ],UP,BUTTON_UP       ,150,100,32,32,0,0,"");
			value_button(btn[BN+1],UP,BUTTON_DOWN     ,150,262,32,32,0,0,"");
			value_button(btn[BN+2],UP,BUTTON_BLANK    ,380,306,50,20,1,0,"Done");

			value_button(btn[BN+3],UP,BUTTON_BLANK    ,50,150,30,20,0,0,"Use");
			value_button(btn[BN+4],UP,BUTTON_BLANK    ,50,170,30,20,0,0,"Use");
			value_button(btn[BN+5],UP,BUTTON_BLANK    ,50,190,30,20,0,0,"Use");
			value_button(btn[BN+6],UP,BUTTON_BLANK    ,50,210,30,20,0,0,"Use");
			value_button(btn[BN+7],UP,BUTTON_BLANK    ,50,230,30,20,0,0,"Use");

			if (mouse_b & 1)
			{	
/*				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<btn[BN+2)
				{
					done=1;
				}
				if (mstate==UP && p==100 && done==0)
				{
*/
				if (mstate==UP)
				{
					mstate=DOWN;
					x=mouse_x;
					y=mouse_y;
					we=inv1(x,y,s,pl);

					if (we>=0 && mm.spr==ITEM_000)
					{
						convert_item(mm,pl.item[we]);
						if (we>=0 && we<11)
						{
							take_off(pl,pl.item[we]);
						}
						clear_item(pl.item[we]);
					}
				}
//				else
//				{
//					mstate=DOWN;
//				}
			}			
			else			
			{
				if (mstate==DOWN)
				{	
					p=check_buttons(a,mouse_x,mouse_y);			
					mstate=UP;
					if (p>=BN && p<100)
					{
						done=1;
					}
					else
					if (mm.spr!=ITEM_000)
					{
						x=mouse_x;
						y=mouse_y;
						wd=inv2(x,y,s,mm,pl);
						if (wd==40)
						{
							if (basic_message2("Do you want to drop","this item","Ok","Cancel")==0)
							{
								clear_item(mm);
							}
							wd=-1;							
						}

						if (wd>=0)
						{
							convert_item(pl.item[wd],mm);
						if (wd>=0 && wd<11)
						{
							put_on(pl,pl.item[wd]);
						}
						
							clear_item(mm);
						}
						refresh_stats(pl);
					}
				
				}

				if (mm.spr!=ITEM_000)
				{
					convert_item(pl.item[we],mm);
					clear_item(mm);
				}

			}

			if (dan_key(KEY_ENTER)) 
			{
				while (dan_key(KEY_ENTER)) {}
				p=check_buttons(a,-1,0);
				if (p>=BN && p<100) done=1;
			}
				
			make_window(bmp,40,90,530,330);
			draw_buttons(bmp,a);
			draw_sprite(bmp,(BITMAP*)itemfile[INVGUY].dat,240,120);
			show_items(bmp,0,s,0);
			
			sprintf(msg,"Attack: %dd%d+%d",pl.d1,pl.d2,pl.d3);
			dan_text(bmp,msg,390,150,0);
			sprintf(msg,"Defense: %d",pl.defense);
			dan_text(bmp,msg,390,170,0);

			m_save(bmp,mouse_x,mouse_y);
			if (we>=0)
				draw_sprite(bmp,(BITMAP*)itemfile[mm.spr].dat,mouse_x+16,mouse_y);
			


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();

			m_draw(bmp);
		}	while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (p==BN && s>0) 
		{
			s--;
		}
		if (p==(BN+1) && s<15)
		{
			s++;
		}
		if (p==BN+3) h=use_item(pl,mon,s);
		if (p==BN+4) h=use_item(pl,mon,s+1);
		if (p==BN+5) h=use_item(pl,mon,s+2);
		if (p==BN+6) h=use_item(pl,mon,s+3);
		if (p==BN+7) h=use_item(pl,mon,s+4);

		if (p==(BN+2)) dn=1;
	}	while (!dn);
	
	destroy_bitmap(bmp);
	destroy_bitmap(mse);
	return h;
}


void refresh_stats(PLAYER_STRUCT &pl)
{
	int i;
	pl.d1=1;  // normal hand
	pl.d2=2;
	pl.d3=0;
	
	for (i=0; i<11; i++)
	{
		if (pl.item[i].type==WEAPON1 ||
			pl.item[i].type==WEAPON2) // check to see if have weapon
		{
			pl.d1=pl.item[i].flag1;
			pl.d2=pl.item[i].flag2;
			pl.d3=pl.item[i].flag3;
		}
	}

	pl.d3+=(pl.strength/4);
	pl.defense=pl.agility*2;

	for (i=0; i<11; i++)
	{
		if (pl.item[i].type==HELMET ||
			pl.item[i].type==SHIELD ||
			pl.item[i].type==ARMOR ||
			pl.item[i].type==BOOT)
			pl.defense=pl.defense+pl.item[i].flag1;
	}

	pl.hitchance=45+(pl.level*5)+pl.agility;

}

void show_items(BITMAP *bmp,int a,int s1,int s2)
{
	// this where i will blit item and name of items
	int i;

	for(i=0; i<5; i++)
	{
		draw_sprite(bmp,(BITMAP*)itemfile[player.item[11+i+s1].spr].dat,90,150+(i*20));
		textout(bmp,(FONT*)button[BUTTON_FONT].dat,player.item[11+i+s1].name,115,149+(i*20),0);
		textout(bmp,(FONT*)button[BUTTON_FONT].dat,player.item[11+i+s1].name,114,148+(i*20),COLOR_TOP);
	}

	draw_sprite(bmp,(BITMAP*)itemfile[player.item[0].spr].dat,299,133);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[1].spr].dat,298,172);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[2].spr].dat,345,130);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[3].spr].dat,266,181);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[4].spr].dat,328,179);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[5].spr].dat,251,213);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[6].spr].dat,348,213);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[7].spr].dat,299,242);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[8].spr].dat,247,280);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[9].spr].dat,269,280);
	draw_sprite(bmp,(BITMAP*)itemfile[player.item[10].spr].dat,291,280);
}


int	open_chest(PLAYER_STRUCT &pl)
{
	int h,t;
	char msg[80]; 
	ITEM_STRUCT it;

	if (pl.map_number==2 && pl.sx==129 && pl.sy==236)
	{
		value_item(it,"Ring_of_Breah",0,1,0,0,0,0,0,FINGER,ITEM_009,RING,0);
		sprintf(msg,"   &Ga<n> %s",it.name);
		if (get_item(pl,it)==1)
		{
			add_to_log("&WChest");
			add_to_log(msg);
			return 0;
		}
		else
		{
			add_to_log("&WChest");
			add_to_log("&R   Can't Carry Item");
			return 1;
		}
	}
	if (pl.map_number==2 && pl.sx==69 && pl.sy==167)
	{
		value_item(it,"Small_Dagger",0,1,4,3,0,0,0,HAND1,ITEM_012,WEAPON1,0);
		sprintf(msg,"   &Ga<n> %s",it.name);
		if (get_item(pl,it)==1)
		{
			add_to_log("&WChest");
			add_to_log(msg);
			return 0;
		}
		else
		{
			add_to_log("&WChest");
			add_to_log("&R   Can't Carry Item");
			return 1;
		}
	}

	h=Random(100)+1;
	if (h<10)
	{
		value_item(it,"Potion_of_Mana",0,2,0,0,0,0,0,0,ITEM_005,POTION,0);
		sprintf(msg,"   &Ga<n> %s",it.name);
		if (get_item(pl,it)==1)
		{
			add_to_log("&WChest");
			add_to_log(msg);
			return 0;
		}
		else
		{
			add_to_log("&WChest");
			add_to_log("&R   Can't Carry Item");
			return 1;
		}
	}
	if (h<20)
	{
		value_item(it,"Potion_of_Cure",0,1,0,0,0,0,0,0,ITEM_005,POTION,0);
		sprintf(msg,"   &Ga<n> %s",it.name);
		if (get_item(pl,it)==1)
		{
			add_to_log("&WChest");
			add_to_log(msg);
			return 0;
		}
		else
		{
			add_to_log("&WChest");
			add_to_log("&R   Can't Carry Item");
			return 1;
		}
	}
	if (h<40)
	{
		value_item(it,"Torch",0,120,0,0,0,0,0,HAND2,ITEM_017,LIGHT,0);
		sprintf(msg,"   &Ga<n> %s",it.name);
		if (get_item(pl,it)==1)
		{
			add_to_log("&WChest");
			add_to_log(msg);
			return 0;
		}
		else
		{
			add_to_log("&WChest");
			add_to_log("&R   Can't Carry Item");
			return 1;
		}
	}

	t=Random(5)+5;
	sprintf(msg,"&G%d Gold",t);
	add_to_log("&YChest");
	add_to_log(msg);
	pl.gold+=t;


	return 0;
}

int	get_item(PLAYER_STRUCT &pl,ITEM_STRUCT &it)
{
	int i,h=0;
	for (i=11; i<MAX_P_ITEM; i++)
	{
		if (h==0)
		{
			if (pl.item[i].spr==ITEM_000)
			{
				h=1;
				convert_item(pl.item[i],it);
			}
		}
	}
	return h;
}


int load_screen(int mp,int x,int y)
{

	load_map(mapbmp,mp);

	player.map_number=mp;
	player.sx=x;
	player.sy=y;

	return(0);
}

int check_new_screen()
{
	int x,y,n,d,t;
	x=player.sx;
	y=player.sy;
	d=player.dir;
	n=player.map_number;

	////////////////////////////////////////////////////////////////////

	if (n==1)
	{
		if (x==210 && y==189 && d==DOWN)
		{
			if (basic_message2("Do you want to Save","your game?","Yes","No")==0)
			{
				BITMAP *bmp;
				bmp=create_bitmap(640,480);
				blit(screen,bmp,0,0,0,0,640,480);
				t=file_menu(bmp,1);
				if (t<3)
				{
					save_game(t,player);
				}
				destroy_bitmap(bmp);
			}
		}
		if (x==199 && y==83 && d==RIGHT)
		{
			if (basic_message2("Do you want to Save","your game?","Yes","No")==0)
			{
				BITMAP *bmp;
				bmp=create_bitmap(640,480);
				blit(screen,bmp,0,0,0,0,640,480);
				t=file_menu(bmp,1);
				if (t<3)
				{
					save_game(t,player);
				}
				destroy_bitmap(bmp);
			}
		}
		if (x==127 && y==126 && d==UP)	// entering castle courtyard
		{
			add_to_log("&WBreah Courtyard");
			add_to_log("");
			load_screen(2,40,82);
			player.area=SAFE;
			player.inout=OUT;
			return 0;
		}	
		if (x==174 && y==150 && d==DOWN) // entering cave1 e1
		{
			load_screen(2,13,92);
			player.area=AREA02;
			player.inout=IN;
			return 0;
		}
		if (x==183 && y==155 && d==DOWN) // entering cave1 e2
		{
			load_screen(2,86,92);
			player.area=AREA02;
			player.inout=IN;
			return 0;
		}
		if (x==151 && y==87 && d==LEFT) // leaving area1 map1
		{
			player.area=AREA02;
			player.inout=OUT;
			return 0;
		}
		if (x==153 && y==87 && d==RIGHT) // leaving area1 map1
		{
			player.area=AREA01;
			player.inout=OUT;
			return 0;
		}
		if (x==186 && y==98 && d==RIGHT) // leaving area1 map1
		{
			player.area=AREA02;
			player.inout=OUT;
			return 0;
		}
		if (x==184 && y==98 && d==LEFT) // leaving area1 map1
		{
			player.area=AREA01;
			player.inout=OUT;
			return 0;
		}


		if (x==194 && y==179 && d==DOWN) // entering Carosa
		{
			add_to_log("&WTown of Carosa");
			add_to_log("");
			play_song(MIDI_TOWN);
			player.area=SAFE;
			player.inout=OUT;
			return 0;
		}
		if (x==213 && y==186 && d==LEFT) // entering Carosa
		{	
			add_to_log("&WTown of Carosa");
			add_to_log("");			
			play_song(MIDI_TOWN);
			player.area=SAFE;
			player.inout=OUT;
			return 0;
		}
		if (x==194 && y==177 && d==UP) // exiting Carosa
		{
			play_song(MIDI_WORLD);
			player.area=AREA03;
			player.inout=OUT;
			return 0;
		}
		if (x==215 && y==186 && d==RIGHT) // exiting Carosa
		{			
			play_song(MIDI_WORLD);
			player.area=AREA03;
			player.inout=OUT;
			return 0;
		}
		if (x==201 && y==180 && d==UP) 
		{
			player.sy++;
			inn(player,25);
			return 0;
		}	
		if (x==206 && y==192 && d==UP)
		{
			player.sy++;
			town_store(player,0,2); //armor
			return 0;
		}	

		if (x==188 && y==216 && d==UP)
		{
			player.sy++;
			town_store(player,2,2); // magic
			return 0;
		}	
		if (x==198 && y==190 && d==UP)
		{
			player.sy++;
			town_store(player,1,2); //weapon
			return 0;
		}	
		if (x==151 && y==66 && d==UP)
		{
			player.sy++;
			town_store(player,2,3); //Abdra house
			return 0;
		}	

		if (x==238 && y==177 && d==UP) // entering cave2
		{
			load_screen(2,4,158);
			player.area=AREA04;
			player.inout=IN;
			return 0;
		}
		if (x==69 && y==89 && d==UP)
		{
			load_screen(2,113,123);
			player.area=SAFE;
			player.inout=IN;
			return 0;
		}
		if (x==175 && y==103 && d==DOWN)	// entering cave3
		{
			load_screen(2,65,153);
			player.area=AREA01;
			player.inout=IN;
			return 0;
		}	
		if (x==171 && y==187) // entering cave3 e1
		{
			load_screen(2,25,16);
			player.area=AREA05;
			player.inout=IN;
			return 0;
		}
		if (x==102 && y==121) // entering cave3 e1
		{
			load_screen(2,101,25);
			player.area=AREA02;
			player.inout=IN;
			return 0;
		}

	}
	if (n==2)
	{		

		if (x==108 && y==63) // entering cave3 e1
		{
			load_screen(2,143,23);
			player.area=AREA02;
			player.inout=IN;
			return 0;
		}
		if (x==101 && y==25) // entering cave3 e1
		{
			load_screen(1,102,121);
			player.area=AREA02;
			player.inout=OUT;
			return 0;
		}
		if (x==143 && y==23) // entering cave3 e1
		{
			load_screen(2,108,63);
			player.area=SAFE;
			player.inout=IN;
			return 0;
		}

		if (x==25 && y==16) // entering cave3 e1
		{
			load_screen(1,171,187);
			player.area=AREA05;
			player.inout=OUT;
			return 0;
		}

		if (x==13 && y==123 && d==DOWN)
		{
			load_screen(2,69,89);
			player.area=SAFE;
			player.inout=IN;
			return 0;
		}

		if (x==49 && y==50 && d==UP)
		{
			if (basic_message2("Do you want to Save","your game?","Yes","No")==0)
			{
				BITMAP *bmp;
				bmp=create_bitmap(640,480);
				blit(screen,bmp,0,0,0,0,640,480);
				t=file_menu(bmp,1);
				if (t<3)
				{
					save_game(t,player);
				}
				destroy_bitmap(bmp);
			}
		}		
		if (x==40 && y==83 && d==DOWN) //leaving castle courtyard
		{
			load_screen(1,127,127);
			player.area=AREA01;
			player.inout=OUT;
			return 0;
		}
		if (x==62 && y==64 && d==UP) 
		{
			player.sy++;
			inn(player,5);
			return 0;
		}	
		if (x==74 && y==55 && d==UP)
		{
			player.sy++;
			town_store(player,0,1);
			return 0;
		}	
		if (x==73 && y==68 && d==UP)
		{
			player.sy++;
			town_store(player,2,1);
			return 0;
		}	
		if (x==52 && y==68 && d==UP)
		{
			player.sy++;
			town_store(player,1,1);
			return 0;
		}	

		if (x==47 && y==42 && d==UP) // entering main castle
		{
			add_to_log("&GCastle Breah");
			add_to_log("");
			load_screen(2,115,82);
			player.area=SAFE;
			player.inout=IN;
			return 0;
		}	
		if (x==115 && y==83 && d==DOWN)// leaving main castle
		{
			load_screen(2,47,43);
			player.area=SAFE;
			player.inout=OUT;
			return 0;
		}	

		if (x==13 && y==91 && d==UP) // leaving cave1 e1
		{
			load_screen(1,174,149);
			player.area=AREA01;
			player.inout=OUT;
			return 0;
		}
		if (x==4 && y==157 && d==UP) // leaving cave1 e1
		{
			load_screen(1,238,178);
			player.area=AREA03;
			player.inout=OUT;
			return 0;
		}
		if (x==86 && y==91 && d==UP) // leaving cave1 e2
		{
			load_screen(1,183,154);
			player.area=AREA03;
			player.inout=OUT;
			return 0;
		}
		if (x==123 && y==236 && d==RIGHT)
		{
			return 2;
		}
		if (x==122 && y==236 && d==LEFT)
		{
			putpixel(mapbmp,130,243,99);
			putpixel(mapbmp,642,243,6);
			add_to_log("&WRoom is sealed");
			add_to_log("&R   Forever");
			add_to_log("");
			return 0;
		}
		if (x==65 && y==152 && d==UP) // leaving cave3 
		{
			load_screen(1,175,102);
			player.area=AREA01;
			player.inout=OUT;
			return 0;
		}

	}

	return 1;
}
	

////////////////////////////////////////////////////////////////////
void set_up_night()
{
 	int i;

	create_rgb_table(&rgb_table, (RGB*)datafile[MY_PAL].dat, NULL);
	rgb_map = &rgb_table;

	/* build a color lookup table for lighting effects */
	create_light_table(&light_table, (RGB*)datafile[MY_PAL].dat, 0, 0, 0, NULL);

	/* build a color lookup table for translucent drawing */
	create_trans_table(&trans_table, (RGB*)datafile[MY_PAL].dat, 128, 128, 128, NULL);

	set_palette((RGB*)datafile[MY_PAL].dat);

	rectfill((BITMAP*)datafile[SPOT1].dat,0,0,256,256,0);
	rectfill((BITMAP*)datafile[SPOT2].dat,0,0,256,256,0);
	for(i=0; i<256; i++)
		circlefill((BITMAP*)datafile[SPOT1].dat, 128, 128, 128-i/4, i);
	for(i=0; i<256; i++)
		circlefill((BITMAP*)datafile[SPOT2].dat, 128, 128, 64-i/4, i);

//	save_pcx("spot.pcx",(BITMAP*)datafile[SPOT].dat,(RGB*)datafile[MY_PAL].dat);
	/* select the lighting table */
	color_map = &light_table;

}


void load_my_data()
{
	//set_palette(desktop_palette);
	acquire_screen();
	textout_centre(screen,font,"Loading Please Wait...",319,229,255);
	release_screen();

	datafile	=	load_datafile("data.dat");
	button		=	load_datafile("button.dat");
	map			=	load_datafile("map.dat");
	itemfile	=	load_datafile("item.dat");
	tileset 	=	load_datafile("tileset.dat");
	charset		=	load_datafile("charset.dat");
	music		=	load_datafile("music.dat");
	
	set_up_night();

	set_palette(black_palette);
	text_mode(0);

	temp			=	create_bitmap(416,416);
	mapbmp			=	create_bitmap(1024,1024);
	mousebmp		=	create_bitmap(32,16);
	blog			=	create_bitmap(150,164);
//	srand(-1);

	srand( (unsigned)time( NULL ) );

	init_buttons();

	init_mons();
	init_player(player);


	acquire_screen();
	clear(screen);
	release_screen();



}

void clear_my_data()
{
//	int i;
	clear_keybuf();
	unload_datafile(button);
	unload_datafile(datafile);
	unload_datafile(map);
	unload_datafile(itemfile);
	unload_datafile(tileset);
	unload_datafile(charset);
	unload_datafile(music);

	uninit_player(player);

	destroy_bitmap(mapbmp);
	destroy_bitmap(temp);
	destroy_bitmap(mousebmp);
	destroy_bitmap(blog);


}
//////////////////////////////////////////////////////////////////
int basic_message2(char *text1,char *text2,char *b1,char *b2)
{
	BITMAP *bmp;
	int p,done=0,n=0,a;
	int x1,x2,l1,l2,l,w1,w2,w;

	a=2;

	bmp=create_bitmap(640,480);
	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	l1=text_length((FONT*)button[BUTTON_FONT].dat,text1);
	l2=text_length((FONT*)button[BUTTON_FONT].dat,text2);
	l=l1;
	if (l2>l1) l=l2;

	w1=text_length((FONT*)button[BUTTON_FONT].dat,b1);
	w2=text_length((FONT*)button[BUTTON_FONT].dat,b2);
	w=w1;
	if (w2>w1) w=w2;
	w=w+20;

	if (l<((w*2)+30)) 
		l=((w*2)+30);
	l=l/2;

	x1=320-l-10;
	x2=320+l+10;

	value_button(btn[BN],UP,BUTTON_BLANK,	320-w-10,255,w-10,20,1,0,b1);
	value_button(btn[BN+1],UP,BUTTON_BLANK,	330,255,w,20,0,0,b2);

	do
	{
		if (mouse_b & 1)
		{	
			mstate=DOWN;
		}			
		else			
		{
			if (mstate==DOWN)
			{
				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<100) done=1;
			}
			mstate=UP;
		}

		if (dan_key(KEY_ENTER)) 
		{
			p=check_buttons(a,-1,0);
			if (p>=BN && p<100) done=1;
		}
			
		make_window(bmp,x1,200,x2,280);

		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text1,320,210,0);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text1,319,209,COLOR_TOP);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text2,320,230,0);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text2,319,229,COLOR_TOP);

		draw_buttons(bmp,a);	

		m_save(bmp,mouse_x,mouse_y);			


		acquire_screen();
		blit(bmp,screen,0,0,0,0,640,480);
		release_screen();

		m_draw(bmp);
	}	while (!done);

	acquire_screen();
	m_draw(screen);
	release_screen();
		
	
	destroy_bitmap(bmp);

	return p-BN;
}
//////////////////////////////////////////////////////////////////

int basic_message1(char *text1,char *text2,char *b1)
{
	BITMAP *bmp;
	int p,done=0,n=0,a;
	int x1,x2,l1,l2,l,w;

	a=1;
	bmp=create_bitmap(640,480);
	
	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	l1=text_length((FONT*)button[BUTTON_FONT].dat,text1);
	l2=text_length((FONT*)button[BUTTON_FONT].dat,text2);
	l=l1;
	if (l2>l1) l=l2;

	w=text_length((FONT*)button[BUTTON_FONT].dat,b1);
	w=w+20;


	if (l<((w*2)+30)) 
		l=((w*2)+30);
	l=l/2;

	x1=320-l-10;
	x2=320+l+10;

	value_button(btn[BN],UP,BUTTON_BLANK,	320-((w-20)/2),255,w-20,20,1,0,b1);

	do
	{
		if (mouse_b & 1)
		{	
			mstate=DOWN;
		}			
		else			
		{
			if (mstate==DOWN)
			{
				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<100) done=1;
			}
			mstate=UP;
		}

		if (dan_key(KEY_ENTER)) 
		{
			p=check_buttons(a,-1,0);
			if (p>=BN && p<100) done=1;
		}
			
		make_window(bmp,x1,200,x2,280);

		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text1,320,210,0);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text1,319,209,COLOR_TOP);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text2,320,230,0);
		textout_centre(bmp,(FONT*)button[BUTTON_FONT].dat,text2,319,229,COLOR_TOP);

		draw_buttons(bmp,a);	

		m_save(bmp,mouse_x,mouse_y);			

		acquire_screen();
		blit(bmp,screen,0,0,0,0,640,480);
		release_screen();

		m_draw(bmp);
	}	while (!done);

	acquire_screen();
	m_draw(screen);
	release_screen();
		
	destroy_bitmap(bmp);

	return p-BN;
}

void basic_text(char *text1,char *text2,char *text3,char *text4,char *text5)
{
	BITMAP *bmp;
	int p,done=0,n=0,a;

	a=1;
	bmp=create_bitmap(640,480);
	
	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	value_button(btn[BN],UP,BUTTON_BLANK,	295,330,50,20,1,0,"Ok");

	do
	{
		if (mouse_b & 1)
		{	
			mstate=DOWN;
		}			
		else			
		{
			if (mstate==DOWN)
			{
				p=check_buttons(a,mouse_x,mouse_y);
				if (p>=BN && p<100) done=1;
			}
			mstate=UP;
		}

		if (dan_key(KEY_ENTER)) 
		{
			p=check_buttons(a,-1,0);
			if (p>=BN && p<100) done=1;
		}
			
		make_window(bmp,169,139,469,360);

		dan_text(bmp,text1,319,159,1);
		dan_text(bmp,text2,319,189,1);
		dan_text(bmp,text3,319,219,1);
		dan_text(bmp,text4,319,249,1);
		dan_text(bmp,text5,319,289,1);

		draw_buttons(bmp,a);	

		m_save(bmp,mouse_x,mouse_y);			

		acquire_screen();
		blit(bmp,screen,0,0,0,0,640,480);
		release_screen();

		m_draw(bmp);
	}	while (!done);

	acquire_screen();
	m_draw(screen);
	release_screen();
		
	destroy_bitmap(bmp);

}


void check_level(PLAYER_STRUCT &player)
{
	long lv[27]={0,0,25,95,250,500,1000,2500,5000,
				10000,17500,25000,50000,75000,100000,
				125000,150000,200000,250000,300000,350000,
				400000,500000,600000,700000,800000,900000};
	int l=0;


	if (player.exp>=lv[player.level+1])	l=1;

	if (l==1)
	{
		basic_message1("Your level increased","","Ok");
		player.level++;

		if (player.race==HUMAN)
		{
			player.strength++;
			player.agility++;
			player.health++;
			player.magic++;
		}
		if (player.race==DWARF)
		{
			player.strength+=2;
			player.health+=2;
		}
		if (player.race==ELF)
		{
			player.agility+=2;
			player.magic+=2;
		}
		if (player.clas==WARRIOR)
		{
			player.strength++;
		}
		if (player.clas==MAGE)
		{
			player.magic++;
		}
		if (player.clas==THIEF)
		{
			player.agility++;
		}
		distribute_points(player,2);
		refresh_stats(player);
		check_skill(player);
	}
}

void check_skill(PLAYER_STRUCT &player)
{
	int l;
	l=player.level;
//	if (player.clas==WARRIOR)
//	{
		if (l>=5)	player.skill[0]=1;
		if (l>=10)	player.skill[1]=1;
		if (l>=15)	player.skill[2]=1;
		if (l>=20)	player.skill[3]=1;
//	}
}

int do_fight(PLAYER_STRUCT &pl,MON_STRUCT &mon1)
{
	int i,t=0,h=0,dn=1;
	char msg[20];

	if (pl.clas==WARRIOR)
	{
		if (pl.skill[0]==1) dn=2;
		if (pl.skill[1]==1) dn=3;
		if (pl.skill[3]==1) dn=4;
		if (pl.skill[4]==1) dn=5;
	}
	if (pl.clas==THIEF)
	{
		if (pl.skill[3]==1) dn=2;
		if (pl.skill[4]==1) dn=3;
	}


	do
	{
		if (Random(pl.hitchance)>mon1.defense)
		{
			t=0;
			if (pl.d1>1)
			{
				for (i=0; i<pl.d1; i++)
				{
					t+=Random(pl.d2)+1;
				}
			}
			else
			{

				t=Random(pl.d2)+1;
			}

			t+=pl.d3;

			if (pl.clas==WARRIOR)
			{
				if (pl.skill[3]==1) t*=2;
			}

			mon1.life-=t;
			play_sound(SAMPLE_HIT);

			sprintf(msg,"&W%s Hit:",pl.name);
			add_to_log(msg);
			sprintf(msg,"&R  %d points",t);
			add_to_log(msg);
		}
		else
		{
			play_sound(SAMPLE_MISS);
			sprintf(msg,"&W%s Missed",pl.name);
			add_to_log(msg);

		}


		dn--;

	} while (dn>0);

	return(h);
}

int hit_back(PLAYER_STRUCT &pl,MON_STRUCT &mon1)
{
	int i,t=0;
	char msg[20];
	if (Random(mon1.hitchance)>pl.defense)
	{
		if (mon1.d1>1)
		{
			for (i=0; i<mon1.d1; i++)
			{
				t=Random(mon1.d2)+1;
			}
		}
		else
			t=Random(mon1.d2)+1;

		t+=mon1.d3;
		pl.life-=t;
		play_sound(SAMPLE_HIT);
		sprintf(msg,"&W%s Hit:",mon1.name);
		add_to_log(msg);
		sprintf(msg,"&R  %d points",t);
		add_to_log(msg);
	}
	else
	{
		play_sound(SAMPLE_MISS);
		sprintf(msg,"&W%s Missed",mon1.name);
		add_to_log(msg);
	}

	if (pl.life<=0) return 2;

	return(0);
}

int battle(int p)
{
	BITMAP *bmp,*tmp;
	MON_STRUCT	mn;
	char msg[80];
	int t,done=0,n=0,a,tr,m1,m2,tg=0,gp,ex;
	int dn=0,m;
	
	bmp=create_bitmap(640,480);
	tmp=create_bitmap(98,104);

	acquire_screen();
	blit(screen,bmp,0,0,0,0,640,480);
	release_screen();

	if (player.area==AREA01)
	{
		m1=3;m2=0;
	}
	if (player.area==AREA02)
	{
		m1=3;m2=4;
	}
	if (player.area==AREA03)
	{
		m1=5;m2=4;
	}
	if (player.area==AREA04)
	{
		m1=3;m2=8;
	}
	if (player.area==AREA05)
	{
		m1=4;m2=13;
	}

	if (player.clas==THIEF && player.skill[0]==1) 
	{
		tg=1;
	}


	m=(Random(m1)+1)+m2;

	if (p==-1)
		m=12;
	

	mn.d1			=	mon[m].d1;
	mn.d2			=	mon[m].d2;
	mn.d3			=	mon[m].d3;
	mn.defense		=	mon[m].defense;
	mn.level		=	mon[m].level;
	mn.area			=	mon[m].area;
	mn.hitchance	=	mon[m].hitchance;
	mn.gold			=	mon[m].gold;
	mn.life			=	(Random(5)+1)+(5*mn.level);


	mn.magic		=	mon[m].magic;
	strcpy(mn.name,mon[m].name);
	mn.sprx		=	mon[m].sprx;
	mn.spry		=	mon[m].spry;
	
	
	
	blit((BITMAP*)charset[MONSET_1].dat,tmp,
					mn.sprx,mn.spry,0,0,98,104);




	do
	{
		value_button(btn[BN],UP,BUTTON_BLANK,	180,334,45,20,1,0,"Fight");
		value_button(btn[BN+1],UP,BUTTON_BLANK,	230,334,45,20,0,0,"Magic");
		value_button(btn[BN+2],UP,BUTTON_BLANK,	280,334,45,20,0,0,"Use");
		value_button(btn[BN+3],UP,BUTTON_BLANK,	330,334,45,20,0,0,"Run");
		a=4;
		done=0;
		tr=0;
		do
		{
			if (mouse_b & 1)
			{	
				mstate=DOWN;
			}			
			else			
			{
				if (mstate==DOWN)
				{
					t=check_buttons(a,mouse_x,mouse_y);
					if (t>=BN && t<100) done=1;
				}
				mstate=UP;
			}	

			if (dan_key(KEY_ENTER)) 
			{
				t=check_buttons(a,-1,0);
				if (t>=BN && t<100) done=1;
			}
				
			make_window(bmp,158,68,462,372);
			blit((BITMAP*)datafile[FIGHTBACK].dat,bmp,0,0,160,70,300,300);
			draw_sprite(bmp,tmp,210,150);

			dan_text(bmp,"You are attacked by a(n)",180,90,0);
			sprintf(msg,"%s",mn.name);
			dan_text(bmp,msg,180,110,0);

			dan_text(bmp,player.name,320,260,0);
			sprintf(msg,"Life %d/%d",player.life,(player.health*2));
			dan_text(bmp,msg,320,280,0);
			sprintf(msg,"Mana %d/%d",player.mana,(player.magic*2));
			dan_text(bmp,msg,320,300,0);

			draw_sprite(bmp,tspr[0],250,270);
			draw_buttons(bmp,a);	
	
			m_save(bmp,mouse_x,mouse_y);			


			acquire_screen();
			blit(bmp,screen,0,0,0,0,640,480);
			release_screen();

			m_draw(bmp);

		}	while (!done);

		acquire_screen();
		m_draw(screen);
		release_screen();
		
		if (t-BN==0)
		{
			dn=do_fight(player,mn);
			draw_log(bmp);
			tr=1;
			if (tg>0) 
			{
				tg=0;
				tr=0;
			}
		}
		if (t-BN==1)
		{
			if (cast_spell(player,mn)==1)
			draw_log(bmp);
				tr=1;
		}
		if (t-BN==2) 
		{
			if (show_inventory(player,mn)==1)
				tr=1;
		}
		if (t-BN==3) 
		{
			dn=1;
//			if (Random(100)>90) dn=1;
//			else tr=1;
		}

		if (tr==1 && mn.life>0)
		{
			dn=hit_back(player,mn);
			draw_log(bmp);
		}

		if (mn.life<=0) 
		{
			ex=Random(3)+1+mn.level;
			gp=Random(5)+1+mn.gold;
			player.exp+=ex;
			player.gold+=gp;
			play_sound(SAMPLE_MDIE);
			sprintf(msg,"&W%s Dead",mn.name);
			add_to_log(msg);

			sprintf(msg,"&G    %d Exp",ex);
			add_to_log(msg);

			sprintf(msg,"&G    %d Gold",gp);
			add_to_log(msg);
			draw_log(bmp);
	
			check_level(player);

			dn=1;
		}

	}	while (dn==0);		
	
	destroy_bitmap(bmp);
	destroy_bitmap(tmp);
			
	add_to_log("");


	return dn-1;
}

void convert_item(ITEM_STRUCT &to,ITEM_STRUCT &from)
{
	to.cost		=	from.cost;
	to.flag1	=	from.flag1;
	to.flag2	=	from.flag2;
	to.flag3	=	from.flag3;
	to.flag4	=	from.flag4;
	to.flag5	=	from.flag5;
	to.flag6	=	from.flag6;
	to.spot		=	from.spot;
	to.spr		=	from.spr;
	to.type		=	from.type;
	to.value	=	from.value;
	strcpy(to.name,from.name);
}



int main()
{
    allegro_init();
    install_keyboard();
	install_mouse();
	install_timer();
	
    /* install a MIDI sound driver */
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) 
	{
		return 1;
	}

    set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

	LOCK_VARIABLE(x);
	LOCK_FUNCTION(inc_x);

 	install_int(inc_x, 1000);

	set_window_title("The Lost Sword of Arkane!");

	set_mouse_speed(2,2);
	show_mouse(NULL);

	load_my_data();	

	open_screen();
	
	set_palette((RGB*)datafile[MY_PAL].dat);

	main_menu();
	
	clear_my_data();


    return 0;
}

END_OF_MAIN();
